/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.iot_explorer.data_template;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import com.qcloud.iot_explorer.common.Status;
import com.qcloud.iot_explorer.utils.TXLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TXDataTemplateJson {
    public static final String TAG = "TX_TEMPLATE_JSON_1.3.0";
    private JSONArray mPropertyJson = null;
    private JSONArray mEventJson = null;
    private JSONArray mActionJson = null;
    private static final String TYPE_BOOL = "bool";
    private static final String TYPE_INT = "int";
    private static final String TYPE_FLOAT = "float";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_ENUM = "enum";
    private static final String TYPE_TIMESTAMP = "timestamp";

    TXDataTemplateJson(Context context, String jsonFileName) {
        if (Status.OK != this.registerDataTemplateJson(context, jsonFileName)) {
            Log.e((String)TAG, (String)"TXDataTemplateJson: construct json failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInputStream(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = "";
        StringBuilder stringBuilder = new StringBuilder();
        try {
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status registerDataTemplateJson(Context context, String jsonFileName) {
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        InputStream jsonInputStream = null;
        try {
            jsonInputStream = assetManager.open(jsonFileName);
            String jsonStr = this.readInputStream(jsonInputStream);
            JSONObject json = new JSONObject(jsonStr);
            this.mPropertyJson = json.getJSONArray("properties");
            this.mEventJson = json.getJSONArray("events");
            this.mActionJson = json.getJSONArray("actions");
            TXLog.d(TAG, "registerDataTemplateJson: propertyJson" + this.mPropertyJson);
            TXLog.d(TAG, "registerDataTemplateJson: eventJson" + this.mEventJson);
            TXLog.d(TAG, "registerDataTemplateJson: actionJson" + this.mActionJson);
        }
        catch (IOException e) {
            TXLog.e(TAG, "Cannot open Json Files.", e);
            Status status = Status.ERROR;
            return status;
        }
        catch (JSONException t) {
            TXLog.e(TAG, "Json file format is invalid!.", t);
            Status status = Status.ERROR;
            return status;
        }
        finally {
            if (jsonInputStream != null) {
                try {
                    jsonInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Status.OK;
    }

    private Status checkParamsValue(JSONObject valueDescribeJson, Object value) {
        try {
            String type = valueDescribeJson.getString("type");
            if (type.equals(TYPE_BOOL)) {
                if (value instanceof Integer && ((Integer)value == 0 || (Integer)value == 1)) {
                    return Status.OK;
                }
            } else if (type.equals(TYPE_INT)) {
                if (value instanceof Integer && (Integer)value >= Integer.parseInt(valueDescribeJson.getString("min")) && (Integer)value <= Integer.parseInt(valueDescribeJson.getString("max"))) {
                    return Status.OK;
                }
            } else if (type.equals(TYPE_FLOAT)) {
                if (value instanceof Double && (Double)value >= Double.parseDouble(valueDescribeJson.getString("min")) && (Double)value <= Double.parseDouble(valueDescribeJson.getString("max"))) {
                    return Status.OK;
                }
            } else if (type.equals(TYPE_STRING)) {
                if (value instanceof String && ((String)value).length() <= Integer.parseInt(valueDescribeJson.getString("max"))) {
                    return Status.OK;
                }
            } else if (type.equals(TYPE_ENUM)) {
                if (value instanceof Integer) {
                    JSONObject mapping = valueDescribeJson.getJSONObject("mapping");
                    Iterator it = mapping.keys();
                    while (it.hasNext()) {
                        if ((Integer)value != Integer.parseInt((String)it.next())) continue;
                        return Status.OK;
                    }
                }
            } else if (type.equals(TYPE_TIMESTAMP)) {
                if (value instanceof Integer) {
                    return Status.OK;
                }
            } else {
                TXLog.e(TAG, "Invalid Data Template Json, please check and replace it!");
            }
            TXLog.e(TAG, "Invalid Value, excepted" + valueDescribeJson);
        }
        catch (JSONException e) {
            TXLog.e(TAG, "Invalid Data Template Json, please check and replace it!");
        }
        return Status.PARAMETER_INVALID;
    }

    private Status checkParamsJson(JSONArray paramsDescribeJson, JSONObject paramsJson) {
        if (null == paramsJson || null == paramsDescribeJson) {
            TXLog.e(TAG, "checkParamsJson: json is null!");
            return Status.PARAMETER_INVALID;
        }
        try {
            Iterator it = paramsJson.keys();
            while (it.hasNext()) {
                int i;
                String key = (String)it.next();
                for (i = 0; i < paramsDescribeJson.length(); ++i) {
                    JSONObject jsonNode = paramsDescribeJson.getJSONObject(i);
                    if (!jsonNode.get("id").equals(key)) continue;
                    if (Status.OK == this.checkParamsValue(jsonNode.getJSONObject("define"), paramsJson.get(key))) break;
                    TXLog.e(TAG, "checkParamsJson: parameter [%s] with invalid value (may be string): " + paramsJson.get(key), key);
                    return Status.PARAMETER_INVALID;
                }
                if (i != paramsDescribeJson.length()) continue;
                TXLog.e(TAG, "checkParamsJson: no such param:" + key);
                return Status.PARAMETER_INVALID;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return Status.OK;
    }

    private Status checkActionParamsJson(JSONArray paramsDescribeJson, JSONObject paramsJson) {
        if (null == paramsJson || null == paramsDescribeJson) {
            TXLog.e(TAG, "checkParamsJson: json is null!");
            return Status.PARAMETER_INVALID;
        }
        boolean isActionExit = false;
        try {
            for (int i = 0; i < paramsDescribeJson.length(); ++i) {
                JSONObject jsonNode = paramsDescribeJson.getJSONObject(i);
                Iterator it = paramsJson.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (!jsonNode.get("id").equals(key)) continue;
                    if (Status.OK != this.checkParamsValue(jsonNode.getJSONObject("define"), paramsJson.get(key))) {
                        TXLog.e(TAG, "checkParamsJson: parameter [%s] with invalid value (may be string): " + paramsJson.get(key), key);
                        return Status.PARAMETER_INVALID;
                    }
                    isActionExit = true;
                    break;
                }
                if (!isActionExit) {
                    TXLog.e(TAG, "checkActionParamsJson: params [%s] not found, check the data template json on cloud console!", jsonNode.get("id"));
                    return Status.ERROR;
                }
                isActionExit = false;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return Status.OK;
    }

    Status checkPropertyJson(JSONObject property) {
        return this.checkParamsJson(this.mPropertyJson, property);
    }

    Status checkEventJson(String eventId, String type, JSONObject params) {
        if (null == eventId || null == type || null == params) {
            TXLog.e(TAG, "checkEventJson: parameter is null!");
            return Status.PARAMETER_INVALID;
        }
        try {
            int i;
            for (i = 0; i < this.mEventJson.length(); ++i) {
                JSONObject jsonNode = this.mEventJson.getJSONObject(i);
                if (!jsonNode.get("id").equals(eventId)) continue;
                if (jsonNode.get("type").equals(type)) {
                    return this.checkParamsJson(jsonNode.getJSONArray("params"), params);
                }
                TXLog.e(TAG, "checkEventJson: type [%s] is not matched, excepted[%s]!", type, jsonNode.get("type"));
                return Status.PARAMETER_INVALID;
            }
            if (i == this.mEventJson.length()) {
                TXLog.e(TAG, "checkEventJson: no such event:" + eventId);
                return Status.PARAMETER_INVALID;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return Status.OK;
    }

    Status checkEventsJson(JSONArray events) {
        if (null == events) {
            TXLog.e(TAG, "checkEventsJson: parameter is null!");
            return Status.PARAMETER_INVALID;
        }
        try {
            for (int i = 0; i < events.length(); ++i) {
                JSONObject jsonNode = events.getJSONObject(i);
                if (!(jsonNode.get(TYPE_TIMESTAMP) instanceof Long)) {
                    TXLog.e(TAG, "checkEventsJson: timestamp invalid! EventId:[%s].", jsonNode.getString("eventId"));
                    return Status.PARAMETER_INVALID;
                }
                if (Status.OK == this.checkEventJson(jsonNode.getString("eventId"), jsonNode.getString("type"), jsonNode.getJSONObject("params"))) continue;
                TXLog.e(TAG, "checkEventsJson: events invalid!");
                return Status.PARAMETER_INVALID;
            }
        }
        catch (JSONException e) {
            TXLog.e(TAG, "checkEventsJson: events invalid!");
            e.printStackTrace();
        }
        return Status.OK;
    }

    Status checkActionJson(String actionId, JSONObject params) {
        if (null == params || null == actionId) {
            TXLog.e(TAG, "checkActionJson: parameter is null!");
            return Status.PARAMETER_INVALID;
        }
        try {
            int i;
            for (i = 0; i < this.mActionJson.length(); ++i) {
                JSONObject jsonNode = this.mActionJson.getJSONObject(i);
                if (!jsonNode.get("id").equals(actionId)) continue;
                if (Status.OK == this.checkActionParamsJson(jsonNode.getJSONArray("input"), params)) break;
                TXLog.e(TAG, "checkActionJson: action [%s] with invalid parameter, check the data template json on cloud console!", actionId);
                return Status.PARAMETER_INVALID;
            }
            if (i == this.mActionJson.length()) {
                TXLog.e(TAG, "checkActionJson: no such action id [%s], check the data template json on cloud console!", actionId);
                return Status.PARAMETER_INVALID;
            }
        }
        catch (JSONException e) {
            TXLog.e(TAG, "checkActionJson: action message invalid!");
            e.printStackTrace();
        }
        return Status.OK;
    }

    Status checkActionReplyJson(String actionId, JSONObject response) {
        if (null == response || null == actionId) {
            TXLog.e(TAG, "checkActionJson: parameter is null!");
            return Status.PARAMETER_INVALID;
        }
        try {
            int i;
            for (i = 0; i < this.mActionJson.length(); ++i) {
                JSONObject jsonNode = this.mActionJson.getJSONObject(i);
                if (!jsonNode.get("id").equals(actionId)) continue;
                if (Status.OK == this.checkActionParamsJson(jsonNode.getJSONArray("output"), response)) break;
                TXLog.e(TAG, "checkActionReplyJson: action [%s] with invalid parameter:" + response, actionId);
                return Status.PARAMETER_INVALID;
            }
            if (i == this.mActionJson.length()) {
                TXLog.e(TAG, "checkActionReplyJson: no such action id :" + actionId);
                return Status.PARAMETER_INVALID;
            }
        }
        catch (JSONException e) {
            TXLog.e(TAG, "checkActionReplyJson: events invalid!");
            e.printStackTrace();
        }
        return Status.OK;
    }
}

