/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.iot_explorer.data_template;

import android.content.Context;
import com.qcloud.iot_explorer.common.Status;
import com.qcloud.iot_explorer.data_template.TXDataTemplate;
import com.qcloud.iot_explorer.data_template.TXDataTemplateConstants;
import com.qcloud.iot_explorer.data_template.TXDataTemplateDownStreamCallBack;
import com.qcloud.iot_explorer.mqtt.TXMqttActionCallBack;
import com.qcloud.iot_explorer.mqtt.TXMqttConnection;
import com.qcloud.iot_explorer.mqtt.TXMqttConstants;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONObject;

public class TXDataTemplateClient
extends TXMqttConnection {
    private TXDataTemplate mDataTemplate;
    public String mPropertyDownStreamTopic;

    public TXDataTemplateClient(Context context, String serverURI, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack, String jsonFileName, TXDataTemplateDownStreamCallBack downStreamCallBack) {
        super(context, serverURI, productID, deviceName, secretKey, bufferOpts, clientPersistence, callBack);
        this.mDataTemplate = new TXDataTemplate(context, this, productID, deviceName, jsonFileName, downStreamCallBack);
        this.mPropertyDownStreamTopic = this.mDataTemplate.mPropertyDownStreamTopic;
    }

    public boolean isConnected() {
        return this.getConnectStatus().equals((Object)TXMqttConstants.ConnectStatus.kConnected);
    }

    public Status subscribeTemplateTopic(TXDataTemplateConstants.TemplateSubTopic topicId, int qos) {
        return this.mDataTemplate.subscribeTemplateTopic(topicId, qos);
    }

    public Status unSubscribeTemplateTopic(TXDataTemplateConstants.TemplateSubTopic topicId) {
        return this.mDataTemplate.unSubscribeTemplateTopic(topicId);
    }

    public Status propertyReport(JSONObject property, JSONObject metadata) {
        return this.mDataTemplate.propertyReport(property, metadata);
    }

    public Status propertyGetStatus(String type, boolean showmeta) {
        return this.mDataTemplate.propertyGetStatus(type, showmeta);
    }

    public Status propertyReportInfo(JSONObject params) {
        return this.mDataTemplate.propertyReportInfo(params);
    }

    public Status propertyClearControl() {
        return this.mDataTemplate.propertyClearControl();
    }

    public Status eventSinglePost(String eventId, String type, JSONObject params) {
        return this.mDataTemplate.eventSinglePost(eventId, type, params);
    }

    public Status eventsPost(JSONArray events) {
        return this.mDataTemplate.eventsPost(events);
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        super.messageArrived(topic, message);
        this.mDataTemplate.onMessageArrived(topic, message);
    }
}

