/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.iot_explorer.data_template;

import android.content.Context;
import com.qcloud.iot_explorer.common.Status;
import com.qcloud.iot_explorer.data_template.TXDataTemplateConstants;
import com.qcloud.iot_explorer.data_template.TXDataTemplateDownStreamCallBack;
import com.qcloud.iot_explorer.data_template.TXDataTemplateJson;
import com.qcloud.iot_explorer.mqtt.TXMqttConnection;
import com.qcloud.iot_explorer.mqtt.TXMqttConstants;
import com.qcloud.iot_explorer.mqtt.TXMqttRequest;
import com.qcloud.iot_explorer.utils.TXLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TXDataTemplate {
    public static final String TAG = "TXDATATEMPLATE";
    public String mDeviceName;
    public String mProductId;
    public String mPropertyDownStreamTopic;
    private String mPropertyUptreamTopic;
    private String mEventDownStreamTopic;
    private String mEventUptreamTopic;
    private String mActionDownStreamTopic;
    private String mActionUptreamTopic;
    private TXDataTemplateDownStreamCallBack mDownStreamCallBack = null;
    private ConcurrentHashMap<String, Long> mReplyWaitList = null;
    private static AtomicInteger requestID = new AtomicInteger(0);
    private long mReplyWaitTimeout = 60000L;
    private TXDataTemplateJson mDataTemplateJson;
    private TXMqttConnection mConnection;

    public TXDataTemplate(Context context, TXMqttConnection connection, String productId, String deviceName, String jsonFileName, TXDataTemplateDownStreamCallBack downStreamCallBack) {
        this.mPropertyDownStreamTopic = "$thing/down/property/" + productId + "/" + deviceName;
        this.mPropertyUptreamTopic = "$thing/up/property/" + productId + "/" + deviceName;
        this.mEventDownStreamTopic = "$thing/down/event/" + productId + "/" + deviceName;
        this.mEventUptreamTopic = "$thing/up/event/" + productId + "/" + deviceName;
        this.mActionDownStreamTopic = "$thing/down/action/" + productId + "/" + deviceName;
        this.mActionUptreamTopic = "$thing/up/action/" + productId + "/" + deviceName;
        this.mDataTemplateJson = new TXDataTemplateJson(context, jsonFileName);
        this.mDownStreamCallBack = downStreamCallBack;
        this.mDeviceName = deviceName;
        this.mProductId = productId;
        this.mConnection = connection;
        this.mReplyWaitList = new ConcurrentHashMap();
        new checkReplyTimeoutThread().start();
    }

    private boolean isConnected() {
        return this.mConnection.getConnectStatus().equals((Object)TXMqttConstants.ConnectStatus.kConnected);
    }

    public Status subscribeTemplateTopic(TXDataTemplateConstants.TemplateSubTopic topicId, int qos) {
        String topic;
        TXMqttRequest mqttRequest = new TXMqttRequest("subscribeTopic", requestID.getAndIncrement());
        switch (topicId) {
            case PROPERTY_DOWN_STREAM_TOPIC: {
                topic = this.mPropertyDownStreamTopic;
                break;
            }
            case EVENT_DOWN_STREAM_TOPIC: {
                topic = this.mEventDownStreamTopic;
                break;
            }
            case ACTION_DOWN_STREAM_TOPIC: {
                topic = this.mActionDownStreamTopic;
                break;
            }
            default: {
                TXLog.e(TAG, "subscribeTemplateTopic: topic id invalid!" + (Object)((Object)topicId));
                return Status.PARAMETER_INVALID;
            }
        }
        Status ret = this.mConnection.subscribe(topic, qos, mqttRequest);
        if (Status.OK != ret) {
            TXLog.e(TAG, "subscribeTopic failed! " + topic);
            return ret;
        }
        return Status.OK;
    }

    public Status unSubscribeTemplateTopic(TXDataTemplateConstants.TemplateSubTopic topicId) {
        String topic;
        TXMqttRequest mqttRequest = new TXMqttRequest("subscribeTopic", requestID.getAndIncrement());
        switch (topicId) {
            case PROPERTY_DOWN_STREAM_TOPIC: {
                topic = this.mPropertyDownStreamTopic;
                break;
            }
            case EVENT_DOWN_STREAM_TOPIC: {
                topic = this.mEventDownStreamTopic;
                break;
            }
            case ACTION_DOWN_STREAM_TOPIC: {
                topic = this.mActionDownStreamTopic;
                break;
            }
            default: {
                TXLog.e(TAG, "subscribeTemplateTopic: topic id invalid!" + (Object)((Object)topicId));
                return Status.PARAMETER_INVALID;
            }
        }
        Status ret = this.mConnection.unSubscribe(topic, mqttRequest);
        if (Status.OK != ret) {
            TXLog.e(TAG, "subscribeTopic failed! " + topic);
        }
        return Status.OK;
    }

    private Status publishTemplateMessage(String clientToken, TXDataTemplateConstants.TemplatePubTopic topicId, MqttMessage message) {
        String topic;
        switch (topicId) {
            case PROPERTY_UP_STREAM_TOPIC: {
                topic = this.mPropertyUptreamTopic;
                break;
            }
            case EVENT_UP_STREAM_TOPIC: {
                topic = this.mEventUptreamTopic;
                break;
            }
            case ACTION_UP_STREAM_TOPIC: {
                topic = this.mActionUptreamTopic;
                break;
            }
            default: {
                TXLog.e(TAG, "publishTemplateMessage: topic id invalid!" + (Object)((Object)topicId));
                return Status.PARAMETER_INVALID;
            }
        }
        if (this.isConnected()) {
            Status ret = this.mConnection.publish(topic, message, null);
            if (Status.OK == ret) {
                if (null != clientToken) {
                    this.mReplyWaitList.put(clientToken, System.currentTimeMillis());
                }
                return Status.OK;
            }
            return ret;
        }
        TXLog.e(TAG, "publishTemplateMessage: failed! Mqtt disconnected!");
        return Status.MQTT_NO_CONN;
    }

    public Status propertyReport(JSONObject property, JSONObject metadata) {
        if (Status.OK != this.mDataTemplateJson.checkPropertyJson(property)) {
            TXLog.e(TAG, "propertyReport: invalid property json!");
            return Status.PARAMETER_INVALID;
        }
        JSONObject object = new JSONObject();
        String clientToken = this.mProductId + this.mDeviceName + String.valueOf(requestID.getAndIncrement());
        try {
            object.put("method", (Object)"report");
            object.put("clientToken", (Object)clientToken);
            object.put("timestamp", System.currentTimeMillis());
            object.put("params", (Object)property);
            if (null != metadata) {
                object.put("metadata", (Object)metadata);
            }
        }
        catch (Exception e) {
            TXLog.e(TAG, "propertyReport: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(object.toString().getBytes());
        return this.publishTemplateMessage(clientToken, TXDataTemplateConstants.TemplatePubTopic.PROPERTY_UP_STREAM_TOPIC, message);
    }

    public Status propertyGetStatus(String type, boolean showmeta) {
        if (!type.equals("report") && !type.equals("control")) {
            TXLog.e(TAG, "propertyGetStatus: invalid type[%s]!", type);
            return Status.PARAMETER_INVALID;
        }
        JSONObject object = new JSONObject();
        String clientToken = this.mProductId + this.mDeviceName + String.valueOf(requestID.getAndIncrement());
        try {
            object.put("method", (Object)"get_status");
            object.put("clientToken", (Object)clientToken);
            object.put("type", (Object)type);
            if (showmeta) {
                object.put("showmeta", 1);
            } else {
                object.put("showmeta", 0);
            }
        }
        catch (Exception e) {
            TXLog.e(TAG, "propertyGetStatus: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(object.toString().getBytes());
        return this.publishTemplateMessage(clientToken, TXDataTemplateConstants.TemplatePubTopic.PROPERTY_UP_STREAM_TOPIC, message);
    }

    public Status propertyReportInfo(JSONObject params) {
        JSONObject object = new JSONObject();
        String clientToken = this.mProductId + this.mDeviceName + String.valueOf(requestID.getAndIncrement());
        try {
            object.put("method", (Object)"report_info");
            object.put("clientToken", (Object)clientToken);
            object.put("params", (Object)params);
        }
        catch (Exception e) {
            TXLog.e(TAG, "propertyReportInfo: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(object.toString().getBytes());
        return this.publishTemplateMessage(clientToken, TXDataTemplateConstants.TemplatePubTopic.PROPERTY_UP_STREAM_TOPIC, message);
    }

    public Status propertyClearControl() {
        JSONObject object = new JSONObject();
        String clientToken = this.mProductId + this.mDeviceName + String.valueOf(requestID.getAndIncrement());
        try {
            object.put("method", (Object)"clear_control");
            object.put("clientToken", (Object)clientToken);
        }
        catch (Exception e) {
            TXLog.e(TAG, "propertyClearControl: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(object.toString().getBytes());
        return this.publishTemplateMessage(clientToken, TXDataTemplateConstants.TemplatePubTopic.PROPERTY_UP_STREAM_TOPIC, message);
    }

    public Status eventSinglePost(String eventId, String type, JSONObject params) {
        if (Status.OK != this.mDataTemplateJson.checkEventJson(eventId, type, params)) {
            TXLog.e(TAG, "eventSinglePost: invalid parameters!");
            return Status.PARAMETER_INVALID;
        }
        JSONObject object = new JSONObject();
        String clientToken = this.mProductId + this.mDeviceName + String.valueOf(requestID.getAndIncrement());
        long timestamp = System.currentTimeMillis();
        try {
            object.put("method", (Object)"event_post");
            object.put("clientToken", (Object)clientToken);
            object.put("eventId", (Object)eventId);
            object.put("type", (Object)type);
            object.put("timestamp", timestamp);
            object.put("params", (Object)params);
        }
        catch (Exception e) {
            TXLog.e(TAG, "eventSinglePost: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(object.toString().getBytes());
        return this.publishTemplateMessage(clientToken, TXDataTemplateConstants.TemplatePubTopic.EVENT_UP_STREAM_TOPIC, message);
    }

    public Status eventsPost(JSONArray events) {
        if (Status.OK != this.mDataTemplateJson.checkEventsJson(events)) {
            TXLog.e(TAG, "eventsPost: invalid parameters!");
            return Status.PARAMETER_INVALID;
        }
        JSONObject object = new JSONObject();
        String clientToken = this.mProductId + this.mDeviceName + String.valueOf(requestID.getAndIncrement());
        try {
            object.put("method", (Object)"events_post");
            object.put("clientToken", (Object)clientToken);
            object.put("events", (Object)events);
        }
        catch (Exception e) {
            TXLog.e(TAG, "eventsPost: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(object.toString().getBytes());
        return this.publishTemplateMessage(clientToken, TXDataTemplateConstants.TemplatePubTopic.EVENT_UP_STREAM_TOPIC, message);
    }

    private Status controlReply(String clientToken, int code, String status) {
        JSONObject object = new JSONObject();
        try {
            object.put("method", (Object)"control_reply");
            object.put("clientToken", (Object)clientToken);
            object.put("code", code);
            object.put("status", (Object)status);
        }
        catch (Exception e) {
            TXLog.e(TAG, "actionReply: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(1);
        message.setPayload(object.toString().getBytes());
        return this.publishTemplateMessage(null, TXDataTemplateConstants.TemplatePubTopic.PROPERTY_UP_STREAM_TOPIC, message);
    }

    private Status actionReply(String clientToken, int code, String status, JSONObject response) {
        JSONObject object = new JSONObject();
        try {
            object.put("method", (Object)"action_reply");
            object.put("clientToken", (Object)clientToken);
            object.put("code", code);
            object.put("status", (Object)status);
            object.put("response", (Object)response);
        }
        catch (Exception e) {
            TXLog.e(TAG, "actionReply: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(1);
        message.setPayload(object.toString().getBytes());
        return this.publishTemplateMessage(null, TXDataTemplateConstants.TemplatePubTopic.ACTION_UP_STREAM_TOPIC, message);
    }

    private void handleReply(MqttMessage message, boolean isGetStatus) {
        try {
            JSONObject jsonObj = new JSONObject(new String(message.getPayload()));
            String clientToken = jsonObj.getString("clientToken");
            Long timestamp = this.mReplyWaitList.get(clientToken);
            if (null == timestamp) {
                TXLog.e(TAG, "handleReply: client token [%s] not found!", clientToken);
                return;
            }
            if (System.currentTimeMillis() - timestamp > this.mReplyWaitTimeout) {
                TXLog.e(TAG, "handle_reply: reply timeout! ClientToken:" + clientToken);
            } else {
                int code = jsonObj.getInt("code");
                if (0 == code) {
                    TXLog.d(TAG, "handle_reply: reply OK! ClientToken:" + clientToken);
                } else {
                    TXLog.e(TAG, "handle_reply: reply failed! ClientToken:" + clientToken + ",code:" + code);
                }
            }
            if (null != this.mDownStreamCallBack && !isGetStatus) {
                this.mDownStreamCallBack.onReplyCallBack(new String(message.getPayload()));
            }
            this.mReplyWaitList.remove(clientToken);
        }
        catch (JSONException e) {
            TXLog.e(TAG, "handle_reply: failed! Message[ %s ] is not vaild!", message);
        }
    }

    private void onPropertyMessageArrivedCallBack(MqttMessage message) {
        TXLog.d(TAG, "property down stream message received " + message);
        try {
            JSONObject jsonObj = new JSONObject(new String(message.getPayload()));
            String method = jsonObj.getString("method");
            if (!(method.equals("report_reply") || method.equals("control") || method.equals("get_status_reply") || method.equals("clear_control_reply") || method.equals("report_info_reply"))) {
                TXLog.e(TAG, "onPropertyCallBack: invalid method:" + method);
                return;
            }
            if (method.equals("control")) {
                if (null != this.mDownStreamCallBack) {
                    JSONObject result = this.mDownStreamCallBack.onControlCallBack(jsonObj.getJSONObject("params"));
                    if (Status.OK != this.controlReply(jsonObj.getString("clientToken"), result.getInt("code"), result.getString("status"))) {
                        TXLog.e(TAG, "control reply failed!");
                    }
                }
            } else if (method.equals("get_status_reply")) {
                JSONObject data = jsonObj.getJSONObject("data");
                if (null != this.mDownStreamCallBack) {
                    this.handleReply(message, true);
                    this.mDownStreamCallBack.onGetStatusReplyCallBack(data);
                }
            } else {
                this.handleReply(message, false);
            }
        }
        catch (Exception e) {
            TXLog.e(TAG, "onPropertyMessageArrivedCallBack: invalid message: " + message);
        }
    }

    private void onEventMessageArrivedCallBack(MqttMessage message) {
        TXLog.d(TAG, "event down stream message received : " + message);
        try {
            JSONObject jsonObj = new JSONObject(new String(message.getPayload()));
            String method = jsonObj.getString("method");
            if (!method.equals("event_reply") && !method.equals("events_reply")) {
                TXLog.e(TAG, "onEventMessageArrivedCallBack: invalid method:" + method);
                return;
            }
            this.handleReply(message, false);
        }
        catch (Exception e) {
            TXLog.e(TAG, "onEventMessageArrivedCallBack: invalid message:" + message);
        }
    }

    private void onActionMessageArrivedCallBack(MqttMessage message) {
        TXLog.d(TAG, "action down stream message received : " + message);
        try {
            JSONObject jsonObj = new JSONObject(new String(message.getPayload()));
            String method = jsonObj.getString("method");
            if (!method.equals("action")) {
                TXLog.e(TAG, "onActionMessageArrivedCallBack: invalid method:" + method);
                return;
            }
            if (null != this.mDownStreamCallBack) {
                JSONObject params;
                String actionId = jsonObj.getString("actionId");
                if (Status.OK != this.mDataTemplateJson.checkActionJson(actionId, params = jsonObj.getJSONObject("params"))) {
                    TXLog.e(TAG, "onActionMessageArrivedCallBack: invalid action message:" + message);
                    return;
                }
                JSONObject result = this.mDownStreamCallBack.onActionCallBack(jsonObj.getString("actionId"), jsonObj.getJSONObject("params"));
                JSONObject response = result.getJSONObject("response");
                if (Status.OK != this.mDataTemplateJson.checkActionReplyJson(actionId, response)) {
                    TXLog.e(TAG, "onActionMessageArrivedCallBack: invalid action reply message:" + response);
                    return;
                }
                if (Status.OK != this.actionReply(jsonObj.getString("clientToken"), result.getInt("code"), result.getString("status"), response)) {
                    TXLog.e(TAG, "action reply failed!");
                }
            }
        }
        catch (Exception e) {
            TXLog.e(TAG, "onActionMessageArrivedCallBack: invalid message:" + message);
        }
    }

    public void onMessageArrived(String topic, MqttMessage message) throws Exception {
        if (topic.equals(this.mPropertyDownStreamTopic)) {
            this.onPropertyMessageArrivedCallBack(message);
        } else if (topic.equals(this.mEventDownStreamTopic)) {
            this.onEventMessageArrivedCallBack(message);
        } else if (topic.equals(this.mActionDownStreamTopic)) {
            this.onActionMessageArrivedCallBack(message);
        }
    }

    static /* synthetic */ ConcurrentHashMap access$100(TXDataTemplate x0) {
        return x0.mReplyWaitList;
    }

    static /* synthetic */ long access$200(TXDataTemplate x0) {
        return x0.mReplyWaitTimeout;
    }

    private class checkReplyTimeoutThread
    extends Thread {
        private checkReplyTimeoutThread() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) lbl-1000:
            // 5 sources

            {
                for (Map.Entry<K, V> entry : TXDataTemplate.access$100(TXDataTemplate.this).entrySet()) {
                    if (System.currentTimeMillis() - (Long)entry.getValue() <= TXDataTemplate.access$200(TXDataTemplate.this)) continue;
                    TXLog.e("TXDATATEMPLATE", "Reply timeout. Client token:" + (String)entry.getKey());
                    TXDataTemplate.access$100(TXDataTemplate.this).remove(entry.getKey());
                }
                try {
                    Thread.sleep(TXDataTemplate.access$200(TXDataTemplate.this));
                    ** continue;
                }
                catch (InterruptedException e) {
                    TXLog.e("TXDATATEMPLATE", "The thread has been interrupted");
                    continue;
                }
                break;
            }
        }
    }
}

