/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.RootNode;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class XpathFilterElement
implements TreeWalkerFilter {
    private final Pattern fileRegexp;
    private final String filePattern;
    private final Pattern checkRegexp;
    private final String checkPattern;
    private final Pattern messageRegexp;
    private final String messagePattern;
    private final String moduleId;
    private final XPathExpression xpathExpression;
    private final String xpathQuery;

    public XpathFilterElement(String files, String checks, String message, String moduleId, String query) {
        this.filePattern = files;
        this.fileRegexp = files == null ? null : Pattern.compile(files);
        this.checkPattern = checks;
        this.checkRegexp = checks == null ? null : CommonUtil.createPattern(checks);
        this.messagePattern = message;
        this.messageRegexp = message == null ? null : Pattern.compile(message);
        this.moduleId = moduleId;
        this.xpathQuery = query;
        if (this.xpathQuery == null) {
            this.xpathExpression = null;
        } else {
            XPathEvaluator xpathEvaluator = new XPathEvaluator(Configuration.newConfiguration());
            try {
                this.xpathExpression = xpathEvaluator.createExpression(this.xpathQuery);
            }
            catch (XPathException ex) {
                throw new IllegalArgumentException("Unexpected xpath query: " + this.xpathQuery, ex);
            }
        }
    }

    public XpathFilterElement(Pattern files, Pattern checks, Pattern message, String moduleId, String query) {
        if (files == null) {
            this.filePattern = null;
            this.fileRegexp = null;
        } else {
            this.filePattern = files.pattern();
            this.fileRegexp = files;
        }
        if (checks == null) {
            this.checkPattern = null;
            this.checkRegexp = null;
        } else {
            this.checkPattern = checks.pattern();
            this.checkRegexp = checks;
        }
        if (message == null) {
            this.messagePattern = null;
            this.messageRegexp = null;
        } else {
            this.messagePattern = message.pattern();
            this.messageRegexp = message;
        }
        this.moduleId = moduleId;
        this.xpathQuery = query;
        if (this.xpathQuery == null) {
            this.xpathExpression = null;
        } else {
            XPathEvaluator xpathEvaluator = new XPathEvaluator(Configuration.newConfiguration());
            try {
                this.xpathExpression = xpathEvaluator.createExpression(this.xpathQuery);
            }
            catch (XPathException ex) {
                throw new IllegalArgumentException("Incorrect xpath query: " + this.xpathQuery, ex);
            }
        }
    }

    @Override
    public boolean accept(TreeWalkerAuditEvent event) {
        return !this.isFileNameAndModuleAndModuleNameMatching(event) || !this.isMessageNameMatching(event) || !this.isXpathQueryMatching(event);
    }

    private boolean isFileNameAndModuleAndModuleNameMatching(TreeWalkerAuditEvent event) {
        return !(event.getFileName() == null || this.fileRegexp != null && !this.fileRegexp.matcher(event.getFileName()).find() || event.getViolation() == null || this.moduleId != null && !this.moduleId.equals(event.getModuleId()) || this.checkRegexp != null && !this.checkRegexp.matcher(event.getSourceName()).find());
    }

    private boolean isMessageNameMatching(TreeWalkerAuditEvent event) {
        return this.messageRegexp == null || this.messageRegexp.matcher(event.getMessage()).find();
    }

    private boolean isXpathQueryMatching(TreeWalkerAuditEvent event) {
        boolean isMatching;
        if (this.xpathExpression == null) {
            isMatching = true;
        } else {
            AbstractNode abstractNode;
            isMatching = false;
            List nodes = this.getItems(event).stream().map(AbstractNode.class::cast).collect(Collectors.toList());
            Iterator iterator = nodes.iterator();
            while (iterator.hasNext() && !(isMatching = (abstractNode = (AbstractNode)iterator.next()).getTokenType() == event.getTokenType() && abstractNode.getLineNumber() == event.getLine() && abstractNode.getColumnNumber() == event.getColumnCharIndex())) {
            }
        }
        return isMatching;
    }

    private List<Item> getItems(TreeWalkerAuditEvent event) {
        List items;
        RootNode rootNode = event.getRootAst() == null ? null : new RootNode(event.getRootAst());
        try {
            XPathDynamicContext xpathDynamicContext = this.xpathExpression.createDynamicContext((Item)rootNode);
            items = this.xpathExpression.evaluate(xpathDynamicContext);
        }
        catch (XPathException ex) {
            throw new IllegalStateException("Cannot initialize context and evaluate query: " + this.xpathQuery, ex);
        }
        return items;
    }

    public int hashCode() {
        return Objects.hash(this.filePattern, this.checkPattern, this.messagePattern, this.moduleId, this.xpathQuery);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        XpathFilterElement xpathFilter = (XpathFilterElement)other;
        return Objects.equals(this.filePattern, xpathFilter.filePattern) && Objects.equals(this.checkPattern, xpathFilter.checkPattern) && Objects.equals(this.messagePattern, xpathFilter.messagePattern) && Objects.equals(this.moduleId, xpathFilter.moduleId) && Objects.equals(this.xpathQuery, xpathFilter.xpathQuery);
    }
}

