/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.filters.CsvFilter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Objects;
import java.util.regex.Pattern;

public class SuppressElement
implements Filter {
    private final Pattern fileRegexp;
    private final String filePattern;
    private Pattern checkRegexp;
    private String checkPattern;
    private String moduleId;
    private CsvFilter lineFilter;
    private String linesCsv;
    private CsvFilter columnFilter;
    private String columnsCsv;

    public SuppressElement(String files) {
        this.filePattern = files;
        this.fileRegexp = Pattern.compile(files);
    }

    public void setChecks(String checks) {
        this.checkPattern = checks;
        this.checkRegexp = CommonUtils.createPattern(checks);
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setLines(String lines) {
        this.linesCsv = lines;
        this.lineFilter = lines == null ? null : new CsvFilter(lines);
    }

    public void setColumns(String columns) {
        this.columnsCsv = columns;
        this.columnFilter = columns == null ? null : new CsvFilter(columns);
    }

    @Override
    public boolean accept(AuditEvent event) {
        return this.isFileNameAndModuleNotMatching(event) || this.isLineAndColumnMatch(event);
    }

    private boolean isFileNameAndModuleNotMatching(AuditEvent event) {
        return event.getFileName() == null || !this.fileRegexp.matcher(event.getFileName()).find() || event.getLocalizedMessage() == null || this.moduleId != null && !this.moduleId.equals(event.getModuleId()) || this.checkRegexp != null && !this.checkRegexp.matcher(event.getSourceName()).find();
    }

    private boolean isLineAndColumnMatch(AuditEvent event) {
        return !(this.lineFilter == null && this.columnFilter == null || this.lineFilter != null && this.lineFilter.accept(event.getLine()) || this.columnFilter != null && this.columnFilter.accept(event.getColumn()));
    }

    public int hashCode() {
        return Objects.hash(this.filePattern, this.checkPattern, this.moduleId, this.linesCsv, this.columnsCsv);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SuppressElement suppressElement = (SuppressElement)other;
        return Objects.equals(this.filePattern, suppressElement.filePattern) && Objects.equals(this.checkPattern, suppressElement.checkPattern) && Objects.equals(this.moduleId, suppressElement.moduleId) && Objects.equals(this.linesCsv, suppressElement.linesCsv) && Objects.equals(this.columnsCsv, suppressElement.columnsCsv);
    }
}

