/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.regex.Pattern;

public class LocalVariableNameCheck
extends AbstractNameCheck {
    private static final Pattern SINGLE_CHAR = Pattern.compile("^[a-z]$");
    private boolean allowOneCharVarInForLoop;

    public LocalVariableNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public final void setAllowOneCharVarInForLoop(boolean allow) {
        this.allowOneCharVarInForLoop = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    protected final boolean mustCheckName(DetailAST ast) {
        DetailAST modifiersAST;
        boolean isFinal;
        String variableName;
        boolean result = this.allowOneCharVarInForLoop && LocalVariableNameCheck.isForLoopVariable(ast) ? !SINGLE_CHAR.matcher(variableName = ast.findFirstToken(58).getText()).find() : !(isFinal = (modifiersAST = ast.findFirstToken(5)).branchContains(39)) && ScopeUtils.isLocalVariableDef(ast);
        return result;
    }

    private static boolean isForLoopVariable(DetailAST variableDef) {
        int parentType = variableDef.getParent().getType();
        return parentType == 35 || parentType == 156;
    }
}

