/*
 * Decompiled with CFR 0.152.
 */
package com.pswidersk.gradle.terraform;

import com.pswidersk.gradle.terraform.TerraformPluginUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/pswidersk/gradle/terraform/TerraformSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "terraformSetupDir", "Ljava/io/File;", "downloadTerraformPackage", "", "terraformPackage", "terraformVersion", "", "setup", "terraform-gradle-plugin"})
public class TerraformSetupTask
extends DefaultTask {
    private final File terraformSetupDir;

    @TaskAction
    public final void setup() {
        String os = TerraformPluginUtilsKt.os();
        String arch = TerraformPluginUtilsKt.arch();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String terraformVersion = (String)TerraformPluginUtilsKt.getTerraformPlugin(project).getTerraformVersion().get();
        this.terraformSetupDir.mkdirs();
        File terraformPackage = FilesKt.resolve((File)this.terraformSetupDir, (String)("terraform_" + terraformVersion + '_' + os + '_' + arch + ".zip"));
        String string = terraformVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"terraformVersion");
        this.downloadTerraformPackage(terraformPackage, string);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        project2.getLogger().quiet("Unzipping package to setup dir: " + this.terraformSetupDir + " ...");
        this.getProject().copy((Action)new Action<CopySpec>(this, terraformPackage){
            final /* synthetic */ TerraformSetupTask this$0;
            final /* synthetic */ File $terraformPackage;

            public final void execute(CopySpec it) {
                it.from(new Object[]{this.this$0.getProject().zipTree((Object)this.$terraformPackage)});
                it.into((Object)TerraformSetupTask.access$getTerraformSetupDir$p(this.this$0));
            }
            {
                this.this$0 = terraformSetupTask;
                this.$terraformPackage = file;
            }
        });
        terraformPackage.delete();
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        project3.getLogger().quiet("Terraform setup complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadTerraformPackage(File terraformPackage, String terraformVersion) {
        URL terraformArchiveInputStream = new URL("https://releases.hashicorp.com/terraform/" + terraformVersion + '/' + terraformPackage.getName());
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().quiet("Downloading terraform from: " + terraformArchiveInputStream + " ...");
        Closeable closeable = terraformArchiveInputStream.openStream();
        boolean bl = false;
        Throwable throwable = null;
        try {
            long l;
            InputStream inputStream = (InputStream)closeable;
            boolean bl2 = false;
            Object object = terraformPackage;
            boolean bl3 = false;
            object = new FileOutputStream((File)object);
            bl3 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)object;
                boolean bl4 = false;
                InputStream inputStream2 = inputStream;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"inputStream");
                l = ByteStreamsKt.copyTo$default((InputStream)inputStream2, (OutputStream)outputStream, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public TerraformSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Object object = TerraformPluginUtilsKt.getTerraformPlugin(project2).getTerraformVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.terraformPlugin.terraformVersion.get()");
        this.terraformSetupDir = TerraformPluginUtilsKt.terraformSetupDir(project, (String)object);
        this.setGroup("terraform");
        this.setDescription("Terraform setup task to install terraform client");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                return !terraformSetupDir.exists();
            }
        });
    }
}

