/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.FileLineMatch;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.MatchingLinesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IGrepDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class GrepDelegator
extends BaseDelegator
implements IGrepDelegator {
    public GrepDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileLineMatch> getMatchingLines(List<IFileSpec> fileSpecs, String pattern, MatchingLinesOptions options) throws P4JavaException {
        return this.getMatchingLines(fileSpecs, pattern, null, options);
    }

    @Override
    public List<IFileLineMatch> getMatchingLines(@Nonnull List<IFileSpec> fileSpecs, @Nonnull String pattern, @Nullable List<String> infoLines, MatchingLinesOptions options) throws P4JavaException {
        Validate.notNull(fileSpecs);
        Validate.notBlank((CharSequence)pattern, (String)"Match pattern string shouldn't null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GREP, Parameters.processParameters((Options)options, fileSpecs, "-e" + pattern, (IServer)this.server), null);
        ArrayList<IFileLineMatch> specList = new ArrayList<IFileLineMatch>();
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                String message = ResultMapParser.getErrorStr(map);
                P4JavaExceptions.throwRequestExceptionIfConditionFails(StringUtils.isBlank((CharSequence)message), P4ResultMapUtils.parseCode0ErrorString(map), message, new Object[0]);
                message = ResultMapParser.getErrorOrInfoStr(map);
                if (StringUtils.isBlank((CharSequence)message)) {
                    specList.add(new FileLineMatch(map));
                    continue;
                }
                if (!ObjectUtils.nonNull(infoLines)) continue;
                infoLines.add(message);
            }
        }
        return specList;
    }
}

