/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.Log;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.server.ServerFactory;
import com.perforce.p4java.util.FilesHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthHelper {
    protected static final String SERVER_ADDRESS_MAP_KEY = "serverAddress";
    protected static final String USER_NAME_MAP_KEY = "userName";
    protected static final String AUTH_VALUE_MAP_KEY = "authValue";
    public static final int DEFAULT_LOCK_TRY = 100;
    public static final long DEFAULT_LOCK_DELAY = 300000L;
    public static final long DEFAULT_LOCK_WAIT = 1000L;

    protected static synchronized Map<String, String> getMemoryEntry(String userName, String serverAddress, Map<String, String> authMap) {
        HashMap<String, String> entryMap = null;
        if (userName != null && serverAddress != null && authMap != null) {
            String prefix;
            if (serverAddress.lastIndexOf(58) == -1) {
                serverAddress = "localhost:" + serverAddress;
            }
            if (authMap.containsKey(prefix = serverAddress + "=" + userName)) {
                String authValue = authMap.get(prefix);
                entryMap = new HashMap<String, String>();
                entryMap.put(SERVER_ADDRESS_MAP_KEY, serverAddress);
                entryMap.put(USER_NAME_MAP_KEY, userName);
                entryMap.put(AUTH_VALUE_MAP_KEY, authValue);
            }
        }
        return entryMap;
    }

    protected static synchronized List<Map<String, String>> getMemoryEntries(Map<String, String> authMap) {
        ArrayList<Map<String, String>> authList = new ArrayList<Map<String, String>>();
        if (authMap != null) {
            for (Map.Entry<String, String> entry : authMap.entrySet()) {
                int colon;
                String line = entry.getKey() + ":" + entry.getValue();
                int equals = line.indexOf(61);
                if (equals == -1 || (colon = line.indexOf(58, equals)) == -1 || colon + 1 >= line.length()) continue;
                String serverAddress = line.substring(0, equals);
                String userName = line.substring(equals + 1, colon);
                String authValue = line.substring(colon + 1);
                HashMap<String, String> entryMap = new HashMap<String, String>();
                entryMap.put(SERVER_ADDRESS_MAP_KEY, serverAddress);
                entryMap.put(USER_NAME_MAP_KEY, userName);
                entryMap.put(AUTH_VALUE_MAP_KEY, authValue);
                authList.add(entryMap);
            }
        }
        return authList;
    }

    protected static synchronized void saveMemoryEntry(String userName, String serverAddress, String authValue, Map<String, String> authMap) {
        if (userName != null && serverAddress != null && authMap != null) {
            if (serverAddress.lastIndexOf(58) == -1) {
                serverAddress = "localhost:" + serverAddress;
            }
            String prefix = serverAddress + "=" + userName;
            if (authValue != null) {
                authMap.put(prefix, authValue);
            } else if (authMap.containsKey(prefix)) {
                authMap.remove(prefix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized List<Map<String, String>> getFileEntries(File authFile) throws IOException {
        ArrayList<Map<String, String>> authList = new ArrayList<Map<String, String>>();
        if (authFile != null && authFile.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(authFile));
            try {
                String line = reader.readLine();
                while (line != null) {
                    int colon;
                    int equals = line.indexOf(61);
                    if (equals != -1 && (colon = line.indexOf(58, equals)) != -1 && colon + 1 < line.length()) {
                        String serverAddress = line.substring(0, equals);
                        String userName = line.substring(equals + 1, colon);
                        String authValue = line.substring(colon + 1);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(SERVER_ADDRESS_MAP_KEY, serverAddress);
                        map.put(USER_NAME_MAP_KEY, userName);
                        map.put(AUTH_VALUE_MAP_KEY, authValue);
                        authList.add(map);
                    }
                    line = reader.readLine();
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            {
            }
        }
        return authList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void saveFileEntry(String userName, String serverAddress, String authValue, File authFile, int lockTry, long lockDelay, long lockWait) throws IOException {
        block28: {
            Object v1;
            boolean renamed;
            File tempAuth;
            block26: {
                File lockFile;
                if (userName == null || serverAddress == null || authFile == null) break block28;
                if (!authFile.exists()) {
                    FilesHelper.mkdirs(authFile);
                }
                if (!AbstractAuthHelper.createLockFile(lockFile = new File(authFile.getAbsolutePath() + ".lck"), lockTry, lockDelay, lockWait)) {
                    return;
                }
                if (serverAddress.lastIndexOf(58) == -1) {
                    serverAddress = "localhost:" + serverAddress;
                }
                String prefix = serverAddress + "=" + userName + ":";
                String value = null;
                if (authValue != null) {
                    value = prefix + authValue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(authFile));
                }
                catch (FileNotFoundException fnfe) {
                    reader = null;
                }
                tempAuth = File.createTempFile("p4auth", ".txt");
                PrintWriter writer = new PrintWriter(tempAuth, "utf-8");
                renamed = false;
                try {
                    boolean processed = false;
                    if (reader != null) {
                        String line = reader.readLine();
                        while (line != null) {
                            if (!processed && line.startsWith(prefix)) {
                                if (value != null) {
                                    writer.println(value);
                                }
                                processed = true;
                            } else {
                                writer.println(line);
                            }
                            line = reader.readLine();
                        }
                    }
                    if (!processed && value != null) {
                        writer.println(value);
                    }
                    Object var19_17 = null;
                    writer.flush();
                    writer.close();
                    if (reader == null) break block26;
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var19_18 = null;
                    writer.flush();
                    writer.close();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    try {
                        renamed = tempAuth.renameTo(authFile);
                        if (!renamed) {
                            renamed = FilesHelper.copy(tempAuth, authFile);
                        }
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var22_24;
                        v0 = var22_24 = null;
                    }
                    if (tempAuth.exists() && !tempAuth.delete()) {
                        Log.warn("Unable to delete temp auth file '" + tempAuth.getPath() + "' in AbstractAuthHelper.saveFileEntry() -- unknown cause");
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                renamed = tempAuth.renameTo(authFile);
                if (!renamed) {
                    renamed = FilesHelper.copy(tempAuth, authFile);
                }
                v1 = null;
            }
            catch (Throwable throwable) {
                Object var22_23;
                v1 = var22_23 = null;
            }
            if (tempAuth.exists() && !tempAuth.delete()) {
                Log.warn("Unable to delete temp auth file '" + tempAuth.getPath() + "' in AbstractAuthHelper.saveFileEntry() -- unknown cause");
            }
            AbstractAuthHelper.updateReadBit(authFile);
            if (!renamed) {
                throw new IOException("P4 auth file: " + authFile.getAbsolutePath() + " could not be overwritten.");
            }
        }
    }

    private static void updateReadBit(File file) throws IOException {
        if (file != null) {
            file.setReadOnly();
            ISystemFileCommandsHelper helper = ServerFactory.getRpcFileSystemHelper();
            if (helper == null) {
                helper = SysFileHelperBridge.getSysFileCommands();
            }
            if (helper != null) {
                helper.setOwnerReadOnly(file.getAbsolutePath());
            }
        }
    }

    private static boolean createLockFile(File lockFile, int lockTry, long lockDelay, long lockWait) {
        lockTry = lockTry < 1 ? 100 : lockTry;
        lockDelay = lockDelay < 1L ? 300000L : lockDelay;
        long l = lockWait = lockWait < 1L ? 1000L : lockWait;
        if (lockFile != null) {
            while (lockTry-- > 0) {
                if (lockFile.lastModified() > 0L) {
                    if (System.currentTimeMillis() - lockFile.lastModified() > lockDelay) {
                        if (lockFile.delete()) continue;
                        lockFile.deleteOnExit();
                        Log.error("Error deleting auth lock file: " + lockFile.getAbsolutePath());
                        return false;
                    }
                    try {
                        Thread.sleep(lockWait);
                    }
                    catch (InterruptedException e) {
                        Log.error("Error waiting for auth lock file: " + e.getLocalizedMessage());
                    }
                    continue;
                }
                try {
                    if (!lockFile.createNewFile()) continue;
                    return true;
                }
                catch (IOException e) {
                    Log.error("Error creating new auth lock file: " + lockFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
                }
            }
            Log.error("Error creating new auth lock file after retries: " + lockFile.getAbsolutePath());
        }
        return false;
    }
}

