/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.Log;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class SymbolicLinkHelper
implements ISystemFileCommandsHelper {
    public static final String FILE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FILE_SYSTEMS_CLASS_NAME = "java.nio.file.FileSystems";
    public static final String FILE_SYSTEM_CLASS_NAME = "java.nio.file.FileSystem";
    public static final String PATH_CLASS_NAME = "java.nio.file.Path";
    public static final String FILES_CLASS_NAME = "java.nio.file.Files";
    public static final String FILE_ATTRIBUTE_CLASS_NAME = "java.nio.file.attribute.FileAttribute";
    public static final String LINK_OPTION_CLASS_NAME = "java.nio.file.LinkOption";
    public static final String FILE_TIME_CLASS_NAME = "java.nio.file.attribute.FileTime";
    public static final String COPY_OPTION_CLASS_NAME = "java.nio.file.CopyOption";
    public static final String FILE_SYSTEMS_GET_DEFAULT_METHOD_NAME = "getDefault";
    public static final String FILE_SYSTEM_GET_PATH_METHOD_NAME = "getPath";
    public static final String FILES_IS_SYMBOLIC_LINK_METHOD_NAME = "isSymbolicLink";
    public static final String FILES_EXISTS_METHOD_NAME = "exists";
    public static final String FILES_CREATE_SYMBOLIC_LINK_METHOD_NAME = "createSymbolicLink";
    public static final String FILES_READ_SYMBOLIC_LINK_METHOD_NAME = "readSymbolicLink";
    public static final String FILES_GET_LAST_MODIFIED_TIME_METHOD_NAME = "getLastModifiedTime";
    public static final String FILE_TIME_TO_MILLIS_METHOD_NAME = "toMillis";
    public static final String FILES_MOVE_METHOD_NAME = "move";
    private static Class<?> fileSystemsClass = null;
    private static Class<?> fileSystemClass = null;
    private static Class<?> pathClass = null;
    private static Class<?> filesClass = null;
    private static Class<?> fileAttributeClass = null;
    private static Class<? extends Enum<?>> linkOptionClass = null;
    private static Class<?> fileTimeClass = null;
    private static Class<?> copyOptionClass = null;
    private static Method getDefaultMethod = null;
    private static Method getPathMethod = null;
    private static Method isSymbolicLinkMethod = null;
    private static Method existsMethod = null;
    private static Method createSymbolicLink = null;
    private static Method readSymbolicLink = null;
    private static Method getLastModifiedTime = null;
    private static Method toMillis = null;
    private static Method move = null;
    private static Object fileSystem = null;
    private static Object linkOptionsArray = null;
    private static boolean symbolicLinkCapable = false;

    public static boolean isSymbolicLinkCapable() {
        return symbolicLinkCapable;
    }

    public static boolean isSymbolicLink(String path) {
        if (symbolicLinkCapable && path != null) {
            try {
                Object filePath = getPathMethod.invoke(fileSystem, path, new String[0]);
                if (filePath != null) {
                    return (Boolean)isSymbolicLinkMethod.invoke(null, filePath);
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return false;
    }

    public static String createSymbolicLink(String link, String target) {
        if (symbolicLinkCapable && link != null && target != null) {
            try {
                Object pathObject;
                Object linkPath = getPathMethod.invoke(fileSystem, link, new String[0]);
                Object targetPath = getPathMethod.invoke(fileSystem, target, new String[0]);
                if (linkPath != null && targetPath != null && (pathObject = createSymbolicLink.invoke(null, linkPath, targetPath, Array.newInstance(fileAttributeClass, 0))) != null) {
                    return pathObject.toString();
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return null;
    }

    public static String readSymbolicLink(String link) {
        if (symbolicLinkCapable && link != null) {
            try {
                Object pathObject;
                Object linkPath = getPathMethod.invoke(fileSystem, link, new String[0]);
                if (linkPath != null && (pathObject = readSymbolicLink.invoke(null, linkPath)) != null) {
                    return pathObject.toString();
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return null;
    }

    public static long getLastModifiedTime(String link) {
        if (symbolicLinkCapable && link != null) {
            try {
                Object fileTimeObject;
                Object linkPath = getPathMethod.invoke(fileSystem, link, new String[0]);
                if (linkPath != null && (fileTimeObject = getLastModifiedTime.invoke(null, linkPath, linkOptionsArray)) != null) {
                    return (Long)toMillis.invoke(fileTimeObject, (Object[])null);
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return 0L;
    }

    public static boolean exists(String path) {
        if (symbolicLinkCapable && path != null) {
            try {
                Object filePath = getPathMethod.invoke(fileSystem, path, new String[0]);
                if (filePath != null) {
                    return (Boolean)existsMethod.invoke(null, filePath, linkOptionsArray);
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return false;
    }

    public static String move(String source, String target) {
        if (symbolicLinkCapable && source != null && target != null) {
            try {
                Object pathObject;
                Object sourcePath = getPathMethod.invoke(fileSystem, source, new String[0]);
                Object targetPath = getPathMethod.invoke(fileSystem, target, new String[0]);
                if (sourcePath != null && targetPath != null && (pathObject = move.invoke(null, sourcePath, targetPath, Array.newInstance(copyOptionClass, 0))) != null) {
                    return pathObject.toString();
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception invoking method: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return null;
    }

    static {
        Log.info("Checking this Java for symbolic link support...");
        try {
            fileSystemsClass = Class.forName(FILE_SYSTEMS_CLASS_NAME);
            fileSystemClass = Class.forName(FILE_SYSTEM_CLASS_NAME);
            pathClass = Class.forName(PATH_CLASS_NAME);
            filesClass = Class.forName(FILES_CLASS_NAME);
            fileAttributeClass = Class.forName(FILE_ATTRIBUTE_CLASS_NAME);
            linkOptionClass = Class.forName(LINK_OPTION_CLASS_NAME);
            fileTimeClass = Class.forName(FILE_TIME_CLASS_NAME);
            copyOptionClass = Class.forName(COPY_OPTION_CLASS_NAME);
            getDefaultMethod = fileSystemsClass.getMethod(FILE_SYSTEMS_GET_DEFAULT_METHOD_NAME, new Class[0]);
            getPathMethod = fileSystemClass.getMethod(FILE_SYSTEM_GET_PATH_METHOD_NAME, String.class, String[].class);
            isSymbolicLinkMethod = filesClass.getMethod(FILES_IS_SYMBOLIC_LINK_METHOD_NAME, pathClass);
            existsMethod = filesClass.getMethod(FILES_EXISTS_METHOD_NAME, pathClass, Array.newInstance(linkOptionClass, 0).getClass());
            createSymbolicLink = filesClass.getMethod(FILES_CREATE_SYMBOLIC_LINK_METHOD_NAME, pathClass, pathClass, Array.newInstance(fileAttributeClass, 0).getClass());
            readSymbolicLink = filesClass.getMethod(FILES_READ_SYMBOLIC_LINK_METHOD_NAME, pathClass);
            getLastModifiedTime = filesClass.getMethod(FILES_GET_LAST_MODIFIED_TIME_METHOD_NAME, pathClass, Array.newInstance(linkOptionClass, 0).getClass());
            toMillis = fileTimeClass.getMethod(FILE_TIME_TO_MILLIS_METHOD_NAME, new Class[0]);
            move = filesClass.getMethod(FILES_MOVE_METHOD_NAME, pathClass, pathClass, Array.newInstance(copyOptionClass, 0).getClass());
            fileSystem = getDefaultMethod.invoke(null, new Object[0]);
            if (linkOptionClass.getEnumConstants() != null) {
                linkOptionsArray = Array.newInstance(linkOptionClass, 1);
                for (Enum<?> obj : linkOptionClass.getEnumConstants()) {
                    if (!obj.toString().equals("NOFOLLOW_LINKS")) continue;
                    Array.set(linkOptionsArray, 0, obj);
                    break;
                }
            }
            if (getDefaultMethod != null && getPathMethod != null && fileSystem != null && isSymbolicLinkMethod != null && createSymbolicLink != null && readSymbolicLink != null) {
                symbolicLinkCapable = true;
                Log.info("It seems this Java supports symbolic links.");
                Log.info("Symbolic link support at the OS level will be determined at runtime...");
            }
        }
        catch (ClassNotFoundException cnfe) {
            Log.error("Unable to find class: " + cnfe.getLocalizedMessage());
            Log.exception(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            Log.error("No such method for class: " + nsme.getLocalizedMessage());
            Log.exception(nsme);
        }
        catch (InvocationTargetException ite) {
            Log.error("Cannot invoke target method: " + ite.getLocalizedMessage());
            Log.exception(ite);
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception introspecting class: " + thr.getLocalizedMessage());
            Log.exception(thr);
        }
    }
}

