/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMerge;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.charset.Charset;

public class ClientMergeState {
    public static final String TRACE_PREFIX = "ClientMergeState";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".mrg";
    private boolean externalStreamMerge = false;
    private String externalTmpFilename = null;
    private String tmpDir = null;
    private String clientPath = null;
    private String baseName = null;
    private String theirName = null;
    private String yourName = null;
    private String baseTmpFilename = null;
    private String theirTmpFilename = null;
    private String yourTmpFilename = null;
    private String resultTmpFilename = null;
    private RpcPerforceFile baseTmpFile = null;
    private RpcPerforceFile theirTmpFile = null;
    private RpcPerforceFile yourTmpFile = null;
    private RpcPerforceFile resultTmpFile = null;
    private RpcOutputStream baseTmpFileStream = null;
    private RpcOutputStream yourTmpFileStream = null;
    private RpcOutputStream theirTmpFileStream = null;
    private RpcOutputStream resultTmpFileStream = null;
    private int yourChunks = 0;
    private int theirChunks = 0;
    private int conflictChunks = 0;
    private int bothChunks = 0;
    private int bits = 0;
    private int oldBits = 0;
    private boolean safeMerge = false;
    private boolean autoMerge = false;
    private RpcPerforceFileType clientType = null;
    private RpcPerforceFileType resultType = null;
    private Charset charset = null;
    private boolean showAll = false;
    protected boolean twoWayMerge = false;
    protected String baseDigest = null;
    protected String yourDigest = null;
    protected String theirDigest = null;

    protected ClientMergeState(String clientPath, boolean externalStreamMerge, RpcPerforceFileType clientType, RpcPerforceFileType resultType, String tmpDir, Charset charset) {
        this.externalStreamMerge = externalStreamMerge;
        this.clientPath = clientPath;
        this.clientType = clientType;
        this.resultType = resultType;
        this.charset = charset;
        if (tmpDir == null) {
            throw new NullPointerError("null tmpdir passed to ClientMergeState constructor");
        }
        this.tmpDir = tmpDir;
    }

    protected void openMergeFiles(boolean isUnicodeServer) throws IOException {
        this.baseTmpFilename = RpcPerforceFile.createTempFileName(this.tmpDir);
        this.baseTmpFile = new RpcPerforceFile(this.baseTmpFilename, this.clientType);
        this.baseTmpFileStream = new RpcOutputStream(this.baseTmpFile, this.charset, isUnicodeServer, false);
        this.theirTmpFilename = RpcPerforceFile.createTempFileName(this.tmpDir);
        this.theirTmpFile = new RpcPerforceFile(this.theirTmpFilename, this.resultType);
        this.theirTmpFileStream = new RpcOutputStream(this.theirTmpFile, this.charset, isUnicodeServer, false);
        this.yourTmpFilename = this.clientPath;
        this.yourTmpFile = new RpcPerforceFile(this.yourTmpFilename, this.clientType);
        this.resultTmpFilename = RpcPerforceFile.createTempFileName(this.tmpDir);
        this.resultTmpFile = new RpcPerforceFile(this.resultTmpFilename, this.resultType);
        this.resultTmpFileStream = new RpcOutputStream(this.resultTmpFile, this.charset, isUnicodeServer, false);
    }

    protected void writeMarker(String markerString) throws IOException {
        if (!this.checkStream(this.resultTmpFileStream)) {
            throw new NullPointerError("bad stream in writeResultChunk");
        }
        this.resultTmpFileStream.writeConverted(markerString.getBytes(CharsetDefs.UTF8_NAME));
    }

    protected void writeBaseChunk(byte[] bytes) throws IOException {
        if (!this.checkStream(this.baseTmpFileStream)) {
            throw new NullPointerError("bad stream in writeBaseChunk");
        }
        this.baseTmpFileStream.writeConverted(bytes);
    }

    protected void writeTheirChunk(byte[] bytes) throws IOException {
        if (!this.checkStream(this.theirTmpFileStream)) {
            throw new NullPointerError("bad stream in writeTheirChunk");
        }
        this.theirTmpFileStream.writeConverted(bytes);
    }

    protected void writeYourChunk(byte[] bytes) throws IOException {
    }

    protected void writeResultChunk(byte[] bytes) throws IOException {
        if (!this.checkStream(this.resultTmpFileStream)) {
            throw new NullPointerError("bad stream in writeResultChunk");
        }
        this.resultTmpFileStream.writeConverted(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishMerge(ClientMerge.ResolveChoice choice) throws IOException {
        boolean succeeded = false;
        try {
            if (this.checkStream(this.resultTmpFileStream)) {
                this.resultTmpFileStream.close();
            }
            if (this.checkStream(this.baseTmpFileStream)) {
                this.baseTmpFileStream.close();
            }
            if (this.checkStream(this.theirTmpFileStream)) {
                this.theirTmpFileStream.close();
            }
            switch (choice) {
                case THEIRS: {
                    succeeded = this.theirTmpFile.renameTo(this.yourTmpFile);
                    break;
                }
                case MERGED: {
                    succeeded = this.resultTmpFile.renameTo(this.yourTmpFile);
                    break;
                }
                case EDIT: {
                    succeeded = this.resultTmpFile.renameTo(this.yourTmpFile);
                    break;
                }
                default: {
                    succeeded = true;
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (this.baseTmpFile != null) {
                    this.baseTmpFile.delete();
                }
                if (this.theirTmpFile != null) {
                    this.theirTmpFile.delete();
                }
                if (this.resultTmpFile != null) {
                    this.resultTmpFile.delete();
                }
            }
            catch (Throwable thr) {
                Log.warn("unexpected exception in closeMerge: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
            throw throwable;
        }
        try {
            if (this.baseTmpFile != null) {
                this.baseTmpFile.delete();
            }
            if (this.theirTmpFile != null) {
                this.theirTmpFile.delete();
            }
            if (this.resultTmpFile != null) {
                this.resultTmpFile.delete();
            }
        }
        catch (Throwable thr) {
            Log.warn("unexpected exception in closeMerge: " + thr.getLocalizedMessage());
            Log.exception(thr);
        }
        return succeeded;
    }

    protected String getMergeDigestString() {
        if (this.conflictChunks == 0) {
            return new MD5Digester().digestFileAs32ByteHex(this.resultTmpFile, this.charset, true);
        }
        return null;
    }

    protected String getTheirDigestString() {
        return new MD5Digester().digestFileAs32ByteHex(this.theirTmpFile, this.charset, true);
    }

    protected String getYourDigestString() {
        return new MD5Digester().digestFileAs32ByteHex(this.yourTmpFile, this.charset, true);
    }

    protected int incrYourChunks() {
        return ++this.yourChunks;
    }

    protected int theirYourChunks() {
        return ++this.theirChunks;
    }

    protected int incrConflictChunks() {
        return ++this.conflictChunks;
    }

    protected int incrTheirChunks() {
        return ++this.theirChunks;
    }

    protected int incrBothChunks() {
        return ++this.bothChunks;
    }

    protected String getClientPath() {
        return this.clientPath;
    }

    protected void setClientPath(String clientPath) {
        this.clientPath = clientPath;
    }

    protected String getBaseName() {
        return this.baseName;
    }

    protected void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    protected String getTheirName() {
        return this.theirName;
    }

    protected void setTheirName(String theirName) {
        this.theirName = theirName;
    }

    protected String getYourName() {
        return this.yourName;
    }

    protected void setYourName(String yourName) {
        this.yourName = yourName;
    }

    protected String getBaseTmpFilename() {
        return this.baseTmpFilename;
    }

    protected void setBaseTmpFilename(String baseTmpFilename) {
        this.baseTmpFilename = baseTmpFilename;
    }

    protected String getTheirTmpFilename() {
        return this.theirTmpFilename;
    }

    protected void setTheirTmpFilename(String theirTmpFilename) {
        this.theirTmpFilename = theirTmpFilename;
    }

    protected String getYourTmpFilename() {
        return this.yourTmpFilename;
    }

    protected void setYourTmpFilename(String yourTmpFilename) {
        this.yourTmpFilename = yourTmpFilename;
    }

    protected RpcPerforceFile getBaseTmpFile() {
        return this.baseTmpFile;
    }

    protected void setBaseTmpFile(RpcPerforceFile baseTmpFile) {
        this.baseTmpFile = baseTmpFile;
    }

    protected RpcPerforceFile getTheirTmpFile() {
        return this.theirTmpFile;
    }

    protected void setTheirTmpFile(RpcPerforceFile theirTmpFile) {
        this.theirTmpFile = theirTmpFile;
    }

    protected RpcPerforceFile getYourTmpFile() {
        return this.yourTmpFile;
    }

    protected void setYourTmpFile(RpcPerforceFile yourTmpFile) {
        this.yourTmpFile = yourTmpFile;
    }

    protected RpcOutputStream getBaseTmpFileStream() {
        return this.baseTmpFileStream;
    }

    protected void setBaseTmpFileStream(RpcOutputStream baseTmpFileStream) {
        this.baseTmpFileStream = baseTmpFileStream;
    }

    protected RpcOutputStream getYourTmpFileStream() {
        return this.yourTmpFileStream;
    }

    protected void setYourTmpFileStream(RpcOutputStream yourTmpFileStream) {
        this.yourTmpFileStream = yourTmpFileStream;
    }

    protected RpcOutputStream getTheirTmpFileStream() {
        return this.theirTmpFileStream;
    }

    protected void setTheirTmpFileStream(RpcOutputStream theirTmpFileStream) {
        this.theirTmpFileStream = theirTmpFileStream;
    }

    protected int getYourChunks() {
        return this.yourChunks;
    }

    protected void setYourChunks(int yourChunks) {
        this.yourChunks = yourChunks;
    }

    protected int getTheirChunks() {
        return this.theirChunks;
    }

    protected void setTheirChunks(int theirChunks) {
        this.theirChunks = theirChunks;
    }

    protected int getConflictChunks() {
        return this.conflictChunks;
    }

    protected void setConflictChunks(int conflictChunks) {
        this.conflictChunks = conflictChunks;
    }

    protected int getBothChunks() {
        return this.bothChunks;
    }

    protected void setBothChunks(int bothChunks) {
        this.bothChunks = bothChunks;
    }

    protected int getBits() {
        return this.bits;
    }

    protected void setBits(int bits) {
        this.bits = bits;
    }

    protected int getOldBits() {
        return this.oldBits;
    }

    protected void setOldBits(int oldBits) {
        this.oldBits = oldBits;
    }

    protected String getTmpDir() {
        return this.tmpDir;
    }

    protected void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    protected boolean isExternalStreamMerge() {
        return this.externalStreamMerge;
    }

    protected void setExternalStreamMerge(boolean externalStreamMerge) {
        this.externalStreamMerge = externalStreamMerge;
    }

    protected String getExternalTmpFilename() {
        return this.externalTmpFilename;
    }

    protected void setExternalTmpFilename(String externalTmpFilename) {
        this.externalTmpFilename = externalTmpFilename;
    }

    protected RpcPerforceFile getResultTmpFile() {
        return this.resultTmpFile;
    }

    protected void setResultTmpFile(RpcPerforceFile resultTmpFile) {
        this.resultTmpFile = resultTmpFile;
    }

    protected RpcOutputStream getResultTmpFileStream() {
        return this.resultTmpFileStream;
    }

    protected void setResultTmpFileStream(RpcOutputStream resultTmpFileStream) {
        this.resultTmpFileStream = resultTmpFileStream;
    }

    private boolean checkStream(RpcOutputStream stream) {
        try {
            FileDescriptor fd;
            if (stream != null && (fd = stream.getFD()) != null && fd.valid()) {
                return true;
            }
        }
        catch (IOException ioexc) {
            Log.exception(ioexc);
        }
        return false;
    }

    protected boolean isSafeMerge() {
        return this.safeMerge;
    }

    protected void setSafeMerge(boolean safeMerge) {
        this.safeMerge = safeMerge;
    }

    protected boolean isAutoMerge() {
        return this.autoMerge;
    }

    protected void setAutoMerge(boolean autoMerge) {
        this.autoMerge = autoMerge;
    }

    protected boolean isShowAll() {
        return this.showAll;
    }

    protected void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    protected boolean isTwoWayMerge() {
        return this.twoWayMerge;
    }

    protected void setTwoWayMerge(boolean twoWayMerge) {
        this.twoWayMerge = twoWayMerge;
    }

    protected String getBaseDigest() {
        return this.baseDigest;
    }

    protected void setBaseDigest(String baseDigest) {
        this.baseDigest = baseDigest;
    }

    protected String getYourDigest() {
        return this.yourDigest;
    }

    protected void setYourDigest(String yourDigest) {
        this.yourDigest = yourDigest;
    }

    protected String getTheirDigest() {
        return this.theirDigest;
    }

    protected void setTheirDigest(String theirDigest) {
        this.theirDigest = theirDigest;
    }
}

