/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.Metadata;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NoSuchObjectException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.ResourceException;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.NtsServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.OneShotServerImpl;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.RpcSystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.server.IServerControl;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerImplMetadata;
import com.perforce.p4java.server.ZeroconfHelper;
import com.perforce.p4java.server.ZeroconfServerInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFactory {
    public static final String TRACE_PREFIX = "ServerFactory";
    public static final String DEFAULT_PROTOCOL_SPEC = "p4java";
    public static final String DEFAULT_PROTOCOL_NAME = "p4jrpc";
    public static final String ZEROCONF_CLASS_NAME = "javax.jmdns.JmDNS";
    private static Map<String, Class> implMap = new HashMap<String, Class>();
    private static ISystemFileCommandsHelper rpcFileCommandsHelper = null;
    private static ZeroconfHelper zcHelper = null;

    public static List<IServerImplMetadata> getAvailableImplementationMetadata() {
        ArrayList<IServerImplMetadata> retList = new ArrayList<IServerImplMetadata>();
        for (String key : implMap.keySet()) {
            Class implClass = implMap.get(key);
            IServerImplMetadata md = ServerFactory.getImplMetadata(implClass);
            if (md == null) continue;
            retList.add(md);
        }
        return retList;
    }

    public static IServer getServer(String serverUriString, Properties props) throws URISyntaxException, ConnectionException, NoSuchObjectException, ConfigException, ResourceException {
        return ServerFactory.getOptionsServer(serverUriString, props);
    }

    public static IOptionsServer getOptionsServer(String serverUriString, Properties props) throws URISyntaxException, ConnectionException, NoSuchObjectException, ConfigException, ResourceException {
        return ServerFactory.getOptionsServer(serverUriString, props, null);
    }

    public static IOptionsServer getOptionsServer(String serverUriString, Properties props, UsageOptions opts) throws URISyntaxException, ConnectionException, NoSuchObjectException, ConfigException, ResourceException {
        IServerImplMetadata implMetadata;
        if (serverUriString == null) {
            throw new NullPointerError("Null server serverUriString passed to server factory");
        }
        Log.info("P4Java server factory called for Perforce server URI: " + serverUriString);
        String protoPart = null;
        String hostPart = null;
        String portPartStr = null;
        int portPart = -1;
        String queryPart = null;
        int protoPartEnd = serverUriString.indexOf("://");
        if (protoPartEnd < 0) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce scheme / protocol part");
        }
        protoPart = serverUriString.substring(0, protoPartEnd);
        if (protoPart.length() + 3 >= serverUriString.length()) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce server hostname");
        }
        String restStr = serverUriString.substring(protoPartEnd + 3);
        int portStart = restStr.indexOf(":");
        int queryStart = restStr.indexOf("?");
        if (portStart == 0) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce server hostname");
        }
        if (portStart < 0 || queryStart > 0 && queryStart < portStart) {
            throw new URISyntaxException(serverUriString, "missing or malformed Perforce server port specifier");
        }
        hostPart = restStr.substring(0, portStart);
        if (queryStart > 0) {
            portPartStr = restStr.substring(portStart + 1, queryStart);
            if (queryStart >= restStr.length()) {
                throw new URISyntaxException(serverUriString, "empty or malformed P4Java query string");
            }
            queryPart = restStr.substring(queryStart + 1);
        } else {
            portPartStr = restStr.substring(portStart + 1);
        }
        try {
            portPart = new Integer(portPartStr);
        }
        catch (NumberFormatException nfe) {
            throw new URISyntaxException(serverUriString, "non-numeric Perforce server port specifier");
        }
        if (protoPart.equals(DEFAULT_PROTOCOL_SPEC)) {
            protoPart = DEFAULT_PROTOCOL_NAME;
        }
        Properties serverProps = props;
        if (queryPart != null) {
            String[] queries;
            if (serverProps == null) {
                serverProps = new Properties();
            }
            for (String query : queries = queryPart.split("&")) {
                String[] qStrs;
                if (query == null || (qStrs = query.split("=")).length <= 0 || qStrs[0] == null) continue;
                if (qStrs.length > 1) {
                    serverProps.put(qStrs[0], qStrs[1]);
                    continue;
                }
                serverProps.put(qStrs[0], (Object)null);
            }
        }
        if ((implMetadata = ServerFactory.getImplMetadata(implMap.get(protoPart))) == null) {
            throw new NoSuchObjectException("No such server implementation found for protocol '" + protoPart + "'");
        }
        try {
            Class<?> serverImplClass = Class.forName(implMetadata.getImplClassName());
            Log.info("Using Server implementation class: " + serverImplClass.getCanonicalName());
            IServerControl serverImpl = (IServerControl)serverImplClass.newInstance();
            serverImpl.init(hostPart, portPart, serverProps, opts);
            return (IOptionsServer)((Object)serverImpl);
        }
        catch (ClassNotFoundException cnfe) {
            Log.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (class not found)");
            Log.exception(cnfe);
            throw new NoSuchObjectException("No such p4j server implementation class found for protocol", cnfe);
        }
        catch (ClassCastException cce) {
            Log.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (class cast error)");
            Log.exception(cce);
            throw new ConfigException("Specified Perforce server implementation class does not implement required interface(s)", cce);
        }
        catch (InstantiationException ie) {
            Log.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (instantiation failed)");
            Log.exception(ie);
            throw new ConfigException("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "'", ie);
        }
        catch (IllegalAccessException iae) {
            Log.error("Unable to instantiate Perforce server implementation class '" + implMetadata.getImplClassName() + "' (illegal access exception)");
            Log.exception(iae);
            throw new ConfigException("Unable to instantiate Perforce server class '" + implMetadata.getImplClassName() + "'", iae);
        }
    }

    @Deprecated
    public static IServer getServer(URI serverUrl, Properties props) throws ConnectionException, NoSuchObjectException, ConfigException, ResourceException, URISyntaxException {
        if (serverUrl == null) {
            throw new NullPointerError("Null server URI passed to server factory");
        }
        return ServerFactory.getServer(serverUrl.toString(), props);
    }

    private static IServerImplMetadata getImplMetadata(final Class<Server> implClass) {
        if (implClass == null) {
            return null;
        }
        return new IServerImplMetadata(){

            public String getScreenName() {
                try {
                    return (String)implClass.getField("SCREEN_NAME").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage());
                    Log.exception(exc);
                    return "Unknown";
                }
            }

            public String getComments() {
                try {
                    return (String)implClass.getField("IMPL_COMMENTS").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage());
                    Log.exception(exc);
                    return "No comments available";
                }
            }

            public IServerImplMetadata.ImplType getImplType() {
                try {
                    return (IServerImplMetadata.ImplType)((Object)implClass.getField("IMPL_TYPE").get(null));
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage());
                    Log.exception(exc);
                    return IServerImplMetadata.ImplType.UNKNOWN;
                }
            }

            public int getMinimumServerLevel() {
                try {
                    return (Integer)implClass.getField("MINIMUM_SUPPORTED_SERVER_LEVEL").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage());
                    Log.exception(exc);
                    return -1;
                }
            }

            public String getUriScheme() {
                try {
                    return (String)implClass.getField("PROTOCOL_NAME").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage());
                    Log.exception(exc);
                    return "p4j";
                }
            }

            public boolean isDefault() {
                try {
                    return (Boolean)implClass.getField("DEFAULT_STATUS").get(null);
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage());
                    Log.exception(exc);
                    return false;
                }
            }

            public String getImplClassName() {
                try {
                    return implClass.getCanonicalName();
                }
                catch (Exception exc) {
                    Log.error("Unexpected exception in ServerFactory.getImplMetadata: " + exc.getMessage());
                    Log.exception(exc);
                    return "com.perforce.p4java.NoSuchImplClass";
                }
            }
        };
    }

    public static void setRpcFileSystemHelper(ISystemFileCommandsHelper fsCmdHelper) {
        rpcFileCommandsHelper = fsCmdHelper;
        Log.info("setting RPC system file helper to " + (fsCmdHelper == null ? "null" : "class " + fsCmdHelper.getClass().getCanonicalName()));
    }

    public static ISystemFileCommandsHelper getRpcFileSystemHelper() {
        return rpcFileCommandsHelper;
    }

    public static List<ZeroconfServerInfo> getZeroconfServers() throws ConfigException {
        if (zcHelper == null) {
            zcHelper = new ZeroconfHelper();
        }
        return zcHelper.getZeroconfServers();
    }

    public static boolean isZeroConfAvailable() {
        if (zcHelper == null) {
            zcHelper = new ZeroconfHelper();
        }
        return zcHelper.isZeroConfAvailable();
    }

    static {
        implMap.put(DEFAULT_PROTOCOL_NAME, OneShotServerImpl.class);
        implMap.put("p4jrpcnts", NtsServerImpl.class);
        Log.info("P4Java server factory loaded; version: " + Metadata.getP4JVersionString() + "; date: " + Metadata.getP4JDateString());
        Log.info("Using default charset: " + CharsetDefs.DEFAULT + "; JVM charset: " + CharsetDefs.LOCAL);
        rpcFileCommandsHelper = new RpcSystemFileCommandsHelper();
        Log.info("Using default RPC system file command helper: " + rpcFileCommandsHelper.getClass().getCanonicalName());
    }
}

