/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option.server;

import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportRecordsOptions
extends Options {
    public static final String OPTIONS_SPECS = "";
    protected boolean useJournal = false;
    protected long maxRecs = 0L;
    protected int sourceNum = 0;
    protected long offset = 0L;
    protected boolean format = false;
    protected String journalPrefix = null;
    protected String filter = null;

    public ExportRecordsOptions() {
    }

    public ExportRecordsOptions(String ... options) {
        super(options);
    }

    public ExportRecordsOptions(boolean useJournal, long maxRecs, int sourceNum, long offset, boolean format, String journalPrefix, String filter) {
        this.useJournal = useJournal;
        this.maxRecs = maxRecs;
        this.sourceNum = sourceNum;
        this.offset = offset;
        this.format = format;
        this.journalPrefix = journalPrefix;
        this.filter = filter;
    }

    @Override
    public List<String> processOptions(IServer server) throws OptionsException {
        ArrayList<String> args = new ArrayList<String>();
        if (this.maxRecs > 0L) {
            args.add("-l" + this.maxRecs);
        }
        if (this.sourceNum >= 0) {
            args.add((this.useJournal ? "-j" : "-c") + this.sourceNum + (this.offset >= 0L ? (this.useJournal ? "/" : "#") + this.offset : OPTIONS_SPECS));
        }
        if (this.journalPrefix != null) {
            args.add("-J" + this.journalPrefix);
        }
        if (this.format) {
            args.add("-f");
        }
        if (this.filter != null) {
            args.add("-F" + this.filter);
        }
        return args;
    }

    public boolean isUseJournal() {
        return this.useJournal;
    }

    public ExportRecordsOptions setUseJournal(boolean useJournal) {
        this.useJournal = useJournal;
        return this;
    }

    public long getMaxRecs() {
        return this.maxRecs;
    }

    public ExportRecordsOptions setMaxRecs(long maxRecs) {
        this.maxRecs = maxRecs;
        return this;
    }

    public int getSourceNum() {
        return this.sourceNum;
    }

    public ExportRecordsOptions setSourceNum(int sourceNum) {
        this.sourceNum = sourceNum;
        return this;
    }

    public long getOffset() {
        return this.offset;
    }

    public ExportRecordsOptions setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public boolean isFormat() {
        return this.format;
    }

    public ExportRecordsOptions setFormat(boolean format) {
        this.format = format;
        return this;
    }

    public String getJournalPrefix() {
        return this.journalPrefix;
    }

    public ExportRecordsOptions setJournalPrefix(String journalPrefix) {
        this.journalPrefix = journalPrefix;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public ExportRecordsOptions setFilter(String filter) {
        this.filter = filter;
        return this;
    }
}

