/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.Log;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RpcSystemFileCommandsHelper
implements ISystemFileCommandsHelper {
    public static final String IMPL_CLASS_NAME = "java.io.File";
    private static final String CAN_EXECUTE_METHOD_NAME = "canExecute";
    private static final String SET_EXECUTABLE_METHOD_NAME = "setExecutable";
    private static final String SET_WRITABLE_METHOD_NAME = "setWritable";
    private static final String SET_READABLE_METHOD_NAME = "setReadable";
    private static Class<ISystemFileCommandsHelper> implClass = null;
    private static Constructor<ISystemFileCommandsHelper> implClassConstructor = null;
    private static Method canExecuteMethod = null;
    private static Method setWritableMethod = null;
    private static Method setExecutableMethod = null;
    private static Method setReadableMethod = null;

    public boolean canExecute(String fileName) {
        if (canExecuteMethod != null) {
            try {
                ISystemFileCommandsHelper implObj = implClassConstructor.newInstance(fileName);
                return (Boolean)canExecuteMethod.invoke((Object)implObj, (Object[])null);
            }
            catch (InvocationTargetException ite) {
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in RpcSystemFileCommandsHelper.canExecute: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return false;
    }

    public boolean setExecutable(String fileName, boolean executable, boolean ownerOnly) {
        if (setExecutableMethod != null) {
            try {
                ISystemFileCommandsHelper implObj = implClassConstructor.newInstance(fileName);
                return (Boolean)setExecutableMethod.invoke((Object)implObj, executable, ownerOnly);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in RpcSystemFileCommandsHelper.setExecutable: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return false;
    }

    public boolean setWritable(String fileName, boolean writable) {
        if (setWritableMethod != null) {
            try {
                ISystemFileCommandsHelper implObj = implClassConstructor.newInstance(fileName);
                return (Boolean)setWritableMethod.invoke((Object)implObj, writable);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in RpcSystemFileCommandsHelper.setWritable: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return false;
    }

    public boolean isSymlink(String fileName) {
        return false;
    }

    public boolean setReadable(String fileName, boolean readable, boolean ownerOnly) {
        if (setReadableMethod != null) {
            try {
                ISystemFileCommandsHelper implObj = implClassConstructor.newInstance(fileName);
                return (Boolean)setReadableMethod.invoke((Object)implObj, readable, ownerOnly);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in RpcSystemFileCommandsHelper.setReadOnly: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
        return false;
    }

    public boolean setOwnerReadOnly(String fileName) {
        boolean set = this.setReadable(fileName, false, false);
        set &= this.setReadable(fileName, true, true);
        return false;
    }

    static {
        Log.info("initializing system file command helper class: java.io.File");
        try {
            implClass = Class.forName(IMPL_CLASS_NAME);
        }
        catch (ClassNotFoundException cnfe) {
            Log.error("Unable to find class 'java.io.File': " + cnfe.getLocalizedMessage());
            Log.exception(cnfe);
        }
        catch (Throwable thr) {
            Log.error("Unable to load class 'java.io.File': " + thr.getLocalizedMessage());
            Log.exception(thr);
        }
        if (implClass != null) {
            try {
                implClassConstructor = implClass.getConstructor(String.class);
                setWritableMethod = implClass.getDeclaredMethod(SET_WRITABLE_METHOD_NAME, Boolean.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                Log.error("No such method for helper class: " + nsme.getLocalizedMessage());
                Log.exception(nsme);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception introspecting helper class: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
            try {
                canExecuteMethod = implClass.getDeclaredMethod(CAN_EXECUTE_METHOD_NAME, new Class[0]);
                setExecutableMethod = implClass.getDeclaredMethod(SET_EXECUTABLE_METHOD_NAME, Boolean.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                Log.warn("No such method for helper class: " + nsme.getLocalizedMessage());
                Log.exception(nsme);
            }
            catch (Throwable thr) {
                Log.warn("Unexpected exception introspecting helper class: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
            try {
                setReadableMethod = implClass.getDeclaredMethod(SET_READABLE_METHOD_NAME, Boolean.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                Log.error("No such method for helper class: " + nsme.getLocalizedMessage());
                Log.exception(nsme);
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception introspecting helper class: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
    }
}

