package com.payu.phonepe;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;

import com.payu.payuanalytics.analytics.PayUDeviceAnalytics;
import com.payu.phonepe.callbacks.ICheckPhonepe;
import com.payu.socketverification.widgets.PayUProgressDialog;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.api.ShowPhonePeCallback;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

import static com.payu.phonepe.PhonePe.cb_version_name;
import static com.payu.phonepe.PhonePe.upi_sdk_version;

public class PhonepeUtils {

    private static com.payu.socketverification.widgets.PayUProgressDialog progressDialog;

    /**
     * Provide JSONObject for analytics
     *
     * @param context        application context
     * @param key            analytics event ket
     * @param value          event value
     * @param sdkMerchantKey merchant key
     * @param txnID         transaction  ID
     * @return
     */
    public static String getLogMessage(Context context, String key, String value, String sdkMerchantKey, String txnID) {
        try {
            JSONObject eventAnalytics = new JSONObject();
          //  eventAnalytics.put(PhonePeConstants.PAYU_ID, getCookie(UpiConstant.PAYUID, context));
            eventAnalytics.put(PhonePeConstants.TRANSACTION_ID, txnID);
            eventAnalytics.put(PhonePeConstants.MERCHANT_KEY, sdkMerchantKey);
            eventAnalytics.put(PhonePeConstants.KEY, key);
            eventAnalytics.put(PhonePeConstants.VALUE, URLEncoder.encode(value, "UTF-8"));
            eventAnalytics.put(PhonePeConstants.PAKAGE_NAME, context.getPackageName());
            eventAnalytics.put(PhonePeConstants.TIMESTAMP, getSystemCurrentTime());
            eventAnalytics.put(PhonePeConstants.VERSION_CODE, getVersionCode(context));
            if(!TextUtils.isEmpty(upi_sdk_version))
                eventAnalytics.put(PhonePeConstants.UPI_SDK_VERSION_NAME, upi_sdk_version);
            eventAnalytics.put(PhonePeConstants.SDK_VERSION_NAME, BuildConfig.VERSION_NAME);
            if(!TextUtils.isEmpty(cb_version_name))
                eventAnalytics.put(PhonePeConstants.CB_VERSION_NAME, cb_version_name);
            return eventAnalytics.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return "{}";
        }
    }
    /**
     * Return system current time of system
     *
     * @return system current time in string
     */
    private static String getSystemCurrentTime() {
        try {
            Date currentDate = new Date(System.currentTimeMillis());
            DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = df.format(currentDate);
            return date;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
    /**
     * Using Hash map to get all the post data key and value.
     * Later we can use this methods to parase non payu's post data.
     *
     * @param postData
     * @return
     */

     static HashMap<String, String> getDataFromPostData(String postData) {
        HashMap<String, String> postParamsMap = new HashMap<>();
        if (null != postData) {
            StringTokenizer tokens = new StringTokenizer(postData, "&");
            while (tokens.hasMoreTokens()) {
                String[] keyValue = tokens.nextToken().split("=");
                if (null != keyValue && keyValue.length > 0 && null != keyValue[0]) {
                    postParamsMap.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
                }
            }
        }
        return postParamsMap;
    }
    private static String getDeviceDensity(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi + "";
    }


    /**
     *
     * @param context
     * @return
     */
    private static String getVersionCode(Context context)
    {
        try {
            PackageInfo pInfo =context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * Check whether the device has phonepe app installed or not.
     * @param reference
     * @param iCheckPhonepe
     */
     static void isPhonePeAppInstalled(WeakReference<Activity> reference, final ICheckPhonepe iCheckPhonepe) {
        try {

            com.phonepe.intent.sdk.api.PhonePe.shouldShow(new ShowPhonePeCallback() {
                @Override
                public void onResponse(boolean show) {
                    iCheckPhonepe.isPhonepeAvailable(show);
                }
            });
        } catch (PhonePeInitException e) {
             iCheckPhonepe.isPhonepeAvailable(false);
             e.printStackTrace();
         }
     }

    /**
     * Showing PayU Progress Dialog
     */
     static void showProgressDialog(Activity activity, View dialogView) {
        if (null == progressDialog)
            progressDialog = new PayUProgressDialog(activity, dialogView);
        if(null == dialogView)
            progressDialog.setPayUDialogSettings(activity);
        progressDialog.setCancelable(false);
        progressDialog.show();
     }


    /**
     * Hiding the PayU progress dialog
     */
     static void hideProgressDialog(Activity activity) {
        if (null != progressDialog && progressDialog.isShowing() && !activity.isFinishing())
            progressDialog.dismiss();
        progressDialog = null;

     }

    /**
     *
     * @param sdkMerchantKey
     * @param activity
     * @param postData
     */
     static void deviceAnalytics(String sdkMerchantKey, Activity activity, String postData ) {
        JSONObject deviceDetails = new JSONObject();
        PayUDeviceAnalytics payuDeviceAnalytics;
        try {
            deviceDetails.put(PhonePeConstants.TRANSACTION_ID, PhonepeUtils.getDataFromPostData(postData).get("txnid"));
            deviceDetails.put(PhonePeConstants.MERCHANT_KEY, sdkMerchantKey);
            deviceDetails.put(PhonePeConstants.DEVICE_OS_VERSION, Build.VERSION.SDK_INT + "");
            deviceDetails.put(PhonePeConstants.DEVICE_RESOLUTION, PhonepeUtils.getDeviceDensity(activity));
            deviceDetails.put(PhonePeConstants.DEVICE_MANUFACTURE, Build.MANUFACTURER);
            deviceDetails.put(PhonePeConstants.DEVICE_MODEL, Build.MODEL);
            deviceDetails.put(PhonePeConstants.SDK_NAME_, PhonePeConstants.PHONE_PE);
            if(!TextUtils.isEmpty(upi_sdk_version))
                deviceDetails.put(PhonePeConstants.UPI_SDK_VERSION_NAME, upi_sdk_version);
            deviceDetails.put(PhonePeConstants.SDK_VERSION_NAME, BuildConfig.VERSION_NAME);
            if(!TextUtils.isEmpty(cb_version_name))
                deviceDetails.put(PhonePeConstants.CB_VERSION_NAME, cb_version_name);
            deviceDetails.put(PhonePeConstants.PAKAGE_NAME, activity.getPackageName());
            payuDeviceAnalytics = new PayUDeviceAnalytics(activity.getApplicationContext(), "cb_local_cache_device");
            payuDeviceAnalytics.log(deviceDetails.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
     }
    /**
     * Setting of data from manifest file.
     *
     * @param activity
     */
     static void setMetaData(Activity activity) {
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = activity.getPackageManager().getApplicationInfo(activity.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = applicationInfo.metaData;

            String webServiceUrl = bundle.getString(PhonePeConstants.PAYU_WEB_SERVICE_URL, PhonePeConstants.PRODUCTION_BASE_URL);
            webServiceUrl = webServiceUrl + PhonePeConstants.FETCH_DATA_URL;

            String postUrl = bundle.getString(PhonePeConstants.PAYU_POST_URL, PhonePeConstants.PRODUCTION_PAYMENT_BASE_URL);
            postUrl = postUrl + PhonePeConstants.PAYMENT_URL;

            PhonePeData.SINGLETON.setWebServiceUrl(webServiceUrl);
            PhonePeData.SINGLETON.setPostUrl(postUrl);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

     }
     static void getAlertDialog(Activity activity, DialogInterface.OnClickListener onClickDialog, String positiveText, String negativeText, String title, String message) {
        if (onClickDialog != null){
            AlertDialog.Builder alertbox = new AlertDialog.Builder(activity, R.style.payu_network_dialog);
            if (title != null)
                alertbox.setTitle(title);
            if (message != null)
                alertbox.setMessage(message);
            if (positiveText != null)
                alertbox.setPositiveButton(positiveText, onClickDialog);
            if (negativeText != null)
                alertbox.setNegativeButton(negativeText, onClickDialog);
            alertbox.show();
        }
     }

    /**
     * Add/Update sdk_platform data with current sdk version
     * @param postData Merchant's PostData
     * @return Postdata with analytics data updated string
     */
    public String getAnalyticsAddedPostData(String postData){
        JSONArray jsonArray = null;
        String jsonArrayValue="";
        HashMap<String,String> hashMap = getDataFromPostData(postData);
        if(hashMap.containsKey(PhonePeConstants.SDK_PLATFORM_KEY)) {
            jsonArrayValue = hashMap.get(PhonePeConstants.SDK_PLATFORM_KEY);
        }
        try {
            if(!TextUtils.isEmpty(jsonArrayValue)){
                jsonArray = new JSONArray(jsonArrayValue);
            }else {
                jsonArray = new JSONArray();
            }
            JSONObject object = new JSONObject();
            object.put(PhonePeConstants.PLATFORM_KEY,PhonePeConstants.PLATFORM_VALUE);
            object.put(PhonePeConstants.NAME_KEY,PhonePeConstants.NAME_VALUE);
            object.put(PhonePeConstants.VERSION_KEY,BuildConfig.VERSION_NAME);
            jsonArray.put(object);
        }catch (JSONException e){
            return convertHashMapToPostData(hashMap);
        }
        hashMap.put(PhonePeConstants.SDK_PLATFORM_KEY,jsonArray.toString());
        return convertHashMapToPostData(hashMap);
    }

    /**
     * Convert HashMap to url-encoded post-data
     * @param hashMap HashMap of PostData
     * @return Url-Encoded post-data string
     */
    private String convertHashMapToPostData(HashMap<String,String> hashMap){
        StringBuilder stringBuilder = new StringBuilder();
        for (String key:hashMap.keySet()) {
            stringBuilder.append(key);
            stringBuilder.append("=");
            stringBuilder.append(hashMap.get(key));
            stringBuilder.append("&");
        }
        return stringBuilder.toString().substring(0,stringBuilder.lastIndexOf("&"));
    }
}
