package com.payu.phonepe;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import com.payu.phonepe.callbacks.PayUPhonePeCallback;
import com.payu.phonepe.callbacks.PayUPhonePeCallbackInterface;

import java.lang.reflect.Proxy;

public class PhonePeWrapper {

    private PayUPhonePeCallbackInterface wrapperListener;
    private PhonePe phonePe;
    private PayUPhonePeCallback payUPhonePeCallback = new PayUPhonePeCallback() {

        @Override
        public void onPaymentOptionSuccess(String payuResponse) {
            wrapperListener.onPaymentOptionSuccess(payuResponse);
        }

        @Override
        public void onPaymentOptionSuccess(String payuResponse, String merchantResponse) {
            wrapperListener.onPaymentOptionSuccess(payuResponse, merchantResponse);
        }

        @Override
        public void onPaymentOptionFailure(String payuResponse, String merchantResponse) {
            wrapperListener.onPaymentOptionFailure(payuResponse, merchantResponse);
        }

        @Override
        public void onBackApprove() {
            wrapperListener.onBackApprove();
        }

        @Override
        public void onPaymentTerminate() {
            wrapperListener.onPaymentTerminate();
        }

        @Override
        public void onBackDismiss() {
            wrapperListener.onBackDismiss();
        }

        @Override
        public void onPaymentOptionFailure(String payuResponse) {
            wrapperListener.onPaymentOptionFailure(payuResponse);
        }

        public void onPaymentOptionInitialisationSuccess(boolean result) {
            wrapperListener.onPaymentOptionInitialisationSuccess(result);
        }

        public void onPaymentOptionInitialisationFailure(int errorCode, String description) {
            wrapperListener.onPaymentOptionInitialisationFailure(errorCode, description);
        }

    };

    public PhonePeWrapper(java.lang.reflect.InvocationHandler handler) {
        wrapperListener = (PayUPhonePeCallbackInterface) Proxy.newProxyInstance(
                PayUPhonePeCallbackInterface.class.getClassLoader(),
                new Class[]{PayUPhonePeCallbackInterface.class},
                handler);
        this.phonePe = PhonePe.getInstance();
    }

    /**
     * Function to make payment using PhonePe
     *
     * @param postData Post Data
     */
    public void makePayment(Activity activity, String postData, Boolean isUserCacheEnabled, View customDialogView) {
        phonePe.makePayment(payUPhonePeCallback, activity, postData, isUserCacheEnabled,customDialogView);
    }

    /**
     * Function to make payment using PhonePe
     *
     * @param postData Post Data
     */
    public void makePayment(Activity activity, String postData, Boolean isUserCacheEnabled) {
        phonePe.makePayment(payUPhonePeCallback, activity, postData, isUserCacheEnabled,null);
    }

    public void checkForPaymentAvailability(Context context, String paymentOptionHash, String merchantKey, String user_credentials) {
            phonePe.checkForPaymentAvailability((Activity) context, payUPhonePeCallback, paymentOptionHash, merchantKey, user_credentials);

    }
}
