package com.payu.phonepe;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;
import android.view.View;

import com.payu.payuanalytics.analytics.PayUAnalytics;
import com.payu.phonepe.callbacks.ICheckPhonepe;
import com.payu.phonepe.callbacks.PayUPhonePeCallback;
import com.payu.socketverification.bean.PayUNetworkAsyncTaskData;
import com.payu.socketverification.interfaces.PayuNetworkAsyncTaskInterface;
import com.payu.socketverification.core.PayUNetworkAsyncTask;
import com.phonepe.intent.sdk.api.PhonePe;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;

/**
 * @author shahbaz.ahmmod
 * Here we are checking the payment availibility as well as initiating the payment and further pass it to the another activity.
 */
public class PhonePeHandler implements PayuNetworkAsyncTaskInterface, ICheckPhonepe {
    private String paymentOptionHash;
    private String user_credentials;
    private String merchantKey, postData;
    private WeakReference<Activity> reference;
    private PayUAnalytics analytics;
    private String txnId;
    private boolean isUserCacheEnabled = true;
    private PaymentRequest paymentRequest;
    private PayUPhonePeCallback callback;
    private View mCustomDialogView;

    /**
     * @param activity
     * @param callback
     * @param paymentOptionHash
     * @param merchantKey
     * @param user_credentials
     */
    void checkForPaymentAvailability(Activity activity, PayUPhonePeCallback callback, String paymentOptionHash, String merchantKey, String user_credentials) {
        if (callback == null) {
            L.v("Callback " + callback);
            throw new IllegalStateException("PayUPhonePeCallback must not be null");
        }

        PhonePeData.SINGLETON.setPayUPhonePeCallback(callback);
        this.merchantKey = merchantKey;
        this.paymentOptionHash = paymentOptionHash;
        this.user_credentials = user_credentials;
        this.reference = new WeakReference<>(activity);
        PhonepeUtils.setMetaData(reference.get());
//      com.phonepe.intent.sdk.api.PhonePe.init(reference.get());
//        PhonepeUtils.isPhonePeAppInstalled(reference, this);
        checkPhonePeAvailability();
    }


    @Override
    public void onPayuNetworkAsyncTaskResponse(String payUAsyncTaskResponse, String webServiceType) {
        switch (webServiceType) {
            case PhonePeConstants.CHECK_PAYMENT_OPTION:
                sendPaymentOptionResponse(payUAsyncTaskResponse);
                break;
            case PhonePeConstants.MAKE_PAYMENT:
                PhonepeUtils.hideProgressDialog(reference.get());
                sendParsedResponse(payUAsyncTaskResponse);
                break;
        }
    }

    /**
     * Sending parsed response to the another activity.
     *
     * @param response
     */
    private void sendParsedResponse(String response) {
        PaymentRequest paymentRequest = parseResponse(response);
        if (null != paymentRequest) {
            analytics.log(PhonepeUtils.getLogMessage(reference.get(), PhonePeConstants.PHONE_PE_MAKE_PAYMENT_RESPONSE, PhonePeConstants.SUCCESS, merchantKey, txnId));

            Intent phonePeIntent = new Intent(reference.get(), com.payu.phonepe.PayUPhonePeActivity.class);
            phonePeIntent.putExtra(PhonePeConstants.PAYMENT_REQUEST, paymentRequest);
            phonePeIntent.putExtra(PhonePeConstants.POST_DATA, postData);
            phonePeIntent.putExtra(PhonePeConstants.PAYMENT_TYPE, PhonePeConstants.PHONEPE_INTENT);
            reference.get().startActivity(phonePeIntent);
        } else {
            analytics.log(PhonepeUtils.getLogMessage(reference.get(), PhonePeConstants.PHONE_PE_MAKE_PAYMENT_RESPONSE, PhonePeConstants.FAILURE, merchantKey, txnId));

            PhonePeData.SINGLETON.getPayUPhonePeCallback().onPaymentOptionFailure(null, null);
        }
    }

    /**
     * @param response
     */
    private void sendPaymentOptionResponse(String response) {
        L.v(" PPintent response check " + response);
        boolean result = parsePaymentOptionResponse(response);
        if (result) {
            // analytics.log(PhonepeUtils.getLogMessage(reference.get(), PhonePeConstants.PHONE_PE_PAYMENT_INITIALIZATION_STATUS, PhonePeConstants.SUCCESS,  merchantKey, txnId, PhonepeUtils.getVersionCode(reference.get())));
            PhonePeData.SINGLETON.getPayUPhonePeCallback().onPaymentOptionInitialisationSuccess(result);
        } else {
            // analytics.log(PhonepeUtils.getLogMessage(reference.get(), PhonePeConstants.PHONE_PE_PAYMENT_INITIALIZATION_STATUS, PhonePeConstants.FAILURE,  merchantKey, txnId, PhonepeUtils.getVersionCode(reference.get())));

            PhonePeData.SINGLETON.getPayUPhonePeCallback().onPaymentOptionInitialisationFailure(PhonePeConstants.MERCHANT_KEY_NOT_REGISTER_FOR_PHONEPE_CODE, PhonePeConstants.MERCHANT_KEY_NOT_REGISTER_FOR_PHONEPE);
        }
    }


    /**
     * @param response
     * @return
     */
    private boolean parsePaymentOptionResponse(String response) {
        if (response != null && response.length() > 0) {
            try {
                JSONObject responseObject = new JSONObject(response);
                if (responseObject.has(PhonePeConstants.IBIBO_CODES)) {
                    JSONObject ibiboCodeObject = responseObject.getJSONObject(PhonePeConstants.IBIBO_CODES);
                    if (ibiboCodeObject.has(PhonePeConstants.CASH_CARD)) {
                        JSONObject cashCardObject = ibiboCodeObject.getJSONObject(PhonePeConstants.CASH_CARD);
                        if (cashCardObject.has(PhonePeConstants.PPINTENT))
                            return true;
                    }
                }
            } catch (JSONException e) {
                return false;
            }
        }
        return false;
    }


    @Override
    public void isPhonepeAvailable(boolean showPhonepe) {
        if (showPhonepe) {
            initiatePayment(PhonePeConstants.PHONEPE_INTENT);
        } else {
            initiatePayment(PhonePeConstants.PHONEPE_COLLECT);
            // PhonePeData.SINGLETON.getPayUPhonePeCallback().onPaymentOptionInitialisationFailure(PhonePeConstants.PHONE_PE_NOT_INSTALLED, "Phonepe Application not installed.");
        }
    }

    private void checkPhonePeAvailability() {

        this.analytics = PayUAnalytics.getInstance(reference.get(), "local_cache_analytics");
        PhonePeData.SINGLETON.setPayUPhonePeCallback(PhonePeData.SINGLETON.getPayUPhonePeCallback());
        PayUNetworkAsyncTaskData browserAsyncTaskData = new PayUNetworkAsyncTaskData();
        browserAsyncTaskData.setHttpMethod(PhonePeConstants.POST);
        browserAsyncTaskData.setUrl(PhonePeData.SINGLETON.getWebServiceUrl());
        browserAsyncTaskData.setPostData(getPaymentAvailabilityPostData(merchantKey, paymentOptionHash, user_credentials));
        new PayUNetworkAsyncTask(this, PhonePeConstants.CHECK_PAYMENT_OPTION).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, browserAsyncTaskData);

    }

    /**
     * @param merchantKey
     * @param paymentOptionHash
     * @param user_credentials
     * @return
     */
    private String getPaymentAvailabilityPostData(String merchantKey, String paymentOptionHash, String user_credentials) {
        String postData = "command=" + PhonePeConstants.PAYMENT_RELATED_DETAILS_FOR_MOBILE_SDK +
                "&key=" + merchantKey + "&hash=" + paymentOptionHash + "&var1=" + user_credentials;
        return postData;
    }

    /**
     * @param callback
     * @param activity
     * @param postData
     * @param isUserCacheEnabled
     */
    void makePayment(PayUPhonePeCallback callback, Activity activity, String postData, boolean isUserCacheEnabled, View customDialogView) {
        this.analytics = PayUAnalytics.getInstance(activity, "local_cache_analytics");
        this.reference = new WeakReference<>(activity);
        this.isUserCacheEnabled = isUserCacheEnabled;
        this.postData = new PhonepeUtils().getAnalyticsAddedPostData(postData);
        this.mCustomDialogView = customDialogView;
        this.callback = callback;
        PhonePe.init(reference.get());
        PhonepeUtils.setMetaData(reference.get());
        PhonepeUtils.isPhonePeAppInstalled(reference, this);

    }


    private void initiatePayment(int paymentType) {
        if (callback == null)
            throw new IllegalStateException("PayUPhonePeCallback must not be null");
        this.merchantKey = PhonepeUtils.getDataFromPostData(postData).get(PhonePeConstants.KEY_);
        txnId = PhonepeUtils.getDataFromPostData(postData).get(PhonePeConstants.TRANSACTION_ID);

        PhonepeUtils.deviceAnalytics(merchantKey, reference.get(), postData);
        this.analytics = PayUAnalytics.getInstance(reference.get(), "local_cache_analytics");
        //  analytics.log( PhonepeUtils.getLogMessage(activity,"","makepayment",null,PhonepeUtils.getDataFromPostData(postData).get(PhonePeConstants.KEY_),PhonepeUtils.getDataFromPostData(postData).get(PhonePeConstants.TRANSACTION_ID),null,PhonepeUtils.getVersionCode(activity)));

        PhonePeData.SINGLETON.setPayUPhonePeCallback(callback);
        PhonePeData.SINGLETON.setPayUCustomDialogView(mCustomDialogView);


        if (paymentType == PhonePeConstants.PHONEPE_COLLECT) {
            postData = postData.replace("PPINTENT", "PHONEPE");
            Intent phonePeIntent = new Intent(reference.get(), com.payu.phonepe.PayUPhonePeActivity.class);
            phonePeIntent.putExtra(PhonePeConstants.PAYMENT_TYPE, PhonePeConstants.PHONEPE_COLLECT);
            phonePeIntent.putExtra(PhonePeConstants.POST_DATA, postData);
            reference.get().startActivity(phonePeIntent);
        } else {
            PayUNetworkAsyncTaskData browserAsyncTaskData = new PayUNetworkAsyncTaskData();
            browserAsyncTaskData.setUrl(PhonePeData.SINGLETON.getPostUrl());
            browserAsyncTaskData.setHttpMethod("POST");
            postData = postData.concat("&txn_s2s_flow=2");
            browserAsyncTaskData.setPostData(postData);
            PhonepeUtils.showProgressDialog(reference.get(), PhonePeData.SINGLETON.getPayUCustomDialogView());
            new PayUNetworkAsyncTask(this, PhonePeConstants.MAKE_PAYMENT).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, browserAsyncTaskData);
        }
    }

    /**
     * Parsing the response
     *
     * @param response
     * @return
     */
    public PaymentRequest parseResponse(String response) {
        if (null != response && response.trim().length() > 0) {
            try {
                JSONObject responseObject = new JSONObject(response);
                if (responseObject.has(PhonePeConstants.ENCODED_DATA)) {
                    paymentRequest = new PaymentRequest();
                    paymentRequest.setEncodedData(responseObject.getString(PhonePeConstants.ENCODED_DATA));
                }
                if (responseObject.has(PhonePeConstants.CHECKSUM)) {
                    paymentRequest.setChecksum(responseObject.getString(PhonePeConstants.CHECKSUM));
                }
                if (responseObject.has(PhonePeConstants.CALLBACK_URL)) {
                    paymentRequest.setCallbackUrl(responseObject.getString(PhonePeConstants.CALLBACK_URL));
                }
                if (responseObject.has(PhonePeConstants.RETURN_URL)) {
                    paymentRequest.setReturnUrl(responseObject.getString(PhonePeConstants.RETURN_URL));
                }
                paymentRequest.setUserCacheEnabled(isUserCacheEnabled);
                return paymentRequest;
            } catch (JSONException | NullPointerException ignored) {

            }
        }
        return null;
    }
}
