package com.payu.phonepe;

import android.app.Activity;
import android.view.View;

import com.payu.phonepe.callbacks.PayUPhonePeCallback;

/**
 *Entry point of the SDK.
 */
public class PhonePe  {

    private static PhonePe instance;
    public static String cb_version_name;
    public static String upi_sdk_version;

    private PhonePe() {
    }

    /**
     *
     * @return
     */
    public static PhonePe getInstance() {
        synchronized (PhonePe.class) {
            if (instance == null)
                instance = new PhonePe();
            return instance;
        }
    }

    /**
     * Check for the availability of PhonePe for the merchant key.
     * @param activity
     * @param callback
     * @param paymentOptionHash
     * @param merchantKey
     * @param user_credentials
     */
    public void checkForPaymentAvailability(Activity activity, PayUPhonePeCallback callback, String paymentOptionHash, String merchantKey, String user_credentials) {
        PhonePeHandler phonePeHandler = new PhonePeHandler();
        phonePeHandler.checkForPaymentAvailability(activity,callback,paymentOptionHash,merchantKey,user_credentials);

    }

    /**
     * Start making payment. Its called from {@link PhonePe} / {@link PhonePeWrapper} or Merchant application while using
     * standalone Phonepe SDK.
     * @param callback
     * @param activity
     * @param postData
     * @param isUserCacheEnabled
     */
    public void makePayment(PayUPhonePeCallback callback, Activity activity, String postData, boolean isUserCacheEnabled, View customDialogView) {

        PhonePeHandler phonePeHandler = new PhonePeHandler();
        phonePeHandler.makePayment(callback,activity,postData,isUserCacheEnabled,customDialogView);

    }


    /**
     *
     * @param callback
     * @param activity
     * @param postData
     * @param isUserCacheEnabled
     */
    public void makePayment(PayUPhonePeCallback callback, Activity activity, String postData, boolean isUserCacheEnabled) {
        makePayment(callback,activity,postData,isUserCacheEnabled,null);
    }

}
