package com.payu.phonepe;

import android.app.Activity;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.payu.payuanalytics.analytics.PayUAnalytics;
import com.payu.phonepe.javascript.PhonepeWebInterface;
import com.payu.socketverification.bean.PayUNetworkAsyncTaskData;
import com.payu.socketverification.interfaces.PayuNetworkAsyncTaskInterface;
import com.payu.socketverification.core.PayUNetworkAsyncTask;
import com.phonepe.intent.sdk.api.PhonePe;
import com.phonepe.intent.sdk.api.PhonePeInitException;
import com.phonepe.intent.sdk.api.TransactionRequest;
import com.phonepe.intent.sdk.api.TransactionRequestBuilder;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

/**
 * Activity that handles Phonepe SDK Calls
 */
public class PayUPhonePeActivity extends Activity implements PayuNetworkAsyncTaskInterface {
    private final String KEY_TRANSACTION_RESULT = "STATUS";
    private int DEBIT_REQUEST_CODE = 1001;
    private Map<String, String> headers;
    private WeakReference<Activity> reference;
    private PaymentRequest paymentRequest;
    private PayUAnalytics analytics;
    private String merchantKey, txnId;
    private com.payu.socketverification.widgets.PayUProgressDialog progressDialog;
    private int mPaymentType;
    private WebView mCollectWebView;
    private boolean isWebOpened;
    private String postData;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        makeNormalScreenForCollectFlowElseTransparent();
        setContentView(R.layout.activity_phonepe_response);
        mCollectWebView = findViewById(R.id.wvCollect);

        this.analytics = PayUAnalytics.getInstance(this, "local_cache_analytics");

        initIntentData();
        if (mPaymentType == PhonePeConstants.PHONEPE_INTENT) {
            startPhonepeSdkIntent();
        } else {
            startPhonepeCollect();
        }
    }

    /**
     * Making Activity Opaque in case of Collect flow to show the WebView.
     */
    private void makeNormalScreenForCollectFlowElseTransparent() {
        if (getIntent() != null && getIntent().getExtras() != null && getIntent().getExtras().get(PhonePeConstants.PAYMENT_TYPE) != null) {
            if (getIntent().getExtras().getInt(PhonePeConstants.PAYMENT_TYPE) == PhonePeConstants.PHONEPE_COLLECT) {
                setTheme(R.style.phonepe_opaque_screen);
            }

        }
    }

    private void startPhonepeCollect() {

        L.v("oncreate class name:" + getClass().getCanonicalName());
        setCollectWebViewSettings();
        PhonepeUtils.showProgressDialog(this, PhonePeData.SINGLETON.getPayUCustomDialogView());
        L.v("Postdata:-------------> " + postData);

        analytics.log(PhonepeUtils.getLogMessage(this.getApplicationContext(), PhonePeConstants.PAYMENT_OPTION, PhonePeConstants.PHONEPE_COLLECT_FLOW, merchantKey, txnId));
        if(null!= PhonePeData.SINGLETON.getPostUrl() && null!=postData)
        postUrlWebView(PhonePeData.SINGLETON.getPostUrl(), postData);
    }

    private void startPhonepeSdkIntent() {
        isWebOpened = false;
        if (!TextUtils.isEmpty(paymentRequest.getCallbackUrl())) {
            headers = new HashMap();
            headers.put("X-CALLBACK-URL", paymentRequest.getCallbackUrl());
            headers.put("X-CALLBACK-MODE", PhonePeConstants.POST);
        }
        TransactionRequestBuilder requestBuilder = new TransactionRequestBuilder();
        TransactionRequest request = requestBuilder.setChecksum(paymentRequest.getChecksum()).setData(paymentRequest.getEncodedData()).setUrl(PhonePeConstants.API_DEBIT).setHeaders((HashMap<String, String>) headers).build();
        try {
            analytics.log(PhonepeUtils.getLogMessage(this, PhonePeConstants.PAYMENT_OPTION, PhonePeConstants.PHONEPE_INTENT_FLOW, merchantKey, txnId));

            startActivityForResult(PhonePe.getTransactionIntent(request), DEBIT_REQUEST_CODE);
        } catch (PhonePeInitException e) {
            analytics.log(PhonepeUtils.getLogMessage(this, PhonePeConstants.EXCEPTION_PHONEPE, e.getMessage(), merchantKey, txnId));
            parsePhonePeResponse(Activity.RESULT_CANCELED, null);
            e.printStackTrace();
        }
    }


    private void initIntentData() {

        paymentRequest = (PaymentRequest) getIntent().getSerializableExtra(PhonePeConstants.PAYMENT_REQUEST);
        postData = getIntent().getStringExtra(PhonePeConstants.POST_DATA);
        mPaymentType = getIntent().getIntExtra(PhonePeConstants.PAYMENT_TYPE, 0);
        txnId = PhonepeUtils.getDataFromPostData(postData).get(PhonePeConstants.TRANSACTION_ID);
        merchantKey = PhonepeUtils.getDataFromPostData(postData).get(PhonePeConstants.KEY_);
    }

    /**
     * loading postData to webview.
     *
     * @param url
     * @param postData
     */
    private void postUrlWebView(String url, String postData) {
        if (mCollectWebView != null) {
            isWebOpened = true;
            mCollectWebView.setVisibility(View.VISIBLE);
            if(null!= url && null!=postData)
            mCollectWebView.postUrl(url, postData.getBytes());
        }
    }

    /**
     * setting for webview collect. Javascript interface enabling.
     * {@link com.payu.phonepe.javascript.PhonepeWebInterface} to handle @javascriptinterface methods
     */
    private void setCollectWebViewSettings() {
        if (mCollectWebView != null) {
            WebStorage.getInstance().deleteAllData();
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT >= 21) {
                cookieManager.removeAllCookies(null);
            } else {
                cookieManager.removeAllCookie();
            }
            mCollectWebView.getSettings().setJavaScriptEnabled(true);
            mCollectWebView.addJavascriptInterface(new PhonepeWebInterface(this, analytics), "PayU");
            mCollectWebView.setVisibility(View.GONE);
            mCollectWebView.setWebViewClient(new WebViewClient() {
                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    PhonepeUtils.hideProgressDialog(PayUPhonePeActivity.this);
                }
            });
        }
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == DEBIT_REQUEST_CODE) {
            if (resultCode == Activity.RESULT_OK)
                analytics.log(PhonepeUtils.getLogMessage(this, PhonePeConstants.PHONE_PE_PAYMENT_APP_RESPONSE, PhonePeConstants.RESULT_OK, merchantKey, txnId));
            else if (resultCode == Activity.RESULT_CANCELED)
                analytics.log(PhonepeUtils.getLogMessage(this, PhonePeConstants.PHONE_PE_PAYMENT_APP_RESPONSE, PhonePeConstants.ANALYTICS_CANCELLED, merchantKey, txnId));

            paymentVerify(resultCode, data);
        }
    }

    /**
     * @param resultCode
     * @param data
     */
    private void paymentVerify(int resultCode, Intent data) {
        PayUNetworkAsyncTaskData browserAsyncTaskData = new PayUNetworkAsyncTaskData();
        browserAsyncTaskData.setUrl(paymentRequest.getReturnUrl());
        String response = parsePhonePeResponse(resultCode, data);
        browserAsyncTaskData.setPostData(response);
        browserAsyncTaskData.setHttpMethod(PhonePeConstants.POST);
        this.reference = new WeakReference<Activity>(this);
        PhonepeUtils.showProgressDialog(reference.get(), PhonePeData.SINGLETON.getPayUCustomDialogView());
        new PayUNetworkAsyncTask(this, PhonePeConstants.VERFIY_PAYMENT).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, browserAsyncTaskData);

    }

    /**
     * Function to parse and create response string that
     * need to be send to PayU backend
     *
     * @param resultCode As received from PhonePe sdk
     * @param data       As received from PhonePe sdk
     * @return Response that need to be send to PayU backend
     */
    private String parsePhonePeResponse(int resultCode, Intent data) {
        String response = "status=";
        if (resultCode == Activity.RESULT_CANCELED) {
            return response.concat(PhonePeConstants.CANCELLED);
        } else {
            Bundle bundle = data.getExtras();
            if (null != bundle && null != bundle.getString(KEY_TRANSACTION_RESULT)) {
                return response.concat(bundle.getString(KEY_TRANSACTION_RESULT));
            }
            return response.concat(PhonePeConstants.CANCELLED);
        }
    }

    /**
     * Send response back to merchant callbacks{@link com.payu.phonepe.callbacks.PayUPhonePeCallback}
     *
     * @param response
     */
    private void sendResponseToMerchant(String response) {
        String responseStatus = parseVerifyResponse(response);
        String unmappedStatus = getUnMappedStatus(response);
        analytics.log(PhonepeUtils.getLogMessage(this, PhonePeConstants.TRNX_STATUS, unmappedStatus, merchantKey, txnId));
        if (responseStatus.equalsIgnoreCase(PhonePeConstants.FAILURE)) {
            PhonePeData.SINGLETON.getPayUPhonePeCallback().onPaymentOptionFailure(response,null);
        } else {
            PhonePeData.SINGLETON.getPayUPhonePeCallback().onPaymentOptionSuccess(response,null);
        }
        finish();
    }

    /**
     * Parses the input response on value of {@link PhonePeConstants#STATUS}
     *
     * @param response Input response from server
     * @return Return value of key{@link PhonePeConstants#STATUS}
     */
    public String parseVerifyResponse(String response) {
        try {
            JSONObject jsonObject = new JSONObject(response);
            if (jsonObject.has(PhonePeConstants.STATUS)) {
                return jsonObject.getString(PhonePeConstants.STATUS);
            } else {
                return PhonePeConstants.FAILURE;
            }
        } catch (JSONException e) {
            return PhonePeConstants.FAILURE;
        }
    }

    /**
     * Method to get unmappedstatus from Backend Verify Api response
     * @param response Verify Api response
     * @return Unmappedstatus value
     */
    public String getUnMappedStatus(String response) {
        try {
            JSONObject jsonObject = new JSONObject(response);
            if (jsonObject.has(PhonePeConstants.UNMAPPEDSTATUS)) {
                return jsonObject.getString(PhonePeConstants.UNMAPPEDSTATUS);
            } else {
                return PhonePeConstants.FAILURE;
            }
        } catch (JSONException e) {
            return PhonePeConstants.FAILURE;
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (paymentRequest != null) {
            if (!paymentRequest.isUserCacheEnabled()) {
                try {
                    PhonePe.logout();
                } catch (PhonePeInitException e) {
                    e.printStackTrace();
                }
            }
        }
        PhonePeData.SINGLETON.getPayUPhonePeCallback().onPaymentTerminate();
    }

    @Override
    public void onPayuNetworkAsyncTaskResponse(String payUAsyncTaskResponse, String webServiceType) {
        if (PhonePeConstants.VERFIY_PAYMENT.equals(webServiceType)) {
            PhonepeUtils.hideProgressDialog(reference.get());
            sendResponseToMerchant(payUAsyncTaskResponse);
        }
    }

    @Override
    public void onBackPressed() {
        //   super.onBackPressed();
        if (isWebOpened) {
            confirmationDialog();
        } else {
            PhonePeData.SINGLETON.getPayUPhonePeCallback().onPaymentOptionFailure(null,null);

            finish();
        }
    }

    /**
     * Creating confirmation dialog.
     */
    private void confirmationDialog() {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                if (i == -1) {

                    PhonePeData.SINGLETON.getPayUPhonePeCallback().onBackApprove();
                    analytics.log(PhonepeUtils.getLogMessage(getApplicationContext(), PhonePeConstants.PHONE_PE + PhonePeConstants.PAYMENT_APP_RESPONSE, PhonePeConstants.CANCEL_BACK_BUTTON, merchantKey, txnId));
                    finish();
                } else if (i == -2) {
                    PhonePeData.SINGLETON.getPayUPhonePeCallback().onBackDismiss();
                    dialogInterface.dismiss();
                }
            }
        };
        PhonepeUtils.getAlertDialog(this, onClickListener, getString(R.string.payu_gpay_ok), getString(R.string.payu_gpay_cancel), null, getString(R.string.payu_gpay_do_you_really_want_to_cancel_the_transaction));
    }
}
