//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Tasks;

import android.os.AsyncTask;

import com.payu.india.Interfaces.EligibleBinsForEMIApiListener;
import com.payu.india.Interfaces.BinInfoApiListener;
import com.payu.india.Model.CardInformation;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * Async task which takes care of getting Eligible Bins for EMI
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link BinInfoTask } should implement {@link EligibleBinsForEMIApiListener}
 */
public class BinInfoTask extends AsyncTask<PayuConfig, String, PayuResponse> {

    BinInfoApiListener apiListener;

    public BinInfoTask(BinInfoApiListener apiListener) {
        this.apiListener = apiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }


            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {

                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());

                if (jsonResponse.has(PayuConstants.STATUS) && jsonResponse.optInt(PayuConstants.STATUS) == 0) {
                    postData.setCode(PayuErrors.GET_BIN_INFO_API_EXCEPTION);
                    postData.setStatus(PayuConstants.ERROR);
                    postData.setResult(jsonResponse.optString("data") != null ? jsonResponse.optString("data") : "Something went wrong");
                } else if (jsonResponse.optInt(PayuConstants.STATUS) == 1) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                    CardInformation cardInformation = new CardInformation();
                    JSONObject binsData = jsonResponse.getJSONObject("data").getJSONObject("bins_data");
                    cardInformation.setIssuingBank(binsData.getString(PayuConstants.BIN_INFO_ISSUING_BANK));
                    cardInformation.setBin(binsData.getString(PayuConstants.BIN_INFO_BIN_VALUE));
                    cardInformation.setCardCategory(binsData.getString(PayuConstants.BIN_INFO_CARD_CATEGORY).equalsIgnoreCase("debitcard")?"DC":"CC");
                    cardInformation.setCardType(binsData.getString(PayuConstants.BIN_INFO_CARD_TYPE));

                    cardInformation.setIsZeroRedirectSupported(binsData.optInt(PayuConstants.BIN_INFO_IS_ZERO_REDIRECT_SUPPORTED) == 1);
                    cardInformation.setIsOtpOnTheFly(binsData.optInt(PayuConstants.BIN_INFO_IS_OTP_ON_THE_FLY) == 1);
                    cardInformation.setIsAtmPinCard(binsData.optString(PayuConstants.BIN_INFO_IS_ATM_PIN_CARD).contentEquals("1"));

                    //opted because we will get this value only if var5=1 is passed
                    cardInformation.setIsSiSupported(binsData.optInt(PayuConstants.BIN_INFO_IS_SI_SUPPORTED) == 1);
                    cardInformation.setPgId(binsData.optString(PayuConstants.PG_ID));

                    cardInformation.setIsDomestic(binsData.getString(PayuConstants.BIN_INFO_IS_DOMESTIC).contentEquals("1"));
                    payuResponse.setCardInformation(cardInformation);
                }

            }
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (JSONException e) {
            e.printStackTrace();
        }

        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        apiListener.onBinInfoApiResponse(payuResponse);
    }
}
