//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import com.payu.india.Payu.PayuConstants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by franklin on 5/26/15.
 * Simple Bean implementation of PayuResponse.
 * Everytime Task talks to payu server, the responses will be filled in {@link PayuResponse}
 * {@link PayuResponse#storedCards} is a collection (ArrayList) of {@link StoredCard}
 * {@link PayuResponse#emi} is a collection (ArrayList) of {@link Emi}
 * {@link PayuResponse#noCostEMI} is a collection (ArrayList) of {@link Emi}
 * {@link PayuResponse#creditCard} is a collection (ArrayList) of {@link PaymentDetails}
 * {@link PayuResponse#debitCard} is a collection (ArrayList) of {@link PaymentDetails}
 * {@link PayuResponse#cashCard} is a collection (ArrayList) of {@link PaymentDetails}
 * {@link PayuResponse#netBanks} is a collection (ArrayList) of {@link PaymentDetails}
 * {@link PayuResponse#ivr} is a collection (ArrayList) of {@link PaymentDetails}
 * {@link PayuResponse#ivrdc} is a collection (ArrayList) of {@link PaymentDetails}
 * {@link PayuResponse#paisaWallet} is a collection (ArrayList) of {@link PaymentDetails}
 * {@link PayuResponse#responseStatus} is {@link PostData}
 * {@link PayuResponse#netBankingDownStatus} is a hashmap  key(string) - bank code, value(string) - status TODO set the status value in constants.
 * {@link PayuResponse#cardInformation} is  {@link CardInformation}
 * {@link PayuResponse#issuingBankStatus} is a hash map - key -(string) - card bin(first 6 digit of cardno), value({@link CardStatus}) - holds the name of the issuing bank and status.
 * {@link PayuResponse#payuOffer} is {@link PayuOffer}
 * {@link PayuResponse#transactionDetailsList} is collection of (ArrayList) of {@link TransactionDetails}
 */

public class PayuResponse implements Parcelable {

    public static final Creator<PayuResponse> CREATOR = new Creator<PayuResponse>() {
        @Override
        public PayuResponse createFromParcel(Parcel in) {
            return new PayuResponse(in);
        }

        @Override
        public PayuResponse[] newArray(int size) {
            return new PayuResponse[size];
        }
    };
    private ArrayList<StoredCard> storedCards;
    private ArrayList<Emi> emi;
    private ArrayList<Emi> noCostEMI;
    private ArrayList<PaymentDetails> creditCard;
    private ArrayList<PaymentDetails> debitCard;
    private ArrayList<PaymentDetails> netBanks;
    private ArrayList<PaymentDetails> cashCard;
    private ArrayList<PaymentDetails> ivr;
    private ArrayList<PaymentDetails> ivrdc;
    private ArrayList<PaymentDetails> paisaWallet;
    private ArrayList<PaymentDetails> lazyPay;
    private ArrayList<EligibleEmiBins> eligibleEmiBins;
    private ArrayList<PaymentDetails> standingInstructions;
    private ArrayList<PaymentDetails> siBankList;

    public ArrayList<EligibleEmiBins> getEligibleEmiBins() {
        return eligibleEmiBins;
    }

    public void setEligibleEmiBins(ArrayList<EligibleEmiBins> eligibleEmiBins) {
        this.eligibleEmiBins = eligibleEmiBins;
    }

    public Upi getUpi() {
        return upi;
    }

    public void setUpi(Upi upi) {
        this.upi = upi;
    }

    private Upi upi;

    private Upi googleTez;

    private Upi genericIntent;

    private PaymentDetails phonePe;

    public Upi getGoogleTez() {
        return googleTez;
    }

    public void setGoogleTez(Upi googleTez) {
        this.googleTez = googleTez;
    }

    private PostData responseStatus;
    private CardInformation cardInformation;
    private HashMap<String, Integer> netBankingDownStatus;
    private HashMap<String, CardStatus> issuingBankStatus;
    private PayuOffer payuOffer;
    private ArrayList<TransactionDetails> transactionDetailsList;

    public ArrayList<PayuOffer> getOfferDetailsList() {
        return offerDetailsList;
    }

    public void setOfferDetailsList(ArrayList<PayuOffer> offerDetailsList) {
        this.offerDetailsList = offerDetailsList;
    }

    private ArrayList<PayuOffer> offerDetailsList;

    public PayuOfferDetails getPayuOfferDetails() {
        return payuOfferDetails;
    }

    public void setPayuOfferDetails(PayuOfferDetails payuOfferDetails) {
        this.payuOfferDetails = payuOfferDetails;
    }

    private PayuOfferDetails payuOfferDetails;

    // PayU Response for API getEmiAmountAccordingToInterest
    private HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>> payuEmiAmountAccordingToInterest;


    protected PayuResponse(Parcel in) {
        storedCards = in.createTypedArrayList(StoredCard.CREATOR);
        emi = in.createTypedArrayList(Emi.CREATOR);
        noCostEMI = in.createTypedArrayList(Emi.CREATOR);
        creditCard = in.createTypedArrayList(PaymentDetails.CREATOR);
        debitCard = in.createTypedArrayList(PaymentDetails.CREATOR);
        netBanks = in.createTypedArrayList(PaymentDetails.CREATOR);
        cashCard = in.createTypedArrayList(PaymentDetails.CREATOR);
        ivr = in.createTypedArrayList(PaymentDetails.CREATOR);
        ivrdc = in.createTypedArrayList(PaymentDetails.CREATOR);
        paisaWallet = in.createTypedArrayList(PaymentDetails.CREATOR);
        lazyPay = in.createTypedArrayList(PaymentDetails.CREATOR);
        responseStatus = in.readParcelable(PostData.class.getClassLoader());
        cardInformation = in.readParcelable(CardInformation.class.getClassLoader());
        payuOffer = in.readParcelable(PayuOffer.class.getClassLoader());
        transactionDetailsList = in.createTypedArrayList(TransactionDetails.CREATOR);
        offerDetailsList = in.createTypedArrayList(PayuOffer.CREATOR);
        payuOfferDetails = in.readParcelable(PayuOfferDetails.class.getClassLoader());
        payuEmiAmountAccordingToInterest = in.readHashMap(PayuEmiAmountAccordingToInterest.class.getClassLoader());
        eligibleEmiBins = in.createTypedArrayList(EligibleEmiBins.CREATOR);
        standingInstructions = in.createTypedArrayList(PaymentDetails.CREATOR);
        siBankList = in.createTypedArrayList(PaymentDetails.CREATOR);

    }

    public PayuResponse() {
    }

    public ArrayList<StoredCard> getStoredCards() {
        return storedCards;
    }

    public void setStoredCards(ArrayList<StoredCard> storedCards) {
        this.storedCards = storedCards;
    }

    public ArrayList<Emi> getEmi() {
        return emi;
    }

    public void setEmi(ArrayList<Emi> emi) {
        this.emi = emi;
    }

    public ArrayList<Emi> getNoCostEMI() {
        return noCostEMI;
    }

    public void setNoCostEMI(ArrayList<Emi> noCostEMI) {
        this.noCostEMI = noCostEMI;
    }

    public ArrayList<PaymentDetails> getCreditCard() {
        return creditCard;
    }

    public void setCreditCard(ArrayList<PaymentDetails> creditCard) {
        this.creditCard = creditCard;
    }

    public ArrayList<PaymentDetails> getDebitCard() {
        return debitCard;
    }

    public void setDebitCard(ArrayList<PaymentDetails> debitCard) {
        this.debitCard = debitCard;
    }

    public ArrayList<PaymentDetails> getNetBanks() {
        return netBanks;
    }

    public void setNetBanks(ArrayList<PaymentDetails> netBanks) {
        this.netBanks = netBanks;
    }

    public ArrayList<PaymentDetails> getCashCard() {
        return cashCard;
    }

    public void setCashCard(ArrayList<PaymentDetails> cashCard) {
        this.cashCard = cashCard;
    }

    public ArrayList<PaymentDetails> getIvr() {
        return ivr;
    }

    public void setIvr(ArrayList<PaymentDetails> ivr) {
        this.ivr = ivr;
    }

    public ArrayList<PaymentDetails> getIvrdc() {
        return ivrdc;
    }

    public void setIvrdc(ArrayList<PaymentDetails> ivrdc) {
        this.ivrdc = ivrdc;
    }

    public ArrayList<PaymentDetails> getPaisaWallet() {
        return paisaWallet;
    }

    public void setPaisaWallet(ArrayList<PaymentDetails> paisaWallet) {
        this.paisaWallet = paisaWallet;
    }

    public ArrayList<PaymentDetails> getLazyPay() {
        return lazyPay;
    }

    public void setLazyPay(ArrayList<PaymentDetails> lazyPay) {
        this.lazyPay = lazyPay;
    }

    public PostData getResponseStatus() {
        return responseStatus;
    }

    public void setResponseStatus(PostData responseStatus) {
        this.responseStatus = responseStatus;
    }

    public CardInformation getCardInformation() {
        return cardInformation;
    }

    public void setCardInformation(CardInformation cardInformation) {
        this.cardInformation = cardInformation;
    }

    public HashMap<String, Integer> getNetBankingDownStatus() {
        return netBankingDownStatus;
    }

    public void setNetBankingDownStatus(HashMap<String, Integer> netBankingDownStatus) {
        this.netBankingDownStatus = netBankingDownStatus;
    }

    public HashMap<String, CardStatus> getIssuingBankStatus() {
        return issuingBankStatus;
    }

    public void setIssuingBankStatus(HashMap<String, CardStatus> issuingBankStatus) {
        this.issuingBankStatus = issuingBankStatus;
    }

    public PayuOffer getPayuOffer() {
        return payuOffer;
    }

    public void setPayuOffer(PayuOffer payuOffer) {
        this.payuOffer = payuOffer;
    }

    public HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>> getPayuEmiAmountAccordingToInterest() {
        return payuEmiAmountAccordingToInterest;
    }

    public void setPayuEmiAmountAccordingToInterest(HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>> payuEmiAmountAccordingToInterest) {
        this.payuEmiAmountAccordingToInterest = payuEmiAmountAccordingToInterest;
    }


    public ArrayList<TransactionDetails> getTransactionDetailsList() {
        return transactionDetailsList;
    }

    public void setTransactionDetailsList(ArrayList<TransactionDetails> transactionDetailsList) {
        this.transactionDetailsList = transactionDetailsList;
    }

    public void setPhonePe(PaymentDetails phonePe) {
        this.phonePe = phonePe;
    }

    public Upi getGenericIntent() {
        return genericIntent;
    }

    public void setGenericIntent(Upi genericIntent) {
        this.genericIntent = genericIntent;
    }

    // to avoid null pointer exception lets define isAvailable method.
    public Boolean isStoredCardsAvailable() {
        return this.storedCards != null && this.storedCards.size() > 0;
    }

    public Boolean isEligibleEmiBinsAvailable(){
        return this.eligibleEmiBins != null && this.eligibleEmiBins.size() > 0;
    }

    public Boolean isPhonePeIntentAvailable() {
        return this.phonePe != null;
    }
    public Boolean isGenericIntentAvailable() {
        return this.genericIntent != null;
    }

    public Boolean isEmiAvailable() {
        return this.emi != null && this.emi.size() > 0;
    }

    public Boolean isNoCostEmiAvailable() {
        return this.noCostEMI != null && this.noCostEMI.size() > 0;
    }

    public Boolean isUpiAvailable() {
        return this.upi != null;
    }

    public Boolean isGoogleTezAvailable() {
        return this.googleTez != null;
    }

    public Boolean isLazyPayAvailable() {
        return this.lazyPay != null && this.lazyPay.size() > 0;
    }

    public Boolean isCreditCardAvailable() {
        return this.creditCard != null && this.creditCard.size() > 0;
    }

    public Boolean isDebitCardAvailable() {
        return this.debitCard != null && this.debitCard.size() > 0;
    }

    public Boolean isNetBanksAvailable() {
        return this.netBanks != null && this.netBanks.size() > 0;
    }

    public Boolean isCashCardAvailable() {
        return this.cashCard != null && this.cashCard.size() > 0;
    }

    public Boolean isIVRAvailable() {
        return this.ivr != null && this.ivr.size() > 0;
    }

    public Boolean isIVRDCAvailable() {
        return this.ivrdc != null && this.ivrdc.size() > 0;
    }

    public Boolean isPaisaWalletAvailable() {
        return this.paisaWallet != null && this.paisaWallet.size() > 0;
    }

    public Boolean isResponseAvailable() {
        return this.responseStatus != null;
    }

    public Boolean isCardInformationAvailable() {
        return this.cardInformation != null;
    }

    public Boolean isNetBankingStatusAvailable() {
        return this.netBankingDownStatus != null;
    }

    public Boolean isIssuingBankStatusAvailable() {
        return this.issuingBankStatus != null;
    }

    public Boolean isPayuOfferAvailable() {
        return this.payuOffer != null;
    }

    public Boolean isOfferDetailsAvailable() {
        return this.offerDetailsList != null;
    }

    public Boolean isPayuEmiAmountAccordingToInterestAvailable() {
        return this.payuEmiAmountAccordingToInterest != null;
    }

    public boolean isOfferAllowedOn(String bankCode, ArrayList<String> allowedOnList) {
        Set<String> offerAllowedOnSet = new HashSet<>(allowedOnList);
        return offerAllowedOnSet.contains(bankCode);
    }

    public ArrayList<PaymentDetails> getStandingInstructions() {
        return standingInstructions;
    }

    public void setStandingInstructions(ArrayList<PaymentDetails> standingInstructions) {
        this.standingInstructions = standingInstructions;
    }

    public Boolean isStandingInstructionsAvailable(){
        return this.standingInstructions != null && this.standingInstructions.size() > 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(storedCards);
        dest.writeTypedList(emi);
        dest.writeTypedList(noCostEMI);
        dest.writeTypedList(creditCard);
        dest.writeTypedList(debitCard);
        dest.writeTypedList(netBanks);
        dest.writeTypedList(cashCard);
        dest.writeTypedList(ivr);
        dest.writeTypedList(ivrdc);
        dest.writeTypedList(paisaWallet);
        dest.writeTypedList(lazyPay);
        dest.writeParcelable(responseStatus, flags);
        dest.writeParcelable(cardInformation, flags);
        dest.writeParcelable(payuOffer, flags);
        dest.writeTypedList(transactionDetailsList);
        dest.writeTypedList(offerDetailsList);
        dest.writeParcelable(payuOfferDetails, flags);
        dest.writeMap(payuEmiAmountAccordingToInterest);
        dest.writeTypedList(eligibleEmiBins);
        dest.writeTypedList(standingInstructions);
        dest.writeTypedList(siBankList);
    }

    public ArrayList<PaymentDetails> getSiBankList() {
        return siBankList;
    }

    public void setSiBankList(ArrayList<PaymentDetails> siBankList) {
        this.siBankList = siBankList;
    }

    public Boolean isSIBankListAvailable() {
        return this.siBankList != null && this.siBankList.size() > 0;
    }

    public Boolean isCreditCardAvailableFoSI() {
        if (standingInstructions != null) {
            for (PaymentDetails payment: standingInstructions) {
                if(payment.getBankCode().equalsIgnoreCase(PayuConstants.CCSI))
                    return true;
            }
        }
       return false;
    }

    public Boolean isDebitCardAvailableFoSI() {
        if (standingInstructions != null) {
            for (PaymentDetails payment : standingInstructions) {
                if (payment.getBankCode().equalsIgnoreCase(PayuConstants.DCSI) ||
                        payment.getBankCode().equalsIgnoreCase(PayuConstants.HDFCDCSI))
                    return true;
            }
        }
        return false;
    }

    public Boolean isNBAvailableFoSI() {
        return  siBankList != null && siBankList.size() > 0;
    }

    public Boolean isUPIAvailableFoSI() {
        if (standingInstructions != null) {
            for (PaymentDetails payment : standingInstructions) {
                if (payment.getBankCode().equalsIgnoreCase(PayuConstants.UPISI))
                    return true;
            }
        }
        return false;
    }

}
