//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.HashMap;

/**
 * Created by Shoaib on 30/3/16.
 * Simple bean implementation of payu offers.
 * should be used with {@link com.payu.india.Interfaces.GetOfferStatusApiListener}
 */
public class PayuEmiAmountAccordingToInterest implements Parcelable {

    private String emiBankInterest;
    private String bankRate;
    private String bankCharge;
    private String amount;
    private String cardType;
    private String emiValue;
    private String emiInterestPaid;
    private String tenure;

    public static final Creator<PayuEmiAmountAccordingToInterest> CREATOR = new Creator<PayuEmiAmountAccordingToInterest>() {
        @Override
        public PayuEmiAmountAccordingToInterest createFromParcel(Parcel in) {
            return new PayuEmiAmountAccordingToInterest(in);
        }

        @Override
        public PayuEmiAmountAccordingToInterest[] newArray(int size) {
            return new PayuEmiAmountAccordingToInterest[size];
        }
    };

    protected PayuEmiAmountAccordingToInterest(Parcel in) {
        emiBankInterest = in.readString();
        bankRate = in.readString();
        bankCharge = in.readString();
        amount = in.readString();
        cardType = in.readString();
        emiValue = in.readString();
        emiInterestPaid = in.readString();
        tenure = in.readString();
    }

    public PayuEmiAmountAccordingToInterest() {
    }

    public String getEmiBankInterest() {
        return emiBankInterest;
    }

    public void setEmiBankInterest(String emiBankInterest) {
        this.emiBankInterest = emiBankInterest;
    }

    public String getBankRate() {
        return bankRate;
    }

    public void setBankRate(String bankRate) {
        this.bankRate = bankRate;
    }

    public String getBankCharge() {
        return bankCharge;
    }

    public void setBankCharge(String bankCharge) {
        this.bankCharge = bankCharge;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getEmiValue() {
        return emiValue;
    }

    public void setEmiValue(String emiValue) {
        this.emiValue = emiValue;
    }

    public String getEmiInterestPaid() {
        return emiInterestPaid;
    }

    public void setEmiInterestPaid(String emiInterestPaid) {
        this.emiInterestPaid = emiInterestPaid;
    }

    public String getTenure() {
        return tenure;
    }

    public void setTenure(String tenure) {
        this.tenure = tenure;
    }

    /**
     * getEmiAmountAccordingToInterestResponse API response helper
     * Pass bankcode, emiMonths and API response to get EMI details
     * for this bankcode and emiMonths duration
     *
     * @param bankCode    BankCode returned from API
     * @param emiMonths   EMIMonths returned from API
     * @param emiResponse getEmiAmountAccordingToInterestResponse API response from PayuResponse
     * @return            EMI Details
     */
    public static PayuEmiAmountAccordingToInterest payuEmiAmountAccordingToInterestResponseHelper(String bankCode, String emiMonths, HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>> emiResponse){
        PayuEmiAmountAccordingToInterest response = null;
        try {
            response = emiResponse.get(bankCode).get(emiMonths);
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            return response;
        }
    }

    /**
     * getEmiAmountAccordingToInterestResponse API response helper
     * Pass bankcode and API response to get EMI details of all the months
     * for this bankcode
     *
     * @param bankCode    BankCode returned from API
     * @param emiResponse getEmiAmountAccordingToInterestResponse API response from PayuResponse
     * @return            EMI Details of all the months
     */
    public static HashMap<String, PayuEmiAmountAccordingToInterest> payuEmiAmountAccordingToInterestResponseHelper(String bankCode, HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>> emiResponse){
        HashMap<String, PayuEmiAmountAccordingToInterest> response = null;
        try {
            response = emiResponse.get(bankCode);
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            return response;
        }
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(emiBankInterest);
        dest.writeString(bankRate);
        dest.writeString(bankCharge);
        dest.writeString(amount);
        dest.writeString(cardType);
        dest.writeString(emiValue);
        dest.writeString(emiInterestPaid);
        dest.writeString(tenure);
    }
}
