//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by franklin on 5/26/15.
 * Simple Bean implementation of Payment details.
 * Payment details should be used only with {@link PayuResponse#creditCard}, {@link PayuResponse#debitCard}, {@link PayuResponse#cashCard}, {@link PayuResponse#ivr}, {@link PayuResponse#ivrdc}, {@link PayuResponse#paisaWallet}
 */
public class PaymentDetails implements Parcelable {
    public static final Parcelable.Creator<PaymentDetails> CREATOR
            = new Parcelable.Creator<PaymentDetails>() {
        public PaymentDetails createFromParcel(Parcel in) {
            return new PaymentDetails(in);
        }

        public PaymentDetails[] newArray(int size) {
            return new PaymentDetails[size];
        }
    };
    private String bankName; // Name of the bank
    private String bankCode; // Bank code given by payu
    private String bankId; // Bank id (not being used in sdk)
    private String pgId; // Pg id (not being used in sdk)
    private String additionalCharge; // Additional charges for bankCode, if any

    public PaymentDetails() {
    }

    private PaymentDetails(Parcel in) {
        bankCode = in.readString();
        bankName = in.readString();
        bankId = in.readString();
        pgId = in.readString();
        additionalCharge = in.readString();
    }

    public String getAdditionalCharge() {
        return additionalCharge;
    }

    public void setAdditionalCharge(String additionalCharge) {
        this.additionalCharge = additionalCharge;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBankId() {
        return bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getPgId() {
        return pgId;
    }

    public void setPgId(String pgId) {
        this.pgId = pgId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(bankCode);
        dest.writeString(bankName);
        dest.writeString(bankId);
        dest.writeString(pgId);
        dest.writeString(additionalCharge);
    }
}
