package com.payu.india.Model;

import com.payu.india.Payu.PayuConstants;

import org.json.JSONException;
import org.json.JSONObject;

public class GetCheckoutDetailsRequestBuilder {

    private boolean getAdditionalCharges = false;
    private String requestId = String.valueOf(System.currentTimeMillis());
    private double amount;

    public GetCheckoutDetailsRequestBuilder shouldGetAdditionalCharges(boolean getAdditionalCharges) {
        this.getAdditionalCharges = getAdditionalCharges;
        return this;
    }

    public GetCheckoutDetailsRequestBuilder setAmount(double amount) {
        this.amount = amount;
        return this;
    }

    public String build() {
        return prepareJSON();
    }

    private String prepareJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PayuConstants.P_REQUEST_ID, requestId);

            JSONObject transactionDetails = new JSONObject();
            transactionDetails.put(PayuConstants.P_AMOUNT, amount);
            jsonObject.put(PayuConstants.P_TRANSACTION_DETAILS, transactionDetails);

            JSONObject useCase = new JSONObject();
            if (getAdditionalCharges)
                useCase.put(PayuConstants.P_GET_ADDITIONAL_CHARGES, getAdditionalCharges);
            jsonObject.put(PayuConstants.P_USE_CASE, useCase);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }
}
