//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;



/**
 * Created by franklin on 5/26/15.
 * Simple Bean of Emi card,
 * Since its parcelable you can pass it through intent with out any difficulty.
 * When app tries to make payment it should get the post params }
 */
public class Emi implements Parcelable {

    public static final Parcelable.Creator<Emi> CREATOR
            = new Parcelable.Creator<Emi>() {
        public Emi createFromParcel(Parcel in) {
            return new Emi(in);
        }

        public Emi[] newArray(int size) {
            return new Emi[size];
        }
    };
    private String bankName; // name of the bank
    private String bankCode; // bank code given by payu
    private String bankTitle; // bank title (not being used)
    private String pgId; // pg id. (not being used)
    private String bankId; // bank id (not being used)
    private String minAmount; // min amount for transaction
    private String additionalCharge; // additional charge for transaction

    public Emi() {
    }

    private Emi(Parcel in) {
        bankCode = in.readString();
        bankName = in.readString();
        bankTitle = in.readString();
        bankId = in.readString();
        minAmount = in.readString();
        pgId = in.readString();
        additionalCharge = in.readString();
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBankTitle() {
        return bankTitle;
    }

    public void setBankTitle(String bankTitle) {
        this.bankTitle = bankTitle;
    }

    public String getPgId() {
        return pgId;
    }

    public void setPgId(String pgId) {
        this.pgId = pgId;
    }

    public String getBankId() {
        return bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(String minAmount) {
        this.minAmount = minAmount;
    }

    public String getAdditionalCharge() {
        return additionalCharge;
    }

    public void setAdditionalCharge(String additionalCharge) {
        this.additionalCharge = additionalCharge;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(bankCode);
        dest.writeString(bankName);
        dest.writeString(bankTitle);
        dest.writeString(bankId);
        dest.writeString(minAmount);
        dest.writeString(pgId);
        dest.writeString(additionalCharge);
    }
}