//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;


/**
 * Simple Bean of Eligible EMI Bins,
 * Since its parcelable you can pass it through intent with out any difficulty.
 * When app tries to make payment it should get the post params }
 */
public class EligibleEmiBins implements Parcelable {

    public static final Creator<EligibleEmiBins> CREATOR
            = new Creator<EligibleEmiBins>() {
        public EligibleEmiBins createFromParcel(Parcel in) {
            return new EligibleEmiBins(in);
        }

        public EligibleEmiBins[] newArray(int size) {
            return new EligibleEmiBins[size];
        }
    };

    private String bankShortName;
    private ArrayList<String> cardBins;
    private int minAmount;
    private int isEligible;

    public EligibleEmiBins() {
    }

    public String getBankShortName() {
        return bankShortName;
    }

    public void setBankShortName(String bankShortName) {
        this.bankShortName = bankShortName;
    }

    public ArrayList<String> getCardBins() {
        return cardBins;
    }

    public void setCardBins(ArrayList<String> cardBins) {
        this.cardBins = cardBins;
    }

    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public Integer getIsEligible() {
        return isEligible;
    }

    public void setIsEligible(Integer isEligible) {
        this.isEligible = isEligible;
    }

    private EligibleEmiBins(Parcel in) {
        bankShortName = in.readString();
        minAmount = in.readInt();
        cardBins = in.createStringArrayList();
        isEligible = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(bankShortName);
        dest.writeInt(minAmount);
        dest.writeStringList(cardBins);
        dest.writeInt(isEligible);
    }
}