package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

/**
 * Created by franklin.michael on 04/04/16.
 * Bean for #{@link com.payu.india.Tasks.CheckOfferDetailsTask api}
 * this Bean holds all user cards and its offer details in case of user_credentials mode
 * in case on nb or card_number it holds list of offer details. 
 */
public class PayuOfferDetails implements Parcelable{

    public PayuOfferDetails(){}

    public ArrayList<PayuUserOffer> getUserOffersList() {
        return userOffersList;
    }

    public void setUserOffersList(ArrayList<PayuUserOffer> userOffersList) {
        this.userOffersList = userOffersList;
    }

    public ArrayList<PayuOffer> getPayuOfferList() {
        return payuOfferList;
    }

    public void setPayuOfferList(ArrayList<PayuOffer> payuOfferList) {
        this.payuOfferList = payuOfferList;
    }

    private ArrayList<PayuUserOffer> userOffersList; // will be used in case of user_credentials.
    private ArrayList<PayuOffer> payuOfferList; // will be used in case of nb and card number.


    protected PayuOfferDetails(Parcel in) {
        userOffersList = in.createTypedArrayList(PayuUserOffer.CREATOR);
        payuOfferList = in.createTypedArrayList(PayuOffer.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(userOffersList);
        dest.writeTypedList(payuOfferList);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PayuOfferDetails> CREATOR = new Creator<PayuOfferDetails>() {
        @Override
        public PayuOfferDetails createFromParcel(Parcel in) {
            return new PayuOfferDetails(in);
        }

        @Override
        public PayuOfferDetails[] newArray(int size) {
            return new PayuOfferDetails[size];
        }
    };
}
