package com.payu.gpay.intent;

import android.app.Activity;
import android.content.Intent;
import android.os.CountDownTimer;
import android.webkit.JavascriptInterface;

import com.payu.gpay.R;
import com.payu.gpay.utils.GPayConstants;
import com.payu.gpay.utils.GPayData;
import com.payu.gpay.utils.GPayUtil;
import com.payu.gpay.utils.L;
import com.payu.payuanalytics.analytics.PayUAnalytics;


/**
 * @author shahbaz.ahmmod
 * Here we are handing the Collect flow.
 * This class has all the @JavascriptInterface methods. Using in {@link com.payu.gpay.GPayResponseActivity}
 */
public class GPayWebInterface {
    private Activity activity;
    private CountDownTimer countDownTimer;
    private String payuReponse;
    private PayUAnalytics payUAnalytics;

    public GPayWebInterface(Activity activity, PayUAnalytics payUAnalytics) {
        this.activity = activity;
        this.payUAnalytics = payUAnalytics;
        //UpiConfig upiConfig1 = upiConfig;
    }

    private Boolean isSuccessTransaction = Boolean.FALSE;
    private String merchantResponse;

    /**
     * @param result json data of post param.
     *               call back function from furl - failure transaction.
     *               keep the value in {@link #merchantResponse}
     *               set result ok, and send the received data.
     * @param result json string
     */

    @JavascriptInterface
    public void onFailure(String result) {
        L.v("Javascript onFailure Result "+result);
        merchantResponse = result;
        onMerchantUrlFinished();
    }

    /**
     * Attempt to deprecate furl.
     * Javascript call from payu server.
     * Lets keep the data in local variable and pass it to calling activity.
     *
     * @param result json string result of failure transaction
     */
    @JavascriptInterface
    public void onPayuFailure(String result) {
        L.v("Javascript onPayuFailure Result "+result);

        if (activity != null) {
            addEventAnalytics(GPayConstants.TRXN_STATUS, GPayConstants.FAILURE_TRANSACTION);
            isSuccessTransaction = false;
            payuReponse = result;
        }

        // cancelTransactionNotification();
        callTimer();
    }

    /**
     * Call back from surl - sucess transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onSuccess() {

        L.v("Javascript onSuccess ");
        onSuccess("");
    }

    /**
     * Attempt to deprecate surl.
     * Javascript interface call from payu server.
     * Lets keep the data in local variable and pass it to main activity.
     *
     * @param result json data of post param.
     */

    @JavascriptInterface
    public void onPayuSuccess(final String result) {
        L.v("Javascript onPayuSuccess "+result);
        isSuccessTransaction = true;
        addEventAnalytics(GPayConstants.TRXN_STATUS, GPayConstants.SUCCESS_TRANSACTION);
        payuReponse = result;
        L.v( "onPayUSucess " + result);
        callTimer();
    }

    /**
     * Logging events with txnid and package name.
     * Mixpannel used only in debug mode.
     *
     * @param key   analytics event key
     * @param value analytics event value
     */
    private void addEventAnalytics(String key, String value) {
        try {
            if (value != null && !value.trim().equalsIgnoreCase("")) {
                if(null!=activity && !activity.isFinishing() && !activity.isDestroyed())
                    payUAnalytics.log(GPayUtil.getLogMessage(activity.getApplicationContext(), key, value.toLowerCase(),   null, null));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * call back function from surl - success transaction.
     * keep the data in {@link #merchantResponse}
     * set result ok, and send the received data.
     *
     * @param result success result received from surl
     */
    @JavascriptInterface
    public void onSuccess(String result) {
        L.v( "Javascript onSuccess " + result);
        merchantResponse = result;
        onMerchantUrlFinished();
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel() {
        L.v( "Javascript onCancel ");
        onCancel("");
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel(final String result) {
        L.v( "Javascript onCancel " + result);
        if (activity != null && !activity.isFinishing()&& !activity.isDestroyed()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (activity != null && !activity.isFinishing()) {
                        Intent intent = new Intent();
                        intent.putExtra(activity.getString(R.string.payu_network_result), result);
                        activity.setResult(Activity.RESULT_CANCELED, intent);

                        if (null!=activity && !activity.isFinishing()&& !activity.isDestroyed())
                        activity.finish();
                    }
                }
            });
        }
    }


    /**
     * Just to make sure we finish activity even if the merchant's url got into trouble,
     * should be called from
     */
    private void callTimer() {
        countDownTimer = new CountDownTimer(100000, 1000) {

            public void onTick(long millisUntilFinished) {

            }

            public void onFinish() {
                if (activity != null && !activity.isFinishing()) {
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            if (activity != null && !activity.isFinishing()) {

                                onMerchantUrlFinished();

                            }
                        }
                    });
                }
            }
        }.start();
    }


    /**
     * This function takes care of sending the data back to calling activity with the status, merchantResponse, payuresponse.
     */

    private void onMerchantUrlFinished() {
        if (null != countDownTimer)
            countDownTimer.cancel();

        if (activity != null && !activity.isFinishing()) {

            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (activity != null && !activity.isFinishing() && !activity.isDestroyed()) {

                        if (isSuccessTransaction) {
                            if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                            GPayData.SINGLETON.getPayUGPayCallback().onPaymentSuccess(payuReponse,merchantResponse);

                        } else {
                            if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                            GPayData.SINGLETON.getPayUGPayCallback().onPaymentFailure(payuReponse,merchantResponse);

                        }
                        // }
                        if (null!=activity && !activity.isFinishing()&& !activity.isDestroyed())
                        activity.finish();
                    }
                }
            });
        }
    }
}
