package com.payu.gpay;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient;
import com.google.android.apps.nbu.paisa.inapp.client.api.Wallet;
import com.google.android.apps.nbu.paisa.inapp.client.api.WalletConstants;
import com.google.android.apps.nbu.paisa.inapp.client.api.WalletUtils;
import com.payu.gpay.callbacks.PayUGPayCallback;
import com.payu.gpay.intent.GPayIntentAndVerifyHandler;
import com.payu.gpay.intent.GPayWebInterface;
import com.payu.gpay.utils.GPayConstants;
import com.payu.gpay.utils.GPayData;
import com.payu.gpay.utils.GPayUtil;
import com.payu.gpay.utils.L;
import com.payu.payuanalytics.analytics.PayUAnalytics;
import com.payu.socketverification.interfaces.PayUSocketEventListener;
import com.payu.socketverification.socket.SocketHandler;
import com.payu.socketverification.socket.SocketPaymentResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

import static com.payu.gpay.utils.GPayConstants.API_VERSION;
import static com.payu.gpay.utils.GPayConstants.CARD;
import static com.payu.gpay.utils.GPayConstants.UPI;

/**
 * @author shahbaz.ahmmod
 * A transparent activity for Intent flow, opaque for Collect flow.
 * 1.Getting the type of payment from the Intent call, Intent, Embedded or Collect(Web)
 * 1. Intent : Normal intent call, 2. Embedded :Gpay loadpayment method.
 * 3. Collect : Load Webview and listen the javascriptinterface{@link GPayWebInterface}
 * Verifying the verification after the transaction using socket or http call.
 */
public class GPayResponseActivity extends Activity implements PayUSocketEventListener {
    private PaymentsClient paymentsClient;
    private final int REQUEST_CODE = 101;

    private GPayIntentAndVerifyHandler mGPayIntentAndVerifyHandler;
    private PayUAnalytics analytics;
    private String postData, merchantKey;
    private WebView mCollectWebView;
    private PaymentResponse paymentResponse;
    private SocketPaymentResponse socketPaymentResponseVSocketVerification;
    private com.payu.socketverification.widgets.PayUProgressDialog progressDialog;
    private static WeakReference<GPayResponseActivity> activityWeakReference;
    private boolean isWebOpened;
    private String txnId;
    private String paymentWay;
    private int isUpiSupportedInAppFlow, isCardSupportedInAppFlow;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        makeNormalScreenForCollectFlowElseTransparent();
        setContentView(R.layout.activity_tez_response);
        mCollectWebView = findViewById(R.id.wvCollect);
        this.analytics = PayUAnalytics.getInstance(getApplicationContext(), "local_cache_analytics");

        if (null != getIntent()) {

            if (null != getIntent() && null != getIntent().getExtras()) {
                Bundle bundle = getIntent().getExtras();
                postData = bundle.getString(GPayConstants.POST_DATA);
                txnId = GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID);
                creatingGpayIntentHandlerObject(postData);
                merchantKey = bundle.getString(GPayConstants.MERCHANT_KEY_);
                if (null != bundle.get(GPayConstants._PAYMENT_RESPONSE)) {

                    try {
                        JSONObject jsonObject = new JSONObject(bundle.getString(GPayConstants._PAYMENT_RESPONSE));
                        paymentResponse = createPaymentResponseObject(jsonObject);
                    } catch (JSONException e) {

                        if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                        GPayData.SINGLETON.getPayUGPayCallback().onGpayErrorReceived(GPayConstants.LOAD_TEZ_PAYMENT_DATA_REQUEST_CODE, GPayConstants.GPAY_INPUT_DATA_MISSING);

                        e.printStackTrace();
                    }
                }

                 if ((null != bundle.get(GPayConstants.PAYMENT_WAY) && (null!=paymentResponse))
                         ||(null != bundle.getString(GPayConstants.PAYMENT_WAY) && GPayConstants.GPAY_COLLECT_.equalsIgnoreCase(bundle.getString(GPayConstants.PAYMENT_WAY)))){
                    paymentWay = bundle.getString(GPayConstants.PAYMENT_WAY);
                    L.v("Payment Way final " + paymentWay);
                    switch (paymentWay) {
                        case (GPayConstants.GPAY_EMBEDDED):
                            isCardSupportedInAppFlow = bundle.getInt(GPayConstants.IS_CARD_INAPP_FLOW);
                            isUpiSupportedInAppFlow = bundle.getInt(GPayConstants.IS_UPI_INAPP_FLOW);
                            GPayData.SINGLETON.setCurrentPaymentType(GpayPaymentType.IN_APP);
                            embeddedFlow(bundle);
                            break;
                        case (GPayConstants.GPAY_INTENT_):
                            GPayData.SINGLETON.setCurrentPaymentType(GpayPaymentType.INTENT);
                            intentFlow(bundle);
                            break;
                        case (GPayConstants.GPAY_COLLECT_):
                            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.KITKAT) {
                                L.w(getString(R.string.payu_gpay_please_enable_gms_provider));
                            }
                            collectFlow();

                            break;
                    }
                }
            }
        }
    }

    /**
     * Web flow, load a webview to show the web gpay page.
     */
    private void collectFlow() {
        activityWeakReference = new WeakReference<>(this);
        L.v("oncreate class name:" + getClass().getCanonicalName());
        setCollectWebViewSettings();
        GPayUtil.showProgressDialog(activityWeakReference.get(),GPayData.SINGLETON.getPayUCustomDialogView());
        L.v("Postdata:-------------> " + postData);

        analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.PAYMENT_OPTION, GPayConstants.GPAY_COLLECT, merchantKey, txnId));

        postUrlWebView(GPayData.SINGLETON.getPostUrl(), postData);
    }

    /**
     * Pure Intent flow,  Get the response in onActivityResult()
     *
     * @param bundle
     */
    private void intentFlow(Bundle bundle) {
        isWebOpened = false;
        if (bundle.get(GPayConstants._PAYMENT_RESPONSE) != null) {
            if (postData != null) {
                analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.PAYMENT_OPTION, GPayConstants.GPAY_INTENT, merchantKey, txnId));
                mGPayIntentAndVerifyHandler.makeIntentPayment(getIntent().getExtras().getString(GPayConstants._PAYMENT_RESPONSE),
                        postData, this);
            }
        }
    }

    /**
     * Embedded/ In-app flow using loadPaymentData. Get the response in onActivityResult()
     *
     * @param bundle
     */
    private void embeddedFlow(Bundle bundle) {
        isWebOpened = false;
        analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.PAYMENT_OPTION, GPayConstants.GPAY_INAPP, merchantKey, txnId));

        String response = getLoadDataRequest();
        L.v("Response GPay Embedded flow" + response);
        try {
            paymentsClient = Wallet.getPaymentsClient();
            paymentsClient.loadPaymentData(this, response, REQUEST_CODE);
        } catch (NoSuchAlgorithmException e) {
            analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.PAYMENT_OPTION, GPayConstants.EMBED_FAIL_INTENT_FALLBACK, merchantKey, GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID)));

            intentFlow(bundle);
        }
    }

/*    *//**
     * @param bundle
     *//*
    private void cardFlow(Bundle bundle) {
        isWebOpened = false;
        analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.PAYMENT_OPTION, GPayConstants.GPAY_CARDS, merchantKey, txnId));
        String response = getLoadDataRequest();
        L.v("Response GPay card flow" + response);
        try {
            paymentsClient = Wallet.getPaymentsClient();
            paymentsClient.loadPaymentData(this, response, REQUEST_CODE);
        } catch (NoSuchAlgorithmException e) {
            analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.PAYMENT_OPTION, GPayConstants.EMBED_FAIL_INTENT_FALLBACK, merchantKey, GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID)));

            intentFlow(bundle);
        }
    }*/

    /**
     * Creating Json object to send to over the loadPayment method of embedded flow
     *
     * @return JsonObject String using as a request to Gpay payment.
     */
    private String getLoadDataRequest() {
        return String.valueOf(getJSONObjectForGpayRequest(paymentResponse));
    }

    /**
     * @param jsonObject
     * @return
     */
    private PaymentResponse createPaymentResponseObject(JSONObject jsonObject) {
        L.v("Json  " + jsonObject);
        if (TextUtils.isEmpty(jsonObject.optString(GPayConstants.MERCHANT_NAME)) || TextUtils.isEmpty(jsonObject.optString(GPayConstants.RETURN_URL)) || TextUtils.isEmpty(jsonObject.optString(GPayConstants.MERCHANT_VPA)) || TextUtils.isEmpty(jsonObject.optString(GPayConstants.REFERENCE_ID)))
            return null;
        PaymentResponse paymentResponse = new PaymentResponse();
        paymentResponse.setMerchantName(jsonObject.optString(GPayConstants.MERCHANT_NAME));
//        paymentResponse.setMerchantName("yulu bikes pvt. ltd.");
        paymentResponse.setMerchantVpa(jsonObject.optString(GPayConstants.MERCHANT_VPA));
//        paymentResponse.setMerchantVpa("yulu.bike.payu@hdfcbank");
        paymentResponse.setReferenceId(jsonObject.optString(GPayConstants.REFERENCE_ID));
        paymentResponse.setReturnUrl(jsonObject.optString(GPayConstants.RETURN_URL));
        paymentResponse.setAmount(jsonObject.optString(GPayConstants.AMOUNT));
//        paymentResponse.setToken(jsonObject.optString(GPayConstants.TOKEN));
        paymentResponse.setTxnId(GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID));
        paymentResponse.setVpaRegex(jsonObject.optString(GPayConstants.VPA_REGEX));
        paymentResponse.setMcc(jsonObject.optString(GPayConstants.MCC));
//        paymentResponse.setMcc("5399");
        paymentResponse.setCardSupported(jsonObject.optBoolean(GPayConstants.CARD_SUPPORTED));
//        Toast.makeText(this,"Card Supported Flag "+paymentResponse.getCardSupported() ,Toast.LENGTH_LONG).show();
        paymentResponse.setAllowedCardNetworks(jsonObject.optString(GPayConstants.ALLOWED_CARD_NETWORKS));

        SocketPaymentResponse socketParams = new SocketPaymentResponse();
        socketParams.setUpiPushDisabled(jsonObject.optString(GPayConstants.UPI_PUSH_DISABLED));
        socketParams.setPushServiceUrl(jsonObject.optString(GPayConstants.PUSH_SERVICE_URL));
        socketParams.setUpiServicePollInterval(jsonObject.optString(GPayConstants.UPI_SERVICE_POLL_INTERVAL));
        socketParams.setSdkUpiPushExpiry(jsonObject.optString(GPayConstants.SDK_UPI_PUSH_EXPIRY));
        socketParams.setSdkUpiVerificationInterval(jsonObject.optString(GPayConstants.SDK_UPI_VERIFICATION_INTERVAL));
        paymentResponse.setSocketParams(socketParams);
        return paymentResponse;
    }

    /**
     * Creating JSONObject for Gpay payment Request.
     *
     * @param paymentResponse
     * @return
     */
    private JSONObject getJSONObjectForGpayRequest(PaymentResponse paymentResponse) {
        JSONObject loadDataJsonRequest = new JSONObject();
        if (paymentResponse != null) {
            try {
                JSONArray allowedPaymentMethods = new JSONArray();


                L.v("Current FLow " + GPayData.SINGLETON.getCurrentPaymentType());
                if (isUpiSupportedInAppFlow == GPayConstants.SUPPORTED) {
                    allowedPaymentMethods.put(createAllowedPaymentOptionJsonObject(UPI));
                }
                if (isCardSupportedInAppFlow == GPayConstants.SUPPORTED) {
                    if (GPayUtil.isCardSupported(paymentResponse))
                        allowedPaymentMethods.put(createAllowedPaymentOptionJsonObject(CARD));
                }
                JSONObject transactionInfoJson = new JSONObject();
                transactionInfoJson.put(GPayConstants.TOTAL_PRICE_STATUS, GPayConstants.FINAL);
                transactionInfoJson.put(GPayConstants.TOTAL_PRICE, paymentResponse.getAmount());
                transactionInfoJson.put(GPayConstants.CURRENT_CODE, GPayConstants.INR);
                transactionInfoJson.put(GPayConstants.TRANSACTION_NOTE, GPayConstants.NOTE);
                loadDataJsonRequest.put(API_VERSION, GPayConstants.API_VERSION_VALUE);
                loadDataJsonRequest.put(GPayConstants.API_VERSION_MINOR, GPayConstants.API_VERSION_MINOR_VALUE);

                loadDataJsonRequest.put(GPayConstants.ALLOWED_PAYMENT_METHODS, allowedPaymentMethods);
                loadDataJsonRequest.put(GPayConstants.TRANSACTION_INFO, transactionInfoJson);
            } catch (JSONException e) {
                if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                    GPayData.SINGLETON.getPayUGPayCallback().onGpayErrorReceived(GPayConstants.LOAD_TEZ_PAYMENT_DATA_REQUEST_CODE, "Please check input data.");

                e.printStackTrace();
            }
        } else {
            GPayData.SINGLETON.getPayUGPayCallback().onGpayErrorReceived(GPayConstants.LOAD_TEZ_PAYMENT_DATA_REQUEST_CODE, "Payment Response Getting Null...");
            finish();
        }
        return loadDataJsonRequest;
    }

    /**
     *
     * @param paymentType
     * @return
     */
    private JSONObject createAllowedPaymentOptionJsonObject(String paymentType) {
        JSONObject allowedPaymentMethodsJsonObject = new JSONObject();
        try {
            allowedPaymentMethodsJsonObject.put(GPayConstants.TYPE, paymentType);
            JSONObject parametersJSObject = new JSONObject();
            JSONObject tokenizationSpecificationJson = new JSONObject();

            if (paymentType.equals(UPI)) {
                tokenizationSpecificationJson.put(GPayConstants.TYPE, GPayConstants.DIRECT);
                parametersJSObject.put(GPayConstants.PAYEE_VPA, paymentResponse.getMerchantVpa());
                parametersJSObject.put(GPayConstants.PAYEE_NAME, paymentResponse.getMerchantName());
                parametersJSObject.put(GPayConstants.REFERENCE_URL, paymentResponse.getReturnUrl());
                parametersJSObject.put(GPayConstants.MCC, paymentResponse.getMcc());
                parametersJSObject.put(GPayConstants.TRANSACTION_REFERENCE_ID, paymentResponse.getReferenceId());
                parametersJSObject.put(GPayConstants.TRANSACTION_ID, txnId);

            } else if (paymentType.equals(CARD)) {
                tokenizationSpecificationJson.put(GPayConstants.TYPE, GPayConstants.PAYMENT_GATEWAY);
                JSONObject jsonObjectParameterTokenization = new JSONObject();
                jsonObjectParameterTokenization.put(GPayConstants.GATEWAY, GPayConstants.PAYUINDIA);
                jsonObjectParameterTokenization.put(GPayConstants.GATEWAY_MERCHANT_ID, merchantKey);
                jsonObjectParameterTokenization.put(GPayConstants.GATEWAY_TRANSACTION_ID, paymentResponse.getReferenceId());
                tokenizationSpecificationJson.put(GPayConstants.PARAMETERS, jsonObjectParameterTokenization);
                JSONArray allowedCardNetworksJsonArray = new JSONArray();
                ArrayList allowedCardsList = GPayUtil.convertCommaSeparatedStringToArrayList(paymentResponse.getAllowedCardNetworks());
                 if (allowedCardsList.contains(GPayConstants.CC)) {
                     allowedCardNetworksJsonArray.put(GPayConstants.VISA);
                     allowedCardNetworksJsonArray.put(GPayConstants.MASTERCARD);
                 }
                 else {
                     for (int i= 0;i<allowedCardsList.size();i++){
                          if(allowedCardsList.get(i).equals(GPayConstants.MAST)){

                              allowedCardNetworksJsonArray.put(GPayConstants.MASTERCARD);
                          }
                          else {
                              allowedCardNetworksJsonArray.put(allowedCardsList.get(i));
                          }

                     }

                 }
                parametersJSObject.put("allowedCardNetworks", allowedCardNetworksJsonArray);

            }
            allowedPaymentMethodsJsonObject.put(GPayConstants.PARAMETERS, parametersJSObject);
            allowedPaymentMethodsJsonObject.put(GPayConstants.TOKENIZATION_SPECIFICATION, tokenizationSpecificationJson);
            return allowedPaymentMethodsJsonObject;
        } catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     *
     */
    private void creatingGpayIntentHandlerObject(String postData) {
        mGPayIntentAndVerifyHandler = new GPayIntentAndVerifyHandler(this, postData);
    }

    /**
     * Making Activity Opaque in case of Collect flow to show the WebView.
     */
    private void makeNormalScreenForCollectFlowElseTransparent() {
        if (getIntent() != null && getIntent().getExtras() != null && getIntent().getExtras().get(GPayConstants.PAYMENT_WAY) != null) {
            if (getIntent().getExtras().getString(GPayConstants.PAYMENT_WAY).equals(GPayConstants.GPAY_COLLECT_)) {
                setTheme(R.style.gpay_opaque_screen);
            }

        }
    }

    /**
     * loading postData to webview.
     *
     * @param url
     * @param postData
     */
    private void postUrlWebView(String url, String postData) {
        if (mCollectWebView != null) {
            isWebOpened = true;
            mCollectWebView.setVisibility(View.VISIBLE);
            mCollectWebView.postUrl(url, postData.getBytes());
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == REQUEST_CODE) {

            //Embedded Response
            if (GPayData.SINGLETON.getCurrentPaymentType() == GpayPaymentType.IN_APP) {
                switch (resultCode) {
                    case RESULT_OK:
                        String paymentData = WalletUtils.getPaymentDataFromIntent(data);
                        L.v("Payment Data " + paymentData);
                        try {
                            JSONObject jsonObject = new JSONObject(paymentData);
                            String type = jsonObject.optJSONObject(GPayConstants.PAYMENT_METHOD_DATA).getString(GPayConstants.TYPE);
                            String token = jsonObject.optJSONObject(GPayConstants.PAYMENT_METHOD_DATA).optJSONObject(GPayConstants.TOKENIZATION_DATA).optString(GPayConstants.TOKEN);
                            JSONObject tokenjson = new JSONObject(token);
                            JSONObject signedJsonObject = new JSONObject(tokenjson.optString(GPayConstants.SIGNED_MESSAGE));
                            L.v("Status>>>>> " + signedJsonObject.optJSONObject(GPayConstants.PAYMENT_METHOD_DETAILS).optString(GPayConstants.STATUS_));

                            if (type.equalsIgnoreCase(UPI)){
                               analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TEZ + GPayConstants.PAYMENT_APP_RESPONSE, paymentData, merchantKey, txnId));
                              makeDecisionForSocketAndHttp(signedJsonObject.optJSONObject(GPayConstants.PAYMENT_METHOD_DETAILS).optString(GPayConstants.STATUS_), type);
                          }
                          else{
                              mGPayIntentAndVerifyHandler.verifyPayment(signedJsonObject.optJSONObject(GPayConstants.PAYMENT_METHOD_DETAILS).optString(GPayConstants.STATUS_), null, this,paymentResponse,type);
                          }
                        } catch (JSONException e) {
                            if (GPayData.SINGLETON.getPayUGPayCallback()!=null){
                                GPayData.SINGLETON.getPayUGPayCallback().onGpayErrorReceived(GPayConstants.PAYMENT_API_ERROR_CODE,GPayConstants.GETTING_INCORRECT_RESPONSE_FROM_GOOGLE);
                            }
                            e.printStackTrace();
                        }

                        break;

                    case RESULT_FIRST_USER:
                        Bundle bundle = data.getExtras();
                        if (bundle != null) {
                            for (String key : bundle.keySet()) {
                                Log.v("PAYU", key + " : " + (bundle.get(key) != null ? bundle.get(key) : "NULL"));
                            }
                        }
                        int statusCode = data.getIntExtra(WalletConstants.EXTRA_ERROR_CODE, WalletConstants.INTERNAL_ERROR);;
                        analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TEZ + GPayConstants.PAYMENT_APP_RESPONSE, GPayConstants.FAILURE, merchantKey, txnId));
                        mGPayIntentAndVerifyHandler.verifyPayment(GPayConstants.FAIL, handleResultStatusCode(statusCode),this, paymentResponse,null);
                        break;

                    case RESULT_CANCELED:
                        L.v("Payment Data Cancelled <> ");
                        analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TEZ + GPayConstants.PAYMENT_APP_RESPONSE, GPayConstants.CANCEL, merchantKey, txnId));
                        mGPayIntentAndVerifyHandler.verifyPayment(GPayConstants.CANCEL, GPayConstants.CANCELLED,this, paymentResponse,null);

                        break;
                }

            }
        } else if (requestCode == GPayConstants.PAYMENT_REQUEST_CODE) {
            //Intent Response
            if (resultCode == RESULT_OK && data != null) {
                String status = data.getStringExtra(GPayConstants.STATUS);
                if (GPayConstants.SUCCESS.equalsIgnoreCase(status)) {
                    analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TEZ + GPayConstants.PAYMENT_APP_RESPONSE, GPayConstants.SUCCESS, merchantKey, txnId));
                    makeDecisionForSocketAndHttp(GPayConstants.SUCCESS, GPayConstants.INTENT);
                    L.v("Is UpiDisabled ... " + paymentResponse.getSocketParams().getUpiPushDisabled());
                    L.v("Success return");
                } else {
                    L.v("Failure return");

                    analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TEZ + GPayConstants.PAYMENT_APP_RESPONSE, GPayConstants.FAILURE, merchantKey, txnId));
                    makeDecisionForSocketAndHttp(GPayConstants.FAILURE,GPayConstants.INTENT);
                }
            } else {
                L.v("Cancel return");
                analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TEZ + GPayConstants.PAYMENT_APP_RESPONSE, GPayConstants.CANCEL, merchantKey, txnId));
                mGPayIntentAndVerifyHandler.verifyPayment(GPayConstants.CANCEL, GPayConstants.CANCELLED, this, paymentResponse,null);

            }
        }


    }

    /**
     * Making Socket connection to verify the payment transaction.
     */
    private void makeSocketConnection() {
        analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.VERIFY_TYPE, GPayConstants.SOCKET, merchantKey, txnId));
        socketPaymentResponseVSocketVerification = new SocketPaymentResponse();
        createSocketVerificationInstances();
        com.payu.socketverification.socket.SocketHandler.getInstance().createSocket(socketPaymentResponseVSocketVerification, this,this);
    }

    /**
     * Making decision whether we need to verify using http or socket connection using upiPushDisabled value. It's "0" or "1"
     *
     * @param verifyHttpStatus
     */
    private void makeDecisionForSocketAndHttp(String verifyHttpStatus, String paymentType) {

        if (paymentResponse.getSocketParams().getUpiPushDisabled() != null && paymentResponse.getSocketParams().getUpiPushDisabled().equals("0")) {
            analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.UPI_SOCKET, GPayConstants.PUSH_ENABLED, merchantKey, txnId));
            //upiPushDisabled = 0 means, upi push is enabled so create socket connection.
            makeSocketConnection();
        } else {
            analytics.log(GPayUtil.getLogMessage(this.getApplicationContext(), GPayConstants.LONG_POLLING_FROM, GPayConstants.VERIFY_USING_HTTP, merchantKey, txnId));
            mGPayIntentAndVerifyHandler.verifyPayment(verifyHttpStatus, null, this, paymentResponse,paymentType);
        }


    }

    /**
     * Create data class for core library socket connection.
     */
    private void createSocketVerificationInstances() {
        socketPaymentResponseVSocketVerification.setReferenceId(paymentResponse.getReferenceId());
        socketPaymentResponseVSocketVerification.setTxnId(txnId);
        socketPaymentResponseVSocketVerification.setUpiPushDisabled(paymentResponse.getSocketParams().getUpiPushDisabled());
        socketPaymentResponseVSocketVerification.setUpiServicePollInterval(paymentResponse.getSocketParams().getUpiServicePollInterval());
        socketPaymentResponseVSocketVerification.setSdkUpiPushExpiry(paymentResponse.getSocketParams().getSdkUpiPushExpiry());
        socketPaymentResponseVSocketVerification.setSdkUpiVerificationInterval(paymentResponse.getSocketParams().getSdkUpiVerificationInterval());
        socketPaymentResponseVSocketVerification.setPushServiceUrl(paymentResponse.getSocketParams().getPushServiceUrl());
    }

    @Override
    public void getSocketResult(String merchantResponse, String payuResponse, String resultType, boolean isLongPooling) {
        if (resultType.equals(GPayConstants.SUCCESS)) {
            analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TRXN_STATUS, GPayConstants.SUCCESS_TRANSACTION, merchantKey, txnId));

            if (null!=GPayData.SINGLETON.getPayUGPayCallback())
            GPayData.SINGLETON.getPayUGPayCallback().onPaymentSuccess(payuResponse,null);
        } else {
            analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TRXN_STATUS, GPayConstants.FAILURE_TRANSACTION, merchantKey, txnId));
            if (null!=GPayData.SINGLETON.getPayUGPayCallback())
            GPayData.SINGLETON.getPayUGPayCallback().onPaymentFailure(payuResponse,null);
        }
        if(null!=this && !this.isFinishing() && !this.isDestroyed())
            finish();
    }

    @Override
    public void errorReceived(int issueCode, String errorMessage) {
        L.v("Error Received " + errorMessage);
        if (issueCode==GPayConstants.SOCKET_NOT_CONNECTED){
            //TODO: Need to change transactionStatus dn errorStatus
            mGPayIntentAndVerifyHandler.verifyPayment(GPayConstants.CANCEL, GPayConstants.CANCELLED, this, paymentResponse,null);
        }
        else {
            if (null!=GPayData.SINGLETON.getPayUGPayCallback())
            GPayData.SINGLETON.getPayUGPayCallback().onPaymentFailure(errorMessage, null);

        } }

    @Override
    public void transactionCancelled() {
        mGPayIntentAndVerifyHandler.verifyPayment(GPayConstants.CANCEL, null, this, paymentResponse,null);
    }

    @Override
    public void onSocketCreated() {
        SocketHandler.getInstance().startSocketEvents(merchantKey, txnId, this, GPayData.SINGLETON.getPayUCustomDialogView());

    }


    /**
     * Posting event to analytics logs.
     *
     * @param statusCode
     */
   String  handleResultStatusCode(int statusCode) {
        String failureReason;
        switch (statusCode) {
            case WalletConstants.DEVELOPER_ERROR:
                failureReason = "developer_error";
                break;
            case WalletConstants.ERROR_CODE_UNSUPPORTED_API_VERSION:
                failureReason = "unsupported_api_version";
                break;
            case WalletConstants.ERROR_CODE_MERCHANT_ACCOUNT_ERROR:
                failureReason = "unsupported_api_version";
                break;
            case WalletConstants.ERROR_CODE_BUYER_ACCOUNT_ERROR:
                failureReason = "buyer_account_error";
                break;
            default:
                failureReason = "internal_error";
                break;
        }
        analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TEZ + GPayConstants.PAYMENT_APP_RESPONSE, failureReason, merchantKey, txnId));
  return failureReason;
    }


    /**
     * setting for webview collect. Javascript interface enabling.
     * {@link GPayWebInterface} to handle @javascriptinterface methods
     */
    private void setCollectWebViewSettings() {
        if (mCollectWebView != null) {
            mCollectWebView.getSettings().setJavaScriptEnabled(true);
            mCollectWebView.addJavascriptInterface(new GPayWebInterface(this, analytics), "PayU");
            mCollectWebView.setVisibility(View.GONE);
            mCollectWebView.setWebViewClient(new WebViewClient() {
                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    if (null!= activityWeakReference)
                    GPayUtil.hideProgressDialog(activityWeakReference.get());
                }
            });
        }
    }
    /**
     * Creating confirmation dialog.
     */
    private void confirmationDialog() {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                if (i == -1) {
                    if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                    GPayData.SINGLETON.getPayUGPayCallback().onBackApprove();
                    analytics.log(GPayUtil.getLogMessage(getApplicationContext(), GPayConstants.TEZ + GPayConstants.PAYMENT_APP_RESPONSE, GPayConstants.CANCEL_BACK_BUTTON, merchantKey, txnId));
                    if (null!=activityWeakReference &&null!= activityWeakReference.get()&& !activityWeakReference.get().isFinishing() && !activityWeakReference.get().isDestroyed())

                        activityWeakReference.get().finish();
                } else if (i == -2) {
                    dialogInterface.dismiss();
                    if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                    GPayData.SINGLETON.getPayUGPayCallback().onBackDismiss();
                }
            }
        };
        AlertDialog.Builder builder = GPayUtil.getAlertDialog(this, onClickListener, getString(R.string.payu_gpay_ok), getString(R.string.payu_gpay_cancel), null, getString(R.string.payu_gpay_do_you_really_want_to_cancel_the_transaction));
        if (null!=GPayData.SINGLETON.getPayUGPayCallback()) {
            GPayData.SINGLETON.getPayUGPayCallback().onBackButton(builder);
            builder.create().show();
        }
    }

    @Override
    public void onBackPressed() {
        //   super.onBackPressed();
        if (isWebOpened) {
            confirmationDialog();
        } else {
            if (null!=GPayData.SINGLETON.getPayUGPayCallback()) {
                GPayData.SINGLETON.getPayUGPayCallback().onPaymentFailure(null, null);

                if(null!=this && !this.isFinishing() && !this.isDestroyed())
                finish();
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        L.v("Gpay Activity Destroy");

        if (null !=GPayUtil.progressDialog){
            GPayUtil.progressDialog.dismiss();
        }
        GPayUtil.progressDialog =null;
        if (null!=GPayData.SINGLETON.getPayUGPayCallback())
            GPayData.SINGLETON.getPayUGPayCallback().onPaymentTerminate();

        if (null !=GPayUtil.progressDialog && GPayUtil.progressDialog.isShowing()){
            GPayUtil.progressDialog.dismiss();
        }
        GPayUtil.progressDialog =null;
        if (null!=GPayData.SINGLETON.getPayUGPayCallback());


    }
}
