package com.payu.gpay;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.view.View;

import com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient;
import com.google.android.apps.nbu.paisa.inapp.client.api.Wallet;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.payu.gpay.callbacks.PayUGPayCallback;
import com.payu.gpay.utils.GPayConstants;
import com.payu.gpay.utils.GPayData;
import com.payu.gpay.utils.GPayUtil;
import com.payu.gpay.utils.L;
import com.payu.payuanalytics.analytics.PayUAnalytics;
import com.payu.socketverification.bean.PayUNetworkAsyncTaskData;
import com.payu.socketverification.interfaces.PayuNetworkAsyncTaskInterface;
import com.payu.socketverification.core.PayUNetworkAsyncTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.security.NoSuchAlgorithmException;

/**
 * Processing input getting from the merchant and decision making to find the payment method.
 *
 */
public class GPayHandler implements PayuNetworkAsyncTaskInterface {
    private WeakReference<Activity> reference;
    private String merchantKey;
    private PaymentsClient paymentsClient;
    private boolean isEmbedded;
    private String postData;
    private PayUAnalytics payUAnalytics;
    private int isCardSupportedInAppFlow = GPayConstants.NOT_CALLED, isUpiSupportedInAppFlow = GPayConstants.NOT_CALLED;

    /**
     * @param activity
     * @param callback
     * @param paymentOptionHash
     * @param merchantKey
     * @param user_credentials
     */
    void checkForPaymentAvailability(Activity activity, PayUGPayCallback callback, String paymentOptionHash, String merchantKey, String user_credentials) {
        L.v("GPay checkForPaymentAvailability");
        if (callback == null)
            throw new IllegalStateException(GPayConstants.PAYU_GPAY_CALLBACK_CANNOT_BE_NULL);
        this.reference = new WeakReference<>(activity);
        this.merchantKey = merchantKey;
        if (null != reference && reference.get() != null && !reference.get().isDestroyed() && !reference.get().isDestroyed())
        GPayUtil.setMetaData(reference.get());

        GPayData.SINGLETON.setPayUGPayCallback(callback);
        PayUNetworkAsyncTaskData browserAsyncTaskData = new PayUNetworkAsyncTaskData();
        browserAsyncTaskData.setHttpMethod(GPayConstants.POST);

        browserAsyncTaskData.setUrl(GPayData.SINGLETON.getWebServiceUrl());
        browserAsyncTaskData.setPostData(getPaymentAvailabilityPostData(merchantKey, paymentOptionHash, user_credentials));
        new PayUNetworkAsyncTask(this, GPayConstants.CHECK_PAYMENT_OPTION).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, browserAsyncTaskData);

    }

    /**
     *
     * @param merchantKey
     * @param paymentOptionHash
     * @param user_credentials
     * @return
     */
    private String getPaymentAvailabilityPostData(String merchantKey, String paymentOptionHash, String user_credentials) {
        String postData = GPayConstants.COMMAND + GPayConstants.PAYMENT_RELATED_DETAILS_FOR_MOBILE_SDK +
                GPayConstants.KEY + merchantKey + GPayConstants.HASH + paymentOptionHash + GPayConstants.VAR1 + user_credentials;
        return postData;
    }


    /**
     * Creating payment.
     * Using from {@link GPayWrapper while making payment from Upi SDK or CB / Merchant application while making payment from
     * Standalone Gpay SDK.}
     *
     * @param activity
     * @param postData
     * @param payUGPayCallback
     */
    void makePayment(Activity activity, final String postData, final PayUGPayCallback payUGPayCallback, String merchantKey, View loadingDialogView) {

        if (payUGPayCallback == null)
            throw new IllegalStateException(GPayConstants.PAYU_GPAY_CALLBACK_CANNOT_BE_NULL);
        this.postData = postData;
        this.merchantKey = merchantKey;
        GPayData.SINGLETON.setPayUGPayCallback(payUGPayCallback);
        GPayData.SINGLETON.setPayUCustomDialogView(loadingDialogView);
        reference = new WeakReference<>(activity);
        if (null!= reference && null != reference.get())
        GPayUtil.setMetaData(reference.get());
        this.payUAnalytics = PayUAnalytics.getInstance(activity.getApplicationContext(),"local_cache_analytics");
        /**
         * If tez app is installed, we go with the Intent flow else collect flow.
         * If installed -> Call isReadyToPay method of Gpay SDK to find out the intent flow -> {Pure intent or In-App}
         */
        if (null != reference && null!= reference.get() && !reference.get().isFinishing()&& !reference.get().isDestroyed()) {

            if (GPayUtil.isTezAppInstalled(reference.get())) {
                paymentsClient = Wallet.getPaymentsClient();
                L.v("Request JSON:Card  " + getPaymentRequestObject(GPayConstants.CARD));
                L.v("Request JSON:UPI  " + getPaymentRequestObject(GPayConstants.UPI));
                L.v("reference Object:  " + reference.get());
                L.v("Merchant Key:::::: :  " + merchantKey);
                switch (GPayData.SINGLETON.getPaymentTypeForMerchant()) {
                    case UPI_ONLY:
                        isReadyToPay(GPayConstants.UPI);
                        break;

                    case CARDS_ONLY:
                        isReadyToPay(GPayConstants.CARD);
                        break;

                    case CARDS_UPI_BOTH:
                        isReadyToPay(GPayConstants.UPI);
                        isReadyToPay(GPayConstants.CARD);
                        break;
                }


            } else {
                // Initiate Collect flow.
                initiateCollectGpay(postData);
            }
        }
    }

    /**
     * @param type
     */
    private void isReadyToPay(final String type) {
        try {
            if (null != reference && reference.get() != null && !reference.get().isDestroyed() && !reference.get().isDestroyed()) {
                Task<Boolean> result = paymentsClient.isReadyToPay(reference.get(), getPaymentRequestObject(type));
                result.addOnCompleteListener(new OnCompleteListener<Boolean>() {
                    @Override
                    public void onComplete(@NonNull Task<Boolean> task) {
                        isEmbedded = task.getResult();
                        //isEmbedded = false;
                        L.v("Is Ready:::> type " + type + "  >> " + isEmbedded);


                        if (type.equals(GPayConstants.UPI)) {
                            if (isEmbedded) {
                                isUpiSupportedInAppFlow = GPayConstants.SUPPORTED;
                            } else {
                                isUpiSupportedInAppFlow = GPayConstants.UNSUPPORTED;
                            }

                        } else {
                            if (isEmbedded) {
                                isCardSupportedInAppFlow = GPayConstants.SUPPORTED;

                            } else {
                                isCardSupportedInAppFlow = GPayConstants.UNSUPPORTED;
                            }
                        }
                        doPaymentServerCall();

                    }
                });
            }
        } catch (NoSuchAlgorithmException e) {
            //Going for Intent as GPay is installed and embed is failed
            runFallback();
         }
    }

    /**
     * First check the onboarding of Gpay Application.
     * if true then payment through Intent Upi
     * else collect flow.
     */
    private void runFallback(){
        if (isUserOnBoardedOnGpayForUpi()) {
            if (null!=reference && reference.get() != null && !reference.get().isDestroyed() && !reference.get().isDestroyed()) {
                payUAnalytics.log(GPayUtil.getLogMessage(reference.get(), GPayConstants.PAYMENT_OPTION, GPayConstants.EMBED_FAIL_INTENT_FALLBACK, merchantKey, GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID)));
            }
           if (null!= GPayData.SINGLETON.getPayUGPayCallback())
            makePayment(postData,  GpayPaymentType.INTENT, GPayData.SINGLETON.getPayUGPayCallback());
        } else {
            if (null!=reference && reference.get() != null && !reference.get().isDestroyed() && !reference.get().isDestroyed()) {
                payUAnalytics.log(GPayUtil.getLogMessage(reference.get(), GPayConstants.PAYMENT_OPTION, GPayConstants.INTENT_FAIL_COLLECT_FALLBACK, merchantKey, GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID)));
                initiateCollectGpay(postData);
            }
        }
    }


private void doPaymentServerCall(){

        switch (GPayData.SINGLETON.getPaymentTypeForMerchant()){
            case CARDS_UPI_BOTH:
                if (isUpiSupportedInAppFlow != GPayConstants.NOT_CALLED && isCardSupportedInAppFlow != GPayConstants.NOT_CALLED) {

                if (isCardSupportedInAppFlow == GPayConstants.SUPPORTED) {
                    if(null!= GPayData.SINGLETON.getPayUGPayCallback()&& null!=postData)
                        makePayment(postData, GpayPaymentType.CARD, GPayData.SINGLETON.getPayUGPayCallback());

                } else if (isUpiSupportedInAppFlow == GPayConstants.SUPPORTED) {
                    if(null!= GPayData.SINGLETON.getPayUGPayCallback()&& null!=postData)
                        makePayment(postData, GpayPaymentType.IN_APP, GPayData.SINGLETON.getPayUGPayCallback());

                } else {
                    runFallback();
                }
            }

                break;

            case CARDS_ONLY:
                if (isCardSupportedInAppFlow != GPayConstants.NOT_CALLED) {

                    if (isCardSupportedInAppFlow == GPayConstants.SUPPORTED) {

                        if (null != GPayData.SINGLETON.getPayUGPayCallback() && null != postData)
                            makePayment(postData, GpayPaymentType.CARD, GPayData.SINGLETON.getPayUGPayCallback());

                    } else {
                        if (null != GPayData.SINGLETON.getPayUGPayCallback()){
                            GPayData.SINGLETON.getPayUGPayCallback().onGpayErrorReceived(GPayConstants.PAYMENT_API_ERROR_CODE,"Gpay can't initiate card payments. Please check cards on Gpay cards.");
                        }
                    }
                }
                break;

            case UPI_ONLY:
                if (isUpiSupportedInAppFlow != GPayConstants.NOT_CALLED) {
                    if (isUpiSupportedInAppFlow == GPayConstants.SUPPORTED) {
                        if (null != GPayData.SINGLETON.getPayUGPayCallback() && null != postData)
                            makePayment(postData, GpayPaymentType.IN_APP, GPayData.SINGLETON.getPayUGPayCallback());

                    } else {
                        runFallback();
                    }
                    break;
                }
        }


}
    /**
     *  Utility method to check if User has on-boarded on GPay app via Activity Resolution for UPI Intent
     * @return
     */
    private boolean isUserOnBoardedOnGpayForUpi(){
        if (null!=reference && reference.get() != null && !reference.get().isDestroyed() && !reference.get().isDestroyed()) {
                Intent intent = new Intent();
                intent.setAction(Intent.ACTION_VIEW);
                intent.setPackage(GPayConstants.GPAY_PACKAGE_NAME);
                intent.setData(Uri.parse(GPayConstants.UPI_INTENT_DATA));
                return reference.get().getPackageManager().resolveActivity(intent, PackageManager.MATCH_DEFAULT_ONLY) != null;

            }
            return false;
        }


    /**
     * Utility function to make GPay payment
     *
     * @param postData
     * @param gpayPaymentType
     * @param payUGPayCallback
     */
    private void makePayment(String postData, GpayPaymentType gpayPaymentType, PayUGPayCallback payUGPayCallback) {
        L.v("Version Cb " + GPay.cb_version_name);
        L.v("Version UPI Sdk " + GPay.upi_sdk_version);
        GPayData.SINGLETON.setPayUGPayCallback(payUGPayCallback);
        if (GPayData.SINGLETON.getPayUGPayCallback() == null) {
            throw new IllegalStateException(GPayConstants.PAYU_GPAY_CALLBACK_CANNOT_BE_NULL);
        }
        this.postData = postData;
        postData = postData.concat(GPayConstants.TXN_S2S_FLOW + 2).concat(GPayConstants.SDK_FLOW_TYPE + gpayPaymentType.getPaymentType());
        this.merchantKey = GPayUtil.getDataFromPostData(postData).get(GPayConstants.KEY_);
        if(null!=reference)
         GPayUtil.deviceAnalytics(merchantKey, reference, GPayUtil.getDataFromPostData(postData).get(GPayConstants.TXNID));
        PayUNetworkAsyncTaskData browserAsyncTaskData = new PayUNetworkAsyncTaskData();
        browserAsyncTaskData.setUrl(GPayData.SINGLETON.getPostUrl());
        browserAsyncTaskData.setPostData(postData);
        L.v("URL make payment " + GPayData.SINGLETON.getPostUrl());
        L.v("Request make payment " + postData);
        browserAsyncTaskData.setHttpMethod(GPayConstants.POST);
        if (null!=reference && reference.get() != null && !reference.get().isDestroyed() && !reference.get().isDestroyed())
            GPayUtil.showProgressDialog(reference.get(), GPayData.SINGLETON.getPayUCustomDialogView());
        new PayUNetworkAsyncTask(this, GPayConstants.MAKE_PAYMENT).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, browserAsyncTaskData);
    }


    /**
     * Initializing Collect flow
     *
     * @param postData as received from Merchant
     */
    private void initiateCollectGpay(String postData) {
        if (null!=reference && reference.get() != null && !reference.get().isFinishing() && !reference.get().isDestroyed()) {
            Intent intent = new Intent(reference.get(), GPayResponseActivity.class);
            if (postData != null) {
                intent.putExtra(GPayConstants.POST_DATA, postData);
                intent.putExtra(GPayConstants.MERCHANT_KEY_, merchantKey);
                intent.putExtra(GPayConstants.PAYMENT_WAY, GPayConstants.GPAY_COLLECT_);
            }

                reference.get().startActivity(intent);
        }
    }

    /**
     * Creating request to send Gpay API to check isReadyToPay.
     *
     * @return JSON Encoded PaymentRequest as needed by GPay SDK
     */
    public String getPaymentRequestObject(String paymentType) {
        try {
            if (paymentType != null && (paymentType.equals(GPayConstants.UPI) || paymentType.equals(GPayConstants.CARD))) {
                JSONObject requestObject = new JSONObject();
                requestObject.put(GPayConstants.API_VERSION, GPayConstants.API_VERSION_VALUE);
                requestObject.put(GPayConstants.API_VERSION_MINOR, GPayConstants.API_VERSION_MINOR_VALUE);
                JSONObject upiObject = new JSONObject();
                upiObject.put(GPayConstants.TYPE, paymentType);
                if (paymentType.equals(GPayConstants.CARD)) {
                    JSONObject parameters = new JSONObject();
                    JSONArray cardsArray = new JSONArray();
                    cardsArray.put(GPayConstants.VISA);
                    cardsArray.put(GPayConstants.MASTERCARD);
                    parameters.put(GPayConstants.ALLOWED_CARD_NETWORKS, cardsArray);
                    upiObject.put("parameters", parameters);
                }
                JSONArray jsonArray = new JSONArray();
                jsonArray.put(upiObject);
                requestObject.put(GPayConstants.ALLOWED_PAYMENT_METHODS, jsonArray);
                return requestObject.toString();
            } else {
                L.v("Payment type is not defined...");
            }
        } catch (JSONException e) {

        }
        return null;
    }

    @Override
    public void onPayuNetworkAsyncTaskResponse(String payUAsyncTaskResponse, String webServiceType) {
        switch (webServiceType) {
            case GPayConstants.CHECK_PAYMENT_OPTION:
                boolean result = GPayUtil.isGpayEnabledForMerchant(payUAsyncTaskResponse);
                L.v("Is Result " + result);
                if (result) {
                    if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                    GPayData.SINGLETON.getPayUGPayCallback().onPaymentInitialisationSuccess();
                } else {
                    if (null!=GPayData.SINGLETON.getPayUGPayCallback())
                    GPayData.SINGLETON.getPayUGPayCallback().onPaymentInitialisationFailure(GPayConstants.MERCHANT_KEY_NOT_REGISTER_FOR_TEZ_CODE, GPayConstants.GPAY_PAYMENT_NOT_ENABLED);
                }
                break;

            case GPayConstants.MAKE_PAYMENT:

                if (null != reference && reference.get() != null && !reference.get().isFinishing() && !reference.get().isDestroyed()) {
                    GPayUtil.hideProgressDialog(reference.get());
                    try {
                        L.v("Response gpay makepayment " + payUAsyncTaskResponse);
                        JSONObject jsonObject = new JSONObject(payUAsyncTaskResponse);
                        L.v("Post Data: " + postData);

                        Intent intent = new Intent(reference.get(), GPayResponseActivity.class);
                        if (intent != null && jsonObject != null && postData != null) {
                            intent.putExtra(GPayConstants._PAYMENT_RESPONSE, payUAsyncTaskResponse);
                            intent.putExtra(GPayConstants.POST_DATA, postData);
                            intent.putExtra(GPayConstants.MERCHANT_KEY_, merchantKey);
                            intent.putExtra(GPayConstants.IS_CARD_INAPP_FLOW, isCardSupportedInAppFlow);
                            intent.putExtra(GPayConstants.IS_UPI_INAPP_FLOW, isUpiSupportedInAppFlow);
                            if (isCardSupportedInAppFlow != GPayConstants.NOT_CALLED && isUpiSupportedInAppFlow != GPayConstants.NOT_CALLED) {
                                intent.putExtra(GPayConstants.PAYMENT_WAY, GPayConstants.GPAY_EMBEDDED);

                            } else {
                                intent.putExtra(GPayConstants.PAYMENT_WAY, GPayConstants.GPAY_INTENT_);
                            }

                            if (null != reference && reference.get() != null && !reference.get().isDestroyed() && !reference.get().isDestroyed()) {
                                String error = getErrorMessage(payUAsyncTaskResponse);
                                if (null == error) {
                                    L.v("Error >>>>> null. ");
                                    reference.get().startActivity(intent);
                                } else {
                                    L.v("Error >>>>>  " + error);
                                    if (GPayData.SINGLETON.getPayUGPayCallback() != null) {
                                        GPayData.SINGLETON.getPayUGPayCallback().onGpayErrorReceived(GPayConstants.PAYMENT_API_ERROR_CODE, error);
                                    }
                                }
                            }
                        } else {

                            GPayData.SINGLETON.getPayUGPayCallback().onGpayErrorReceived(GPayConstants.PAYMENT_API_ERROR_CODE, jsonObject.optString(GPayConstants.MESSAGE));

                        }


                    } catch (JSONException e) {
                        L.v("Exception " + e.getMessage());
                        if (null != GPayData.SINGLETON.getPayUGPayCallback())
                            GPayData.SINGLETON.getPayUGPayCallback().onGpayErrorReceived(GPayConstants.LOAD_TEZ_PAYMENT_DATA_REQUEST_CODE, "Please check input data.");

                    }
                }

                break;
        }
    }

    /**
     * Checking whether Error occured or not.
     * @param payUAsyncTaskResponse String response of _payment.
     * @return boolean.
     */
    public String getErrorMessage(String payUAsyncTaskResponse) {
        try {
            JSONObject payuResponseJson=null;
            if (null != payUAsyncTaskResponse) {
                 payuResponseJson = new JSONObject(payUAsyncTaskResponse);
                if ((payuResponseJson.optString(GPayConstants.RESULT).equalsIgnoreCase("") || payuResponseJson.optString(GPayConstants.RESULT).equalsIgnoreCase("null")) && payuResponseJson.has(GPayConstants.ERROR) && payuResponseJson.has(GPayConstants.MESSAGE)) {

                    return payuResponseJson.getString(GPayConstants.MESSAGE);
                }
                else {
                    if (payuResponseJson.getInt(GPayConstants.STATUS_)!=1){
                        return payuResponseJson.getString(GPayConstants.MSG);
                    }

                }
            } else {
                return GPayConstants.PAYMENT_RESPONSE_IS_NULL;

            }
        } catch (JSONException e) {
            e.printStackTrace();
            return GPayConstants.SOMETHING_WENT_WRONG_WHILE_FETCHING_DATA_FROM_PAYU;
        }
        return null;
    }
}
