// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.os.Message;
import androidx.annotation.NonNull;
import android.webkit.WebChromeClient;
import android.webkit.WebView;

/**
 * Created by amitkumar on 12/12/14.
 * Custom chrome client for payu.
 */
public class PayUWebChromeClient extends WebChromeClient {
    private Bank mBank;
    private boolean mPageDone = false;

    public PayUWebChromeClient(@NonNull Bank bank) {
        mBank = bank;
    }

    @Override
    public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        return false;
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        if (mBank != null) {
            if (!mPageDone && newProgress < 100) {
                mPageDone = true;
                mBank.onPageStarted();
            } else if (newProgress == 100) {
                mBank.onPageStarted();
                mPageDone = false;
                mBank.onPageFinished();
            }
            mBank.onProgressChanged(newProgress);
        }

    }
}
