package com.payu.custombrowser.util;

/**
 * Created by himanshu.gupta on 18/01/18.
 * <p>
 * Define PaymentOption to handle multiple PaymentOption via reflection
 * paymentName.
 */

public enum PaymentOption {
    SAMSUNGPAY("SAMPAY", "com.payu.samsungpay.SamsungWrapper","com.payu.upisdk","SAMSUNGPAY",false),
    PHONEPE("PPINTENT", "com.payu.phonepe.PhonePeWrapper","com.payu.upisdk","PHONEPE", false),
    UPI_INTENT("INTENT", "com.payu.upisdk.UpiWrapper","com.payu.upisdk","GENERIC_INTENT", true),
    UPI_INTENT_TPV("INTTPV", "com.payu.upisdk.UpiWrapper","com.payu.upisdk","GENERIC_INTENT_TPV", true),
    TEZ("TEZ", "com.payu.upisdk.UpiWrapper","com.payu.upisdk","TEZ", true),
    UPI_COLLECT("upi", "com.payu.upisdk.UpiWrapper","com.payu.upisdk","UPI_COLLECT", true);

    private String paymentName;
    private String packageName;
    private String className;
    private String analyticsKey;

    public boolean isDefault() {
        return isDefault;
    }

    public void setDefault(boolean aDefault) {
        isDefault = aDefault;
    }

    private boolean isDefault;
    public String getPackageName() {
        return packageName;
    }

    /**
     * @param paymentName BankCode for payment
     * @param packageName Gradle Package Name
     */
    PaymentOption(String paymentName,String className, String packageName,String analyticsKey, Boolean isDefault) {
        this.paymentName = paymentName;
        this.className = className;
        this.packageName = packageName;
        this.analyticsKey = analyticsKey;
        this.isDefault = isDefault;
    }

    public String getPaymentName() {
        return paymentName;
    }

    public String getClassName() {
        return className;
    }

    public String getAnalyticsKey() {
        return analyticsKey;
    }}

