package com.payu.custombrowser.widgets;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.payu.custombrowser.R;
import com.payu.custombrowser.util.CBUtil;

import java.util.Timer;
import java.util.TimerTask;


/**
 * Created by himanshu.gupta on 28/12/17.
 */

public class PayUProgressDialog extends Dialog {

    private TextView tvMessage;
    private Activity mActivity;
    Timer timerProgress = null;
    CBUtil cbUtil;
    private View layout = null;
    /**
     * Displaying Payuloader.
     *
     * @param context base activity context
     * @param view Custom Progress Dialog Layout if any
     */
    public PayUProgressDialog(Context context,View view) {
        super(context, R.style.cb_progress_dialog);
        this.mActivity = (Activity) context;
        LayoutInflater mInflater = LayoutInflater.from(context);
        if(null!=view ){
            layout = view;
            if(view.getParent()!=null){
                ViewGroup parent = (ViewGroup)view.getParent();
                parent.removeView(view);
            }
            setContentView(layout);
        }else {
            //Default PayU progress Dialog
            layout = mInflater.inflate(R.layout.cb_prog_dialog, null,false);
            setContentView(layout);
            tvMessage = (TextView) layout.findViewById(R.id.dialog_desc);
//            setPayUDialogSettings(context);
        }
        setCancelable(true);
        setCanceledOnTouchOutside(false);

    }

    /**
     * Returns drawable from resource id.
     *
     * @param context currentContext
     * @param resID   resourceId
     * @return drawable
     */
    private Drawable getCbDrawable(Context context, int resID) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(resID, context.getTheme());
        } else {
            return context.getResources().getDrawable(resID);
        }
    }

    /**
     * Init PayU Progress Dialog Default Loader Settings
     * @param context
     */
    public void setPayUDialogSettings(Context context){
        cbUtil = new CBUtil();
        final Drawable[] drawables =

                {getCbDrawable(context.getApplicationContext(), R.drawable.l_icon1),
                        getCbDrawable(context.getApplicationContext(), R.drawable.l_icon2),
                        getCbDrawable(context.getApplicationContext(), R.drawable.l_icon3),
                        getCbDrawable(context.getApplicationContext(), R.drawable.l_icon4)
                };

        final ImageView imageView = (ImageView) layout.findViewById(R.id.imageView);
        cbUtil.cancelTimer(timerProgress);

        timerProgress = new Timer();
        timerProgress.scheduleAtFixedRate(new TimerTask() {
            int i = -1;

            @Override
            synchronized public void run() {
                if (mActivity != null && !mActivity.isFinishing()) {
                    mActivity.runOnUiThread(new Runnable() {
                                                @Override
                                                public void run() {
                                                    if (mActivity != null) {
                                                        i++;
                                                        if (i >= drawables.length) {
                                                            i = 0;
                                                        }
                                                        imageView.setImageBitmap(null);
                                                        imageView.destroyDrawingCache();
                                                        imageView.refreshDrawableState();
                                                        imageView.setImageDrawable(drawables[i]);
                                                    }
                                                }
                                            }
                    );
                }

            }
        }, 0, 500);
        setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                cbUtil.cancelTimer(timerProgress);
            }
        });
    }
    public void setText(String text) {
        tvMessage.setText(text);
    }
}
