package com.payu.custombrowser.upiintent;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;

import java.util.regex.Pattern;

/**
 * Created by himanshu.gupta on 18/01/18.
 */

public class UPIUtil {
    public boolean isPaymentMethodSupported(Context context, Payment payment) {
        switch (payment) {
            case TEZ:
                if (Build.VERSION.SDK_INT >= payment.getMinSdk()) {
                    try {
                        context.getPackageManager().getPackageInfo(payment.getPackageName(), 0);
                        return true;
                    } catch (PackageManager.NameNotFoundException e) {
                        return false;
                    }
                } else {
                    return false;
                }
            case GENERIC_INTENT:
                return true;
//                Intent intent = new Intent();
//                intent.setData(Uri.parse(UPIPaymentConstants.UPI_INTENT_PREFIX));
//                return context.getPackageManager().queryIntentActivities(intent, 0).size() > 0;
        }
        return false;

    }

    public String getValuePostData(String postData, String key) {
        String[] list = postData.split("&");
        for (String item : list) {
            String[] items = item.split("=");
            if (items.length >= 2) {
                String id = items[0];
                if (key.equalsIgnoreCase(id)) {
                    return items[1];
                }
            }
        }
        return "";
    }

    public Payment getSupportedPayment(String postData) {
        if (null != postData) {
            String paymentMethod = getValuePostData(postData, UPIPaymentConstants.BANK_CODE);
            for (Payment payment : Payment.values()) {
                if (payment.getPaymentName().equalsIgnoreCase(paymentMethod)) {
                    return payment;
                }
            }
        }
        return null;
    }

    public String getUPIIntent(String payeeVpa, String payeeName, String amount, String transactionId, String transactionRefId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UPIPaymentConstants.UPI_INTENT_PREFIX);
        stringBuilder.append(UPIPaymentConstants.PAYEEE_ADDRESS);
        stringBuilder.append("=");
        stringBuilder.append(payeeVpa);
        stringBuilder.append("&");
        stringBuilder.append(UPIPaymentConstants.PAYEE_NAME);
        stringBuilder.append("=");
        stringBuilder.append(payeeName);
        stringBuilder.append("&");
        stringBuilder.append(UPIPaymentConstants.TRANSACTION_AMOUNT);
        stringBuilder.append("=");
        stringBuilder.append(amount);
        stringBuilder.append("&");
        stringBuilder.append(UPIPaymentConstants.TRANSACTION_REF_ID);
        stringBuilder.append("=");
        stringBuilder.append(transactionRefId);
        stringBuilder.append("&");
        stringBuilder.append(UPIPaymentConstants.TRANSACTIONID);
        stringBuilder.append("=");
        stringBuilder.append(transactionId);
        return stringBuilder.toString();
    }

    public static boolean validateVpa(String vpa, String regex) {
        if (TextUtils.isEmpty(vpa))
            return false;
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(vpa.trim()).matches();
    }

    /**
     * Get Bitmap from Drawable
     *
     * @param drawable {@link android.graphics.drawable}
     * @return Bitmap Object {@link android.graphics.Bitmap}
     */
    @NonNull
    public static Bitmap getBitmapFromDrawable(@NonNull Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable) drawable).getBitmap();
        } else {
            final Bitmap bmp = Bitmap.createBitmap(drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
            final Canvas canvas = new Canvas(bmp);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bmp;
        }
    }
}
