package com.payu.custombrowser.upiintent;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;

public class PaymentResponse implements Parcelable {
    private String merchantName;
    private String returnUrl;
    private String merchantVpa;
    private String referenceId;
    private String amount;
    private String txnId;
    private String disableIntentSeamlessFailure;
    private String combineVerifyAndPayButton ="0";
    private List<PackageBean> apps;
    private String token;
    private String vpaRegex;

    protected PaymentResponse(Parcel in) {
        merchantName = in.readString();
        returnUrl = in.readString();
        merchantVpa = in.readString();
        referenceId = in.readString();
        amount = in.readString();
        txnId = in.readString();
        disableIntentSeamlessFailure = in.readString();
        combineVerifyAndPayButton = in.readString();
        token = in.readString();
        vpaRegex = in.readString();
        apps = in.createTypedArrayList(PackageBean.CREATOR);
    }
    PaymentResponse(){};

    public static final Creator<PaymentResponse> CREATOR = new Creator<PaymentResponse>() {
        @Override
        public PaymentResponse createFromParcel(Parcel in) {
            return new PaymentResponse(in);
        }

        @Override
        public PaymentResponse[] newArray(int size) {
            return new PaymentResponse[size];
        }
    };

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getMerchantVpa() {
        return merchantVpa;
    }

    public void setMerchantVpa(String merchantVpa) {
        this.merchantVpa = merchantVpa;
    }

    public String getReferenceId() {
        return referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getTxnId() {
        return txnId;
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public List<PackageBean> getApps() {
        return apps;
    }

    public void setApps(List<PackageBean> apps) {
        this.apps = apps;
    }

    public String getDisableIntentSeamlessFailure() {
        return disableIntentSeamlessFailure;
    }

    public void setDisableIntentSeamlessFailure(String disableIntentSeamlessFailure) {
        this.disableIntentSeamlessFailure = disableIntentSeamlessFailure;
    }

    public String getCombineVerifyAndPayButton() {
        return combineVerifyAndPayButton;
    }

    public void setCombineVerifyAndPayButton(String combineVerifyAndPayButton) {
        this.combineVerifyAndPayButton = combineVerifyAndPayButton;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getVpaRegex() {
        return vpaRegex;
    }

    public void setVpaRegex(String vpaRegex) {
        this.vpaRegex = vpaRegex;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(merchantName);
        parcel.writeString(returnUrl);
        parcel.writeString(merchantVpa);
        parcel.writeString(referenceId);
        parcel.writeString(amount);
        parcel.writeString(txnId);
        parcel.writeString(disableIntentSeamlessFailure);
        parcel.writeString(combineVerifyAndPayButton);
        parcel.writeString(token);
        parcel.writeString(vpaRegex);
        parcel.writeTypedList(apps);
    }

}
