package com.payu.custombrowser;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.analytics.PayuDeviceAnalytics;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.bean.ReviewOrderData;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.widgets.PayUProgressDialog;
import com.payu.magicretry.MagicRetryFragment;

import org.json.JSONObject;

import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.concurrent.Executor;

public class CustomBrowserMain extends Fragment implements CBConstant{

    //instance for switching between production and testing env. True - testing and false - production
    public static final boolean DEBUG = false;
    //URL for javascript
    final String CB_URL = DEBUG ? TEST_URL : PRODUCTION_URL;

    public int snoozeMode = WARN_MODE;
    // check for webview is realoded again with same url or from the starting
    protected boolean isWebviewReloading;
    protected boolean payuChromeLoaderDisabled = false;
    // Flag for backward journey tracking TODO Reset these flags in case of native retry
    protected boolean backwardJourneyStarted = false;
    // Flag for forward journey tracking - more specifically used for PayUChromeLoader
    // TODO Reset these flags in case of native retry
    protected boolean forwardJourneyForChromeLoaderIsComplete = false;
    // time of arrival of particular page type
    protected String timeOfArrival;
    // First interaction with CB by user after bank page load is complete
    protected boolean firstTouch = false;
    /*  // Mix panel Analytics Instance
      private MixpanelAPI mixpanel;*/
    // time of departure of particular page type
    protected String timeOfDeparture;
    // type of page (for analytics) - data we get is from javascript
    protected String pageType = "";
    // configuration of custom browser which is set by merchant
    protected CustomBrowserConfig customBrowserConfig;
    // Analytics event array for custom browser and non custom browser flow
    protected Timer timerProgress;
    //check if transaction is netbanking type
    // true if transaction is netbanking type else false
    // Check is added to showing confirm transaction dialog only in Netbanking transaction
    protected boolean isTxnNBType;
    // getActivity() for the fragment.
    Activity activity;
    //Receiver for sms reading
    BroadcastReceiver mBroadcastReceiver;
    //initilize js which is common for all banks
    JSONObject mBankJS;
    //Bank specific javascript file
    JSONObject mJS;

    protected ArrayList<ReviewOrderData> reviewOrderDetailList;
  /*  // Mix panel Analytics Instance
    private MixpanelAPI mixpanel;*/
    // check got keyboard
    int checkForInput;
    // Snooze Dialog.
    android.support.v7.app.AlertDialog snoozeDialog;
    //Event analytics Insatnce
    CBAnalytics mAnalytics;
    // Event for analytics
    String eventRecorded;
    // Keeps track of snooze window status. we dont show snooze window if a snooze window is already on screen.
    boolean isSnoozeWindowVisible = false;
    ArrayList<String> eventArray = new ArrayList<>();
    // MagicRetry Fragment Instance
    MagicRetryFragment magicRetryFragment;
    //Check for netbanking custom browser visibility
    boolean nbhelpVisible;
    // banklogo drawable insatnev
    Drawable drawable;
    // instance of webview
    WebView cbWebView;
    // loading_height : custom browser height,minWebview: webview height when CB is open, maxWebview: webview height when CB is close
    int loading_height, minWebview, maxWebview;
    // payu dialog
    PayUProgressDialog progressDialog;
    // webview progress
    // int checkProgress = 0;
    // webview progress
    int lastProgress;
    // shows webview progress
    ProgressBar cbWebPageProgressBar;
    // response received from payu js interface
    // State of CB (MINIMIZE or MAXIMIZE)
    int frameState;
    // sms receiver
    BroadcastReceiver mReceiver = null;
    //   String checkValue; //url set
    String webviewUrl; //url set
    //Set<String> urlSet; //url set
    //Set<String> postPaymentURL; //url set
    // SMS receive permission
    boolean merchantSMSPermission;
    // Bank name
    String bankName;
    String payuReponse;
    // response received from surl/furl js interface
    String merchantResponse;
    // status of the transaction should be set from payu's js interface functions.
    Boolean isSuccessTransaction = Boolean.FALSE;
    // true - one tap payment
    int storeOneClickHash;
    Bundle bundle;
    boolean cbOldFlow;
    // framelayout in which CB is added
    FrameLayout cbBaseView;
    // instance of arrow at the top of CB
    View cbSlideBarView;
    // instance of transparent layer on the bank page
    View cbTransparentView;

    CBUtil cbUtil; // instance of util file
    // bank page loading layout
    View loadingLayout;
    // enter OTP view
    View enterOTPView;
    // Device analytics
    PayuDeviceAnalytics payuDeviceAnalytics;
    // Countdown waitingOTPTimer for payusucess and payufailure response
    CountDownTimer countDownTimer;
    // Transaction verification message received check
    boolean verificationMsgReceived;
    // Check for payu pg true when payu pg is used else false
    boolean payuPG;
    // list of backward urls
    Set<String> backwardJourneyUrls;
    // Retry url list
    Set<String> retryUrls;
    // serial executor for downloading javascript file in background
    Executor serialExecutor;
    private boolean cbVisibleOnce;

    protected boolean autoApprove;
    protected boolean autoSelectOtp;

    // flag to monitor transaction status(success or unknown) received or not.
    // check added unnecessarily showing confirm transaction dialog again
    private boolean isTransactionStatusReceived;

    RelativeLayout layoutReviewDetail;
    TextView textViewReviewDetail;
    TextView textViewReviewDetailCB;
    //Bank icon click listener
    protected ViewOnClickListener viewOnClickListener;
    ReviewOrderFragment reviewOrderFragment;
    public static ArrayAdapter drawerAdapter;


    // check for catchAllJSEnabled
    protected boolean catchAllJSEnabled = false;
    // check for OTP is filled by JS
    protected boolean isOTPFilled = false;
//    protected boolean cbAppeared = false;
    // otp received in SMS
    protected String otp;
    // Its the backup of otp
    // once otp gets populated on bank page we make otp as null
    // afterTextChanged method is called multiple times and this helps in not calling the JS mulitple times
    protected String backupOfOTP;
    // It contains list of txt fields which we receive from JS
    protected String listOfTxtFld;
    protected String hostName;
    // This flag keeps check that toast message should be displayed only when OTP is triggered
    protected boolean otpTriggered = false;
    protected  String surePayS2Surl;
    protected  String merchantKey;
    protected  String txnId;
    protected  String surePayS2SPayUId;
    protected  String phpSessionId;
    protected  String txnType;
    protected  boolean isSurePayValueLoaded = false;

    /**
     * check is type of transaction is netbanking type
     *
     * @param postData post data
     * @return true if netbanking type transaction else false
     */
    protected boolean checkIfTransactionNBType(String postData) {
        try {
            String transactionType = cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), "pg");
            if (transactionType.equalsIgnoreCase("nb")) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * Reset Auto select OTP value
     * Use Only when:  reset only in case where transaction start again from '_payment'
     */
    protected void resetAutoSelectOTP(){
        autoSelectOtp = (customBrowserConfig != null) && customBrowserConfig.getAutoSelectOTP() == CB_ENABLE_OPTION;
    }
    /**
     * Returns drawable from resource id.
     *
     * @param context currentContext
     * @param resID   resourceId
     * @return drawable
     */
    public Drawable getCbDrawable(Context context, int resID) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(resID, context.getTheme());
        } else {
            return context.getResources().getDrawable(resID);
        }
    }



    /**
     * Change the visibility of transview to visble with animation.
     *
     * @param view     transview which is shown with animation
     * @param mContext context of the base activity
     */
    void showTransparentView(final View view, Context mContext) {
        if (view != null) {
            final Animation animation = AnimationUtils.loadAnimation(mContext, R.anim.cb_fade_in);
            view.startAnimation(animation);
            Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    if(activity!=null && !activity.isFinishing())
                    view.setVisibility(View.VISIBLE);
                }
            }, 500);
        }
    }

    /**
     * Dynamic Custom browser.
     * Now we can enable/disable cb based on javascript rules.
     *
     * @param bank name of the bank
     */
    public void checkStatusFromJS(final String bank) {
        checkStatusFromJS(bank, CBConstant.CHECK_CB_ENABLE_JS_STATUS);
    }

    public void checkStatusFromJS(final String bank, final int featureConstant) {
        try {
            if (getActivity() != null && !getActivity().isFinishing()) {
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            JSONObject obj = new JSONObject();
                            obj.put("androidosversion", Build.VERSION.RELEASE + "");
                            obj.put("androidmanufacturer", (Build.MANUFACTURER + "").toLowerCase());
                            obj.put("model", (Build.MODEL + "").toLowerCase());
                            obj.put("merchantid", Bank.keyAnalytics);
                            obj.put("sdkname", Bank.sdkVersion);
                            obj.put("cbname", BuildConfig.VERSION_NAME);
                            if (featureConstant == CBConstant.CHECK_SURE_PAY_ENABLE_JS_STATUS) {
                                String checkSnoozeJS = mBankJS.has("set_dynamic_snooze") ? mBankJS.getString("set_dynamic_snooze") + "(" + obj + ")" : "";
                                cbWebView.loadUrl("javascript:" + checkSnoozeJS);
                            } else if(featureConstant == CBConstant.CHECK_CB_ENABLE_JS_STATUS){
                                obj.put("bankname", bank.toLowerCase());
                                cbWebView.loadUrl("javascript:" + mBankJS.getString("checkVisibilityCBCall") + "(" + obj + ")");
                            }else if(featureConstant == CBConstant.CHECK_REVIEW_ORDER_ENABLE_JS_STATUS){
                                 final String checkSnoozeJS = mBankJS.has("checkVisibilityReviewOrderCall") ? mBankJS.getString("checkVisibilityReviewOrderCall") + "(" + obj + ")" : null;
                                 if(checkSnoozeJS!=null) {

                                     new Handler().postDelayed((new Runnable() {
                                         @Override
                                         public void run() {
                                             if(activity!=null && !activity.isFinishing())
                                                 cbWebView.loadUrl("javascript:" + checkSnoozeJS);
                                         }
                                     }),1000);

                                 }
                            }
                            else if(featureConstant == CBConstant.CHECK_CATCH_ALL_JS_ENABLE_JS_STATUS) {
                                cbWebView.loadUrl("javascript:" + mBankJS.getString(getString(R.string.cb_check_visibility_cajs))+ "(" +obj+")");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }





    /**
     * Force display soft keyboard.
     *
     * @param editText focused edittext for which input method is opened
     */

    void showSoftKeyboard(View editText) {
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        ((InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE)).showSoftInput(editText, InputMethodManager.SHOW_FORCED);
    }

    /**
     * Force hide soft keyboard
     */
    void hideSoftKeyboard() {
        activity.getWindow().setSoftInputMode(
                WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN
        );
    }

    /**
     * Initializing analytics and mixpanel.
     */
    protected void initAnalytics(String sdkMerchantKey) {

        // code update the event on mixpanel only when DEBUG is true
        /*if (DEBUG) // check for mixpanel
            mixpanel = MixpanelAPI.getInstance(getActivity(), projectToken);*/
        // SH: File name as constant?
        // minie
        mAnalytics =  CBAnalytics.getInstance(activity.getApplicationContext(), "local_cache_analytics");
        deviceAnalytics(sdkMerchantKey, activity.getApplicationContext());
    }

    /**
     * Put the device Analytics data to bean and call PayUDeviceAnalytics which logs the device analytics.
     *
     * @param sdkMerchantKey merchant key logged by PayU SDK
     */
    private void deviceAnalytics(String sdkMerchantKey, Context context) {
        JSONObject deviceDetails = new JSONObject();
        try {
            deviceDetails.put(CBAnalyticsConstant.PAYU_ID, cbUtil.getCookie(CBConstant.PAYUID, context));
            deviceDetails.put(CBAnalyticsConstant.TRANSACTION_ID, Bank.transactionID);
            deviceDetails.put(CBAnalyticsConstant.MERCHANT_KEY, sdkMerchantKey);
            deviceDetails.put(CBAnalyticsConstant.DEVICE_OS_VERSION, Build.VERSION.SDK_INT + "");
            deviceDetails.put(CBAnalyticsConstant.DEVICE_RESOLUTION, cbUtil.getDeviceDensity(activity));
            deviceDetails.put(CBAnalyticsConstant.DEVICE_MANUFACTURE, Build.MANUFACTURER);
            deviceDetails.put(CBAnalyticsConstant.DEVICE_MODEL, Build.MODEL);
            deviceDetails.put(CBAnalyticsConstant.NETWORK_INFO, cbUtil.getNetworkStatus(activity.getApplicationContext()));
            deviceDetails.put(CBAnalyticsConstant.SDK_VERSION_NAME, Bank.sdkVersion);
            deviceDetails.put(CBAnalyticsConstant.CB_VERSION_NAME, BuildConfig.VERSION_NAME + "");
            deviceDetails.put(CBAnalyticsConstant.PAKAGE_NAME, context.getPackageName());
            deviceDetails.put(CBAnalyticsConstant.NETWORK_STRENGTH, cbUtil.getNetworkStrength(activity.getApplicationContext()));
            CBUtil.setVariableReflection(CBConstant.MAGIC_RETRY_PAKAGE, sdkMerchantKey, CBConstant.ANALYTICS_KEY);
            payuDeviceAnalytics = new PayuDeviceAnalytics(activity.getApplicationContext(), "cb_local_cache_device");
            payuDeviceAnalytics.log(deviceDetails.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Logging events with txnid and package name.
     * Mixpannel used only in debug mode.
     *
     * @param key   analytics event key
     * @param value analytics event value
     */
    void addEventAnalytics(String key, String value) {
        try {
            if (value != null && !value.trim().equalsIgnoreCase("")) {
                mAnalytics.log(cbUtil.getLogMessage(activity.getApplicationContext(), key, value.toLowerCase(), bankName, Bank.keyAnalytics, Bank.transactionID, pageType));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Finds the corresponding image name for the given bank
     *
     * @param bankNameImage bank image name
     */
    void cbSetBankDrawable(final String bankNameImage) {
        if (drawable == null) {
            if (bankNameImage != null) {
                try {

                    if (bankNameImage.equalsIgnoreCase("sbinet") || bankNameImage.equalsIgnoreCase("sbi")|| bankNameImage.startsWith("sbi_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.sbi);
                    else if (bankNameImage.equalsIgnoreCase("icici") || bankNameImage.equalsIgnoreCase("icicinet") || bankNameImage.equalsIgnoreCase("icicicc")||bankNameImage.startsWith("icici_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.icici);
                    else if (bankNameImage.equalsIgnoreCase("kotaknet") || bankNameImage.equalsIgnoreCase("kotak") || bankNameImage.startsWith("kotak_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.kotak);
                    else if (bankNameImage.equalsIgnoreCase("indus")||bankNameImage.startsWith("indus_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.induslogo);
                    else if (bankNameImage.equalsIgnoreCase("hdfc") || bankNameImage.equalsIgnoreCase("hdfcnet")||bankNameImage.startsWith("hdfc_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.hdfc_bank);
                    else if (bankNameImage.equalsIgnoreCase("yesnet")||bankNameImage.startsWith("yes_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.yesbank_logo);
                    else if (bankNameImage.equalsIgnoreCase("sc")||bankNameImage.startsWith("sc_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.scblogo);
                    else if (bankNameImage.equalsIgnoreCase("axisnet") || bankNameImage.equalsIgnoreCase("axis") ||bankNameImage.startsWith("axis_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.axis_logo);
                    else if (bankNameImage.equalsIgnoreCase("amex") || bankNameImage.startsWith("amex_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.cb_amex_logo);
                    else if (bankNameImage.equalsIgnoreCase("hdfcnet") || bankNameImage.equalsIgnoreCase("hdfc")||bankNameImage.startsWith("hdfc_"))
                        drawable = cbUtil.getDrawableCB(activity, R.drawable.hdfc_bank);
                    else if (bankNameImage.equalsIgnoreCase("ing") || bankNameImage.startsWith("ing_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.ing_logo);
                    else if (bankNameImage.equalsIgnoreCase("idbi") || bankNameImage.startsWith("idbi_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.idbi);
                    else if (bankNameImage.equalsIgnoreCase("citi") || bankNameImage.startsWith("citi_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.citi);
                    else if (bankNameImage.equalsIgnoreCase("unionnet") || bankNameImage.startsWith("unionnet_"))
                        drawable = cbUtil.getDrawableCB(activity.getApplicationContext(), R.drawable.union_bank_logo);
                    else
                        drawable = null;

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
    }

    /**
     * Hide soft keyboard.
     */
    void hideKeyboardForcefully() {
        View view = activity.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }


    /**
     * Measure the height of cbWebView
     *
     * @param view - view to calculate height
     */

    void calculateCBHeight(View view) {
        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        loading_height = view.getMeasuredHeight();
        if(maxWebview!=0) {
            minWebview = maxWebview - loading_height;
        }
    }

    /**
     * Measure cbWebView heigt
     */
    void calculateMaximumWebViewHeight() {
        // SH: rename it
        try {

            if (maxWebview == 0 && bankName!=null) {
                cbWebView.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
                cbWebView.requestLayout();
                maxWebview = cbWebView.getMeasuredHeight();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Adjust Webview size
     */
    void maximiseWebviewHeight() {
        if (maxWebview == 0)
            calculateMaximumWebViewHeight();
        if(maxWebview!=0) {
            cbWebView.getLayoutParams().height = maxWebview;
            cbWebView.requestLayout();
        }
    }

    /**
     * Adjust cbWebView size
     */

    void  minimizeWebviewHeight() {
        if(maxWebview!=0) {
            cbWebView.getLayoutParams().height = minWebview;
            cbWebView.requestLayout();
        }
    }


//    /**
//     * Displaying Payuloader.
//     *
//     * @param context base activity context
//     * @return progress dialog.
//     */
//    private ProgressDialog showProgress(Context context) {
//        if (null != activity && this.isAdded() && context != null && !activity.isFinishing()) {
//            LayoutInflater mInflater = LayoutInflater.from(context);
//            final Drawable[] drawables =
//
//                    {getCbDrawable(activity.getApplicationContext(), R.drawable.l_icon1),
//                            getCbDrawable(activity.getApplicationContext(), R.drawable.l_icon2),
//                            getCbDrawable(activity.getApplicationContext(), R.drawable.l_icon3),
//                            getCbDrawable(activity.getApplicationContext(), R.drawable.l_icon4)
//                    };
//
//            View layout = mInflater.inflate(R.layout.cb_prog_dialog, null);
//            final ImageView imageView = (ImageView) layout.findViewById(R.id.imageView);
//            TextView dialogDesc = (TextView) layout.findViewById(R.id.dialog_desc);
//            if (isWebviewReloading) {
//
//                dialogDesc.setText(activity.getText(R.string.cb_resuming_transaction));
//                isWebviewReloading = false;
//            } else {
//                dialogDesc.setText(activity.getText(R.string.cb_please_wait));
//            }
//            PayUProgressDialog progDialog;
//            if (progressDialog == null) {
//                progDialog = new ProgressDialog(context, R.style.cb_progress_dialog);
//            } else {
//                progDialog = progressDialog;
//            }
//            cbUtil.cancelTimer(timerProgress);
//
//            timerProgress = new Timer();
//            timerProgress.scheduleAtFixedRate(new TimerTask() {
//                int i = -1;
//
//                @Override
//                synchronized public void run() {
//                    if (activity != null) {
//                        activity.runOnUiThread(new Runnable() {
//                                                   @Override
//                                                   public void run() {
//                                                       if (activity != null) {
//                                                           i++;
//                                                           if (i >= drawables.length) {
//                                                               i = 0;
//                                                           }
//                                                           imageView.setImageBitmap(null);
//                                                           imageView.destroyDrawingCache();
//                                                           imageView.refreshDrawableState();
//                                                           imageView.setImageDrawable(drawables[i]);
//                                                       }
//                                                   }
//                                               }
//                        );
//                    }
//
//                }
//            }, 0, 500);
//
//            progDialog.show();
//            progDialog.setContentView(layout);
//            progDialog.setCancelable(true);
//            progDialog.setCanceledOnTouchOutside(false);
//            progDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
//                @Override
//                public void onDismiss(DialogInterface dialog) {
//                    cbUtil.cancelTimer(timerProgress);
//                   /* if (checkProgress == PRE_PAYMENT)
//                        checkProgress = DURING_PAYMENT;*/
//                }
//            });
//            return progDialog;
//        }
//        return null;
//    }

    /**
     * WARNING: NO LONGER USED, ALL CALLS TO THIS METHOD ARE BEING WASTED
     *          SEE progressBarVisibilityPayuChrome(int visibility, String url)
     *
     * Function to show or hide the progress bar.
     *
     * @param visibility input can be View.INVISIBLE View.GONE View.VISIBLE
     */
    // void progressBarVisibilityPayuChrome(int visibility) {
         /*if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded())  {
             if (visibility == View.GONE || visibility == View.INVISIBLE) {

                 if (progressDialog != null && progressDialog.isShowing()) {
                     progressDialog.dismiss();
                     checkForInput = 1;
                 }
             } else if (progressDialog == null) {
                 progressDialog = showProgress(activity);
             }
         }*/
    // }

    /**
     * New implementation to hide/show PayUChromeLoader
     * <p/>
     * NOTE: Use {@link Bank#dismissPayULoader()} method to hide chrome loader
     * and mark forwardjourney complete as well. Otherwise use this method.
     *
     * @param visibility
     * @param url
     */
    void progressBarVisibilityPayuChrome(int visibility, String url) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (visibility == View.GONE || visibility == View.INVISIBLE) {
                if (progressDialog != null) {
                    progressDialog.dismiss();
                    progressDialog = null;
                    showReviewOrderHorizontalBar();
                    // checkForInput = 1;
                }
            } else if (visibility == View.VISIBLE && !payuChromeLoaderDisabled) {
                if (!isSnoozeWindowVisible) {
                    if(progressDialog==null) {
                        if(customBrowserConfig!=null) {
                            if(customBrowserConfig.getProgressDialogCustomView()!=null) {
                                mAnalytics.log(cbUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.CB_LOADER_TYPE_KEY, CBAnalyticsConstant.CB_LOADER_TYPE_CUSTOM, bankName, Bank.keyAnalytics, Bank.transactionID, pageType));
                            }else {
                                mAnalytics.log(cbUtil.getLogMessage(activity.getApplicationContext(),CBAnalyticsConstant.CB_LOADER_TYPE_KEY, CBAnalyticsConstant.DEFAULT, bankName, Bank.keyAnalytics, Bank.transactionID, pageType));
                            }
                            progressDialog = new PayUProgressDialog(activity, customBrowserConfig.getProgressDialogCustomView());
                        }else {
                            mAnalytics.log(cbUtil.getLogMessage(activity.getApplicationContext(),CBAnalyticsConstant.CB_LOADER_TYPE_KEY, CBAnalyticsConstant.DEFAULT, bankName, Bank.keyAnalytics, Bank.transactionID, pageType));
                            progressDialog = new PayUProgressDialog(activity, null);
                        }
                    }
                    if((null == customBrowserConfig)||
                            (null!=customBrowserConfig && customBrowserConfig.getProgressDialogCustomView()== null)) {
                        if (isWebviewReloading) {
                            progressDialog.setText(activity.getString(R.string.cb_resuming_transaction));
                            isWebviewReloading = false;
                        } else {
                            progressDialog.setText(activity.getString(R.string.cb_please_wait));
                        }
                        //Start timer in Payu ProgressDialog always
                        progressDialog.setPayUDialogSettings(activity);
                    }
                    progressDialog.show();
                    if(!cbOldFlow) {
                        hideReviewOrderHorizontalBar();
                        hideReviewOrderDetails();
                    }
                }
            }
        }
    }

    /**
     * OOPS something went wrong, hide PayU loader
     * remove progress bar from webview and progress dialog
     */

    void communicationError() {
        if(activity!=null && !activity.isFinishing() && isAdded() && !isRemoving()) {
          activity.runOnUiThread(new Runnable() {
              @Override
              public void run() {
                  progressBarVisibilityPayuChrome(View.GONE, "");
                  if (cbWebPageProgressBar != null) {
                      cbWebPageProgressBar.setVisibility(View.GONE);
                      //    cbWebPageProgressBar.setProgress(0);
                  }
              }
          });
        }
    }

    /**
     * Start animation of progress bar
     *
     * @param newProgress updated progress of weburl
     */

    void startAnimation(int newProgress) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (lastProgress > newProgress)
                cbWebPageProgressBar.setProgress(newProgress);
            if (Build.VERSION.SDK_INT >= 11) {
                ObjectAnimator animation = ObjectAnimator.ofInt(cbWebPageProgressBar, "progress", newProgress);
                animation.setDuration(50); // 0.5 second
                animation.setInterpolator(new AccelerateInterpolator());
                animation.start();
            } else {
                if (newProgress <= 10) {
                    newProgress = 10;
                }
                cbWebPageProgressBar.setProgress(newProgress);
            }
            lastProgress = newProgress;
        }
    }


    /**
     * Maximize the cbWebView and changes the cb to minimize state
     */
    void hideCB() {
        maximiseWebviewHeight();
        frameState = MINIMISED;
        onHelpUnavailable();
    }


    /**
     * Should be implemented by Calling activity
     *
     * @param broadcastReceiver broadcast receiver to set up.
     * @param filter            - filter for receiving broadcast
     */

    public void registerBroadcast(BroadcastReceiver broadcastReceiver, IntentFilter filter) {
        if (activity != null && !activity.isFinishing()) {
            mReceiver = broadcastReceiver;
            activity.registerReceiver(broadcastReceiver, filter);
        }
    }

    /**
     * Unregister the broad cast receiver.
     *
     * @param broadcastReceiver reference of broadcast receiver
     */
    public void unregisterBroadcast(BroadcastReceiver broadcastReceiver) {
        if (mReceiver != null /*&& cbAppeared*/) {
            activity.unregisterReceiver(broadcastReceiver);
            mReceiver = null;
        }
    }

    /**
     * Hide the custombowser fragement
     */
    public void onHelpUnavailable() {
            if (activity != null && !activity.isFinishing()) {
                activity.findViewById(R.id.parent).setVisibility(View.GONE);
            }
    }

    /**
     * OOPS something went wrong hide cb or progerss dialog.
     */

    public void onBankError() {
        activity.findViewById(R.id.parent).setVisibility(View.GONE);
    }

    /**
     * Yey we support cb for this bank, lets show cb
     */

    public void onHelpAvailable() {
            cbVisibleOnce = true;
            activity.findViewById(R.id.parent).setVisibility(View.VISIBLE);
    }

    public boolean wasCBVisibleOnce() {
        return cbVisibleOnce;
    }

   /* public void updateSet(Set<String> urlSet, String check) {
        if (urlSet != null && urlSet.size() > 0 && webviewUrl != null && !urlSet.contains(webviewUrl)) {
            *//* old progressBarVisibilityPayuChrome(View.GONE); *//*
            checkProgress = DURING_PAYMENT;
        }
        checkValue = check;
    }*/

    /**
     * Check if given rl is retry url
     * @return true if retry url else false
     */
    public  boolean isRetryURL(String url){
        if(retryUrls.size()==0){
            return url.contains(Bank.DEBUG ? PAYMENT_OPTION_URL_DEV : PAYMENT_OPTION_URL_PROD);
        }
        for (String retryUrl : retryUrls) {
            if (url.contains(retryUrl)) {
                return true;
            }
        }
        return false;
    }

    /**
     * update the list of url where progress dialog to be shown
     */
    void setUrlString() {
        if (mBankJS != null) {
            try {
              /*  if (mBankJS.has("pgUrlList")) {
                    String urlStr = mBankJS.getString("pgUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        urlSet.add(st.nextToken());
                    }
                } else {
                    communicationError();
                }*/
                // backward journey url from JS
                if (mBankJS.has("postPaymentPgUrlList")) {
                    String urlStr = mBankJS.getString("postPaymentPgUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        backwardJourneyUrls.add(st.nextToken());
                    }
                }

                // retry url list from JS
                if (mBankJS.has("retryList")) {
                    String urlStr = mBankJS.getString("retryUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        retryUrls.add(st.nextToken());
                    }
                }

               /* {
                    String urlStr = BACKWARD_URL;
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        backwardJourneyUrls.add(st.nextToken());
                    }
                }*/
                // updateSet(urlSet, PAYMENT_OPTION_URL_PROD);
            } catch (Exception e) {
                communicationError();
                e.printStackTrace();
            }
        }
    }

    /**
     * Just to make sure we finish activity even if the merchant's url got into trouble,
     * should be called from
     */
    void callTimer() {
        countDownTimer = new CountDownTimer(customBrowserConfig.getMerchantResponseTimeout(), 1000) {

            public void onTick(long millisUntilFinished) {
//                if (activity != null && !activity.isFinishing() && isAdded() && isMerchantUrlLoaded) {
//                    onMerchantUrlFinished();
//                    cancel();
//                }
            }

            public void onFinish() {
                if (activity!=null && !activity.isFinishing() && isAdded() && !isRemoving()) {
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            if (activity != null && !activity.isFinishing() && isAdded()) {

                                onMerchantUrlFinished();

                            }
                        }
                    });
                }
            }
        }.start();
    }


    /**
     * This function takes care of sending the data back to calling activity with the status, merchantResponse, payuresponse.
     */

    void onMerchantUrlFinished() {
        if (null != countDownTimer)
            countDownTimer.cancel();

        if (activity!=null && !activity.isFinishing() && isAdded() && !isRemoving()) {

            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (activity != null && !activity.isFinishing() && isAdded()) {
                        if (cbOldFlow) {
                            Intent intent = new Intent();
                            intent.putExtra(getString(R.string.cb_result), merchantResponse);
                            intent.putExtra(getString(R.string.cb_payu_response), payuReponse);
                            if (isSuccessTransaction) {
                                if (storeOneClickHash == 1) {
                                    StoreMerchantHashTask mStoreMerchantHashTask = new StoreMerchantHashTask();
                                    mStoreMerchantHashTask.execute(payuReponse);
                                }
                                activity.setResult(Activity.RESULT_OK, intent);
                            } else {
                                activity.setResult(Activity.RESULT_CANCELED, intent);
                            }
                        } else {
                            if (isSuccessTransaction) {
                                if (customBrowserConfig.getStoreOneClickHash() == 1) {
                                    StoreMerchantHashTask mStoreMerchantHashTask = new StoreMerchantHashTask();
                                    mStoreMerchantHashTask.execute(payuReponse);
                                }
                                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentSuccess(payuReponse, merchantResponse);
                                }else{
                                    L.v("PayuError", "No PayUCustomBrowserCallback found, please assign a callback: com.payu.custombrowser.PayUCustomBrowserCallback.setPayuCustomBrowserCallback(PayUCustomBrowserCallback payuCustomBrowserCallback)");
                                }
                            } else {
                                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentFailure(payuReponse, merchantResponse);
                                }else{
                                    L.v("PayuError", "No PayUCustomBrowserCallback found, please assign a callback: com.payu.custombrowser.PayUCustomBrowserCallback.setPayuCustomBrowserCallback(PayUCustomBrowserCallback payuCustomBrowserCallback)");
                                }

                            }
                        }
                        activity.finish();
                    }
                }
            });
        }
    }


    public void loadUrlWebView(JSONObject mJS, String functName) {

    }

    public void onBackPressed(AlertDialog.Builder alertDialog) {
    }

    public void onBackApproved() {

    }

    public void onBackCancelled() {

    }

    /**
     * Cancel notification forward and backward journey
     */
    protected void cancelTransactionNotification() {
        NotificationManager mNotificationManager = (NotificationManager) activity.getSystemService(Context.NOTIFICATION_SERVICE);
        mNotificationManager.cancel(CBConstant.TRANSACTION_STATUS_NOTIFICATION_ID);
        mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);
    }



    public class CBMainViewOnTouchListener implements View.OnTouchListener {

        float initialY;
        boolean isTouch = true;
        int height = 0;

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            if (!nbhelpVisible) {
                maximiseWebviewHeight();
                if (!isTouch)
                    return false;
                int action = event.getActionMasked();
                if (cbSlideBarView.getVisibility() == View.VISIBLE) {
                    cbSlideBarView.setClickable(false);
                    cbSlideBarView.setOnTouchListener(null);

                    TranslateAnimation animate = new TranslateAnimation(0, 0, height, 0);
                    animate.setDuration(500);
                    animate.setFillBefore(true);
                    v.startAnimation(animate);
                    cbBaseView.setVisibility(View.VISIBLE);
                    isTouch = false;
                    final Handler handler = new Handler();
                    handler.postDelayed(new Runnable() {

                        @Override
                        public void run() {
                            if(activity!=null && !activity.isFinishing())
                                cbSlideBarView.setVisibility(View.GONE);
                        }
                    }, 20);
                    final Handler handlertrans = new Handler();
                    handlertrans.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            isTouch = true;
                            frameState = MAXIMISED;
                            if (cbTransparentView != null) {
                                if (activity != null && !activity.isFinishing())
                                    showTransparentView(cbTransparentView, activity);
                            }
                        }
                    }, 500);

                } else {

                    switch (action) {
                        case MotionEvent.ACTION_DOWN:
                            initialY = event.getY();
                            break;
                        case MotionEvent.ACTION_MOVE:
                            break;

                        case MotionEvent.ACTION_UP:
                            //  float finalX = event.getX();
                            float finalY = event.getY();


                            /*    if (initialX < finalX) {
                                }

                                if (initialX > finalX) {
                                }*/

                            if (initialY < finalY) {
                                if (cbBaseView.getVisibility() == View.VISIBLE && (finalY - initialY) > 0) {
                                    height = v.getHeight();
                                    TranslateAnimation animate = new TranslateAnimation(0, 0, 0, v.getHeight() - 30);
                                    animate.setDuration(500);
                                    animate.setFillBefore(false);
                                    animate.setFillEnabled(true);
                                    animate.setZAdjustment(TranslateAnimation.ZORDER_TOP);
                                    v.startAnimation(animate);
                                    if (cbTransparentView != null)
                                        cbTransparentView.setVisibility(View.GONE);
                                    isTouch = false;
                                    isTouch = true;
                                    final Handler handler = new Handler();
                                    handler.postDelayed(new Runnable() {
                                        @Override
                                        public void run() {
                                            if(activity!=null && !activity.isFinishing()) {
                                                frameState = MINIMISED;
                                                cbBaseView.setVisibility(View.GONE);
                                                cbSlideBarView.setVisibility(View.VISIBLE);
                                            }
                                        }
                                    }, 400);
                                }
                            }
                              /*  if (initialY > finalY) {
                                }*/
                            break;

                        case MotionEvent.ACTION_CANCEL:
                            break;

                        case MotionEvent.ACTION_OUTSIDE:
                            break;
                    }
                }
                return true;
            }

            return false;
        }
    }

    // set transaction status
    protected void setTransactionStatusReceived(boolean transactionStatusReceived) {
        isTransactionStatusReceived = transactionStatusReceived;
    }

    protected boolean getTransactionStatusReceived(){
        return isTransactionStatusReceived;
    }


    /**
     * Called when transaction is cancelled on backpress
     * update the status of transaction to 'user cancelled'
     */
    protected void postToPaytxn() {
        if (payuPG) {
            Thread updateTxn = new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        HttpURLConnection conn = cbUtil.getHttpsConn(CBConstant.PAYU_DOMAIN + "/" + CBConstant.PAYU_PAYTXN, null, -1, cbUtil.getCookieList(getActivity().getApplicationContext(), CBConstant.PAYU_DOMAIN));
                        if (!(conn.getResponseCode() == 200)) {
                            Log.d("PayU","BackButtonClick - UnSuccessful post to Paytxn");
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            updateTxn.setPriority(Thread.MAX_PRIORITY);
            updateTxn.start();

        }
    }



    private int mCounter = 0; // keep track of click count
    protected Handler mHandler = new Handler();

    /**
     * Counter for counting number of clicks on bank logo
     */
    protected Runnable mResetCounter = new Runnable() {
        @Override
        public void run() {
            mCounter = 0;
        }
    };


    public class ViewOnClickListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            if(v.getId()==R.id.bank_logo){
                if (mCounter == 0)
                    mHandler.postDelayed(mResetCounter, 3000); // reset count after 3sec
                mCounter++;
                if (mCounter == 5){
                    mHandler.removeCallbacks(mResetCounter);
                    mCounter = 0;
                    Toast.makeText(activity,"Version Name: "+BuildConfig.VERSION_NAME, Toast.LENGTH_SHORT).show();
                }
            }
        }
    }

    /**
     * Show review order layout
     */
    public void showReviewOrderHorizontalBar(){
        if(progressDialog!=null && progressDialog.isShowing()){
            return;
        }
        if(!cbOldFlow && customBrowserConfig.getEnableReviewOrder() == CBConstant.ENABLE && !isSnoozeWindowVisible){
            if(!eventArray.contains(CBAnalyticsConstant.VAL_RO_CUSTOM_BROWSER)){
                eventArray.add(CBAnalyticsConstant.VAL_RO_CUSTOM_BROWSER);
            }
            layoutReviewDetail.setVisibility(View.VISIBLE);
            layoutReviewDetail.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT,CBAnalyticsConstant.VAL_REVIEW_ORDER_CLICK);
                    hideKeyboardForcefully();
                    showReviewOrderDetails();
                }
            });
            setReviewOrderButtonProperty(textViewReviewDetail);
        }
    }


    /**
     * @param reviewOrderTextView textview of review order
     * set property of review order textview
     * take care of custom text and color of review order text
     */
    public void setReviewOrderButtonProperty(TextView reviewOrderTextView){
        if(!cbOldFlow) {
            if (customBrowserConfig.getEnableReviewOrder() == CBConstant.ENABLE) {
                if(customBrowserConfig.getReviewOrderButtonText()!=null){
                    reviewOrderTextView.setText(customBrowserConfig.getReviewOrderButtonText());
                }
                if(customBrowserConfig.getReviewOrderButtonTextColor()!=-1){
                    reviewOrderTextView.setTextColor(activity.getResources().getColor(customBrowserConfig.getReviewOrderButtonTextColor()));
                }
                reviewOrderTextView.setVisibility(View.VISIBLE);
                reviewOrderTextView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT,CBAnalyticsConstant.VAL_REVIEW_ORDER_CLICK);
                        hideKeyboardForcefully();
                        showReviewOrderDetails();

                    }
                });
            } else {
                reviewOrderTextView.setVisibility(View.GONE);
            }
        }else{
            reviewOrderTextView.setVisibility(View.GONE);
        }
    }

    /**
     * hide review order layout
     */
    public void hideReviewOrderHorizontalBar(){
        if(!cbOldFlow ) {
            layoutReviewDetail.setVisibility(View.GONE);
        }
    }

    /**
     * show review order detail page
     * add review order fragment
     */
    public void showReviewOrderDetails(){
        if(reviewOrderFragment!=null && reviewOrderFragment.isAdded()){
            return;
        }
        if(getActivity()!=null) {
            reviewOrderFragment = ReviewOrderFragment.newInstance(reviewOrderDetailList, customBrowserConfig.getReviewOrderCustomView());
            FragmentTransaction fragmentTransaction = getActivity().getSupportFragmentManager().beginTransaction();
            fragmentTransaction.setCustomAnimations(R.anim.slide_up_in, R.anim.slide_up_out);
            fragmentTransaction.add(R.id.payu_review_order, reviewOrderFragment);
            fragmentTransaction.commit();
        }
    }


    /**
     * hide review order detail page
     */
    public void hideReviewOrderDetails(){
        if(getActivity()!=null) {
            if (reviewOrderFragment != null) {
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.remove(reviewOrderFragment);
                ft.setCustomAnimations(R.anim.slide_up_out, R.anim.slide_up_in);
                ft.commitAllowingStateLoss();
            }
        }
    }
}
