package com.payu.custombrowser.util;

/**
 * Created by himanshu.gupta on 18/01/18.
 *
 * Define PaymentOption to handle multiple PaymentOption via reflection
 * paymentName
 */

public enum PaymentOption {
    SAMSUNGPAY("SAMPAY", "com.payu.samsungpay.SamsungWrapper"),
    PHONEPE("PPINTENT", "com.payu.phonepe.PhonePeWrapper");

    private String paymentName;
    private String packageName;

    public String getPackageName() {
        return packageName;
    }

    /**
     * @param paymentName BankCode for payment
     * @param packageName Gradle Package Name
     */
    PaymentOption(String paymentName, String packageName) {
        this.paymentName = paymentName;
        this.packageName = packageName;
    }

    public String getPaymentName() {
        return paymentName;
    }
}
