package com.payu.custombrowser.upiintent;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.payu.custombrowser.PackageListDialogFragment;
import com.payu.custombrowser.R;
import com.payu.custombrowser.cbinterface.GenericUPICallbacks;

import java.util.List;

/**
 * Created by himanshu.gupta on 07/05/18.
 */

public class PackageListAdapter extends RecyclerView.Adapter<PackageListAdapter.PackageViewHolder> {

    private List<PackageBean> packageBeanList;
    private Context context;
    private GenericUPICallbacks callbacks;
    private PackageListDialogFragment fragment;

    public PackageListAdapter(List<PackageBean> packageBeanList, Context context, PackageListDialogFragment packageListDialogFragment) {
        this.packageBeanList = packageBeanList;
        this.context = context;
        this.callbacks = (GenericUPICallbacks) context;
        this.fragment = packageListDialogFragment;
    }

    @NonNull
    @Override
    public PackageViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(context).inflate(R.layout.cb_layout_package_list,parent,false);
        return new PackageViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull final PackageViewHolder holder, int position) {
        final PackageBean packageBean = packageBeanList.get(holder.getAdapterPosition());
        holder.packageName.setText(packageBean.getPackageName());
        holder.packageDrawable.setImageDrawable(packageBean.getDrawable());
        holder.relativeLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                fragment.dismiss();
                callbacks.onAppSelected(packageBean.getPackageId());
            }
        });

    }


    @Override
    public int getItemCount() {
        return packageBeanList.size();
    }

    class PackageViewHolder extends RecyclerView.ViewHolder{
        ImageView packageDrawable;
        TextView packageName;
        LinearLayout relativeLayout;

        public PackageViewHolder(View itemView) {
            super(itemView);
            relativeLayout = (LinearLayout)itemView;
            packageDrawable = (ImageView)itemView.findViewById(R.id.image);
            packageName = (TextView)itemView.findViewById(R.id.text);
        }
    }
}
