package com.payu.custombrowser.factory;

import com.payu.custombrowser.util.PaymentOption;
import com.payu.custombrowser.wrapper.PaymentOptionWrapper;
import com.payu.custombrowser.wrapper.PhonePeWrapper;
import com.payu.custombrowser.wrapper.SamsungPayWrapper;

public class PaymentOptionFactory {
    private PaymentOption paymentOption;
    private PaymentOptionWrapper paymentOptionWrapper;

    public PaymentOptionFactory(PaymentOption paymentOption){
        this.paymentOption = paymentOption;
    }

    public PaymentOptionWrapper getPaymentWrapper(){
        switch (paymentOption){
            case PHONEPE:
                paymentOptionWrapper = getPhonePeWrapper();
                break;
            case SAMSUNGPAY:
                paymentOptionWrapper = getSamsungPayWrapper();
            default:
                break;
        }
        return paymentOptionWrapper;
    }

    private PaymentOptionWrapper getPhonePeWrapper() {
        return new PhonePeWrapper();
    }

    private PaymentOptionWrapper getSamsungPayWrapper() {
        return new SamsungPayWrapper();
    }
}
