package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import com.payu.custombrowser.bean.CustomBrowserAsyncTaskData;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.cbinterface.CustomBrowserAsyncTaskInterface;
import com.payu.custombrowser.cbinterface.GenericUPICallbacks;
import com.payu.custombrowser.custombar.CircularProgressView;
import com.payu.custombrowser.upiintent.PackageBean;
import com.payu.custombrowser.upiintent.PackageListAdapter;
import com.payu.custombrowser.upiintent.PaymentResponse;
import com.payu.custombrowser.upiintent.UPIPaymentConstants;
import com.payu.custombrowser.upiintent.UPIUtil;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CustomBrowserAsyncTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by himanshu.gupta on 07/05/18.
 */

public class PackageListDialogFragment extends DialogFragment implements View.OnClickListener, CustomBrowserAsyncTaskInterface, TextWatcher {
    RecyclerView recyclerView;
    ArrayList<PackageBean> list;
    LinearLayout layoutVpa;
    LinearLayout layoutAppSelector;
    LinearLayout llPayment;
    LinearLayout llSeparator;
    RelativeLayout rlInputVpa;
    TextView tvMakePayment;
    TextView tvHeading;
    Activity mActivity;
    PaymentResponse paymentResponse;
    boolean isVpaVerified;
    private EditText editVpa;
    private CustomBrowserConfig cbCustomBrowserConfig;
    private TextView tvVerifyVpa;
    private TextView tvVpaName;
    private ImageView ivVpaSuccess;
    private CircularProgressView cbProgress;
    private boolean isEditVpa = false;
    private ScrollView scrollView;
    private boolean isValidPaymentMethodPresent = true;
    private boolean isCollectShownAlways = false;
    private StringBuilder vpaRegex;

    public static PackageListDialogFragment newInstance(ArrayList<PackageBean> list, PaymentResponse paymentResponse, CustomBrowserConfig customBrowserConfig) {
        PackageListDialogFragment packageListDialogFragment = new PackageListDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("list", list);
        bundle.putParcelable(CBConstant.CB_CONFIG, customBrowserConfig);
        bundle.putParcelable("paymentResponse", paymentResponse);
        packageListDialogFragment.setArguments(bundle);
        return packageListDialogFragment;
    }

    public PackageListDialogFragment() {
        setRetainInstance(true);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.cb_layout_generic_upi, container,
                false);
        //Inflated custom xml , can do whatever we require.
        scrollView = (ScrollView) rootView;
        recyclerView = (RecyclerView) rootView.findViewById(R.id.rvApps);
        layoutVpa = (LinearLayout) rootView.findViewById(R.id.ll_vpa);
        layoutAppSelector = (LinearLayout) rootView.findViewById(R.id.ll_app_selector);
        rlInputVpa = (RelativeLayout) rootView.findViewById(R.id.rlInputVpa);
        llPayment = (LinearLayout) rootView.findViewById(R.id.llPayment);
        llSeparator = (LinearLayout) rootView.findViewById(R.id.ll_separator);
        editVpa = (EditText) rootView.findViewById(R.id.edit_vpa);
        tvMakePayment = (TextView) rootView.findViewById(R.id.tv_vpa_submit);
        tvHeading = (TextView) rootView.findViewById(R.id.tvHeading);
        tvVerifyVpa = (TextView) rootView.findViewById(R.id.tvVerifyVpa);
        tvVpaName = (TextView) rootView.findViewById(R.id.tvVpaName);
        cbProgress = (CircularProgressView) rootView.findViewById(R.id.progressBar);
        ivVpaSuccess = (ImageView) rootView.findViewById(R.id.ivVpaSuccess);
        list = getArguments().getParcelableArrayList("list");
        paymentResponse = getArguments().getParcelable("paymentResponse");
        cbCustomBrowserConfig = getArguments().getParcelable(CBConstant.CB_CONFIG);
        hideUPICollect();
        return rootView;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
    }

    @Override
    public void onStart() {
        super.onStart();
        if (getDialog().getWindow() != null) {
            int width = ViewGroup.LayoutParams.MATCH_PARENT;
            int height = ViewGroup.LayoutParams.WRAP_CONTENT;
            getDialog().getWindow().setLayout(width, height);
            getDialog().getWindow().setGravity(Gravity.BOTTOM);
            getDialog().setCanceledOnTouchOutside(false);
            getDialog().getWindow().setWindowAnimations(
                    R.style.dialog_slide_animation);
            if (mActivity != null) {
                final View rootView = mActivity.getWindow().getDecorView().getRootView();
                rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
                    @Override
                    public void onGlobalLayout() {
                        Rect r = new Rect();
                        //r will be populated with the coordinates of your view that area still visible.
                        rootView.getWindowVisibleDisplayFrame(r);

                        int heightDiff = rootView.getRootView().getHeight() - (r.bottom - r.top);
                        if (heightDiff < rootView.getRootView().getHeight() / 4) { // if more than 100 pixels, its probably a keyboard...
                            // ... do something here ... \\
                            if (isEditVpa && editVpa.getText().toString().trim().isEmpty() &&!isCollectShownAlways) {
                                isEditVpa = false;
                                hideUPICollect();
                            }
                        } else {
                            isEditVpa = true;
                            scrollView.post(new Runnable() {
                                @Override
                                public void run() {
                                    scrollView.fullScroll(View.FOCUS_DOWN);
                                    editVpa.requestFocus();
                                }
                            });
                        }
                    }
                });
            }
        }
        if (list != null && list.size() > 0) {
            layoutAppSelector.setVisibility(View.VISIBLE);
            recyclerView.setLayoutManager(new GridLayoutManager(mActivity, 3));
            recyclerView.setAdapter(new PackageListAdapter(list, mActivity, this));
        } else {
            if (paymentResponse.getDisableIntentSeamlessFailure() != null && paymentResponse.getDisableIntentSeamlessFailure().equalsIgnoreCase("1")) {
                //No apps are present and merchant has disabled UPI collect.Hence cancel transaction
                isValidPaymentMethodPresent = false;
                getDialog().cancel();
            }else {
                showUPICollect();
                isCollectShownAlways = true;
                layoutAppSelector.setVisibility(View.GONE);
                llSeparator.setVisibility(View.INVISIBLE);
            }
        }
        if (paymentResponse.getDisableIntentSeamlessFailure() != null && paymentResponse.getDisableIntentSeamlessFailure().equalsIgnoreCase("1")) {
            layoutVpa.setVisibility(View.GONE);
            llSeparator.setVisibility(View.INVISIBLE);
        } else {
            layoutVpa.setVisibility(View.VISIBLE);
            tvMakePayment.setEnabled(false);
            tvMakePayment.setOnClickListener(this);
        }
        if (paymentResponse.getCombineVerifyAndPayButton() != null && paymentResponse.getCombineVerifyAndPayButton().equalsIgnoreCase("1")) {
            tvVerifyVpa.setVisibility(View.GONE);
            disablePaymentButton();
        } else {
            tvVerifyVpa.setVisibility(View.GONE);
            tvVerifyVpa.setOnClickListener(this);
            tvMakePayment.setEnabled(false);
            tvMakePayment.setAlpha(0.35f);
        }
        vpaRegex = new StringBuilder();
        if(!TextUtils.isEmpty(paymentResponse.getVpaRegex())) {
            vpaRegex.append(paymentResponse.getVpaRegex());
            if(vpaRegex.charAt(0)=='/')
                vpaRegex.deleteCharAt(0);
            if(vpaRegex.charAt(vpaRegex.length()-1)=='/')
                vpaRegex.deleteCharAt(vpaRegex.length()-1);
        }else {
            vpaRegex.append(UPIPaymentConstants.VPA_REGEX_DEFAULT);
        }
        editVpa.addTextChangedListener(this);
    }
    


    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.tv_vpa_submit) {
            if (paymentResponse.getCombineVerifyAndPayButton().equalsIgnoreCase("1")) {
                requestValidateVPA();
            } else {
                proceedVPACollect();
            }
        } else if (view.getId() == R.id.tvVerifyVpa) {
            requestValidateVPA();
        } else if (view.getId() == R.id.tvHeading) {
            showUPICollect();
        }
    }

    /**
     * Function to call ValidateVpa api to validate input customer vpa
     * @param verifyVpaHash Hash to be calculated by Merchant
     */
    public void verifyVpa(String verifyVpaHash) {
        String postData = "key=" + cbCustomBrowserConfig.getMerchantKey() + "&var1=" + editVpa.getText().toString().trim() + "&command=validateVPA&hash=" + verifyVpaHash;
        CustomBrowserAsyncTaskData asyncTaskData = new CustomBrowserAsyncTaskData();
        asyncTaskData.setHttpMethod("POST");
        asyncTaskData.setUrl(CBConstant.PRODUCTION_FETCH_DATA_URL);
        asyncTaskData.setPostData(postData);
        new CustomBrowserAsyncTask(this).execute(asyncTaskData);

    }

    @Override
    public void onCustomBrowserAsyncTaskResponse(String cbAsynTaskResponse) {
        editVpa.setEnabled(true);
        tvMakePayment.setVisibility(View.VISIBLE);
        cbProgress.stopAnimation();
        cbProgress.setVisibility(View.GONE);
        if (isValidVPA(cbAsynTaskResponse)) {
            if (paymentResponse.getCombineVerifyAndPayButton() != null && paymentResponse.getCombineVerifyAndPayButton().equalsIgnoreCase("1")) {
                launchCustomBrowser();
                dismiss();
                if(null!=getActivity())
                    getActivity().finish();
            } else {
                enablePaymentButton();
                tvVerifyVpa.setVisibility(View.GONE);
                String payeeName = getMerchantName(cbAsynTaskResponse);
                if (payeeName != null && !payeeName.equalsIgnoreCase("null")) {
                    tvVpaName.setVisibility(View.VISIBLE);
                    tvVpaName.setTextColor(getResources().getColor(R.color.cb_item_color));
                    tvVpaName.setText(payeeName);
                } else {
                    tvVpaName.setVisibility(View.GONE);
                }
                ivVpaSuccess.setVisibility(View.VISIBLE);
//                Toast.makeText(mActivity, "VPA valid", Toast.LENGTH_SHORT).show();
                isVpaVerified = true;
            }
        } else {
            showInvalidVPAError();
            if (paymentResponse.getCombineVerifyAndPayButton() != null && !paymentResponse.getCombineVerifyAndPayButton().equalsIgnoreCase("1")) {
                tvVerifyVpa.setVisibility(View.VISIBLE);
                tvVerifyVpa.setBackgroundResource(android.R.color.transparent);
                tvVerifyVpa.setText(getResources().getString(R.string.cb_verify));
            }
//            Toast.makeText(mActivity, "VPA doesn't exist", Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * Function to launch CustomBrowser to start UPI collect .
     */
    private void launchCustomBrowser() {
        CBActivity.cbDrawerAdapter = cbCustomBrowserConfig.getCbMenuAdapter();
        CBActivity.cbConfigToolbarView = cbCustomBrowserConfig.getToolBarView();
        String postData = "token=" + paymentResponse.getToken() + "&action=sdkFallback&customerVpa=" + editVpa.getText().toString().trim();
        if(null!=list && list.isEmpty())
            postData = postData.concat("&fallbackReasonCode=E1902");
        cbCustomBrowserConfig.setPayuPostData(postData);
        cbCustomBrowserConfig.setPostURL(paymentResponse.getReturnUrl());
        Intent intent = new Intent(getActivity(), CBActivity.class);
        intent.putExtra("cb_config", cbCustomBrowserConfig);
        if (cbCustomBrowserConfig.getReviewOrderDefaultViewData() != null && cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas() != null) {
            intent.putExtra(CBConstant.ORDER_DETAILS, cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas());
        }
        mActivity.startActivity(intent);
    }

    @Override
    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        ((GenericUPICallbacks) mActivity).onDialogCancelled(isValidPaymentMethodPresent);
    }

    /**
     * Function to hide UPI collect option
     */
    private void hideUPICollect() {
        final float scale = getResources().getDisplayMetrics().density;
        int padding_in_px = (int) (10 * scale + 0.5f);
        tvHeading.setCompoundDrawablesWithIntrinsicBounds(R.drawable.cb_ic_edit_black, 0, 0, 0);
        tvHeading.setPadding(0, 0, 0, padding_in_px);
        tvHeading.setOnClickListener(this);
        tvHeading.setCompoundDrawablePadding(20);
        rlInputVpa.setVisibility(View.GONE);
        tvVpaName.setVisibility(View.GONE);
        llPayment.setVisibility(View.GONE);
        ivVpaSuccess.setVisibility(View.GONE);
    }

    /**
     * Function to show UPI collect option
     */
    private void showUPICollect() {
        tvHeading.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        tvHeading.setOnClickListener(null);
        tvHeading.setCompoundDrawablePadding(0);
        rlInputVpa.setVisibility(View.VISIBLE);
        llPayment.setVisibility(View.VISIBLE);
        isEditVpa = true;
        editVpa.requestFocus();
        showSoftKeyboard();
    }

    /**
     * Function to check if VPA is valid
     * @param response Response of validateVPA api
     * @return true if vpa is valid else false
     */
    private boolean isValidVPA(String response) {
        try {
            JSONObject jsonObject = new JSONObject(response);
            return jsonObject.has(UPIPaymentConstants.VPA_VALID) && (jsonObject.getInt(UPIPaymentConstants.VPA_VALID) == 1);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     *  Function to get name associated with VPA
     * @param jsonResponse Response of validateVPA api
     * @return payeeAccountName if present else null
     */
    private String getMerchantName(String jsonResponse) {
        try {
            JSONObject jsonObject = new JSONObject(jsonResponse);
            if (jsonObject.has(UPIPaymentConstants.PAYER_ACCOUNT_NAME))
                return jsonObject.getString(UPIPaymentConstants.PAYER_ACCOUNT_NAME);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void requestValidateVPA() {
        if (UPIUtil.validateVpa(editVpa.getText().toString(),vpaRegex.toString())) {
            showProgressBar();
            editVpa.setEnabled(false);
            tvVerifyVpa.setVisibility(View.GONE);
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onVpaEntered(editVpa.getText().toString(), this);
        } else {
            showInvalidVPAError();
        }
    }

    /**
     * Function to proceed for UPI collect
     */
    private void proceedVPACollect() {
        launchCustomBrowser();
        dismiss();
        mActivity.finish();
    }

    @Override
    public void onDestroyView() {
        //workaround for this issue: https://code.google.com/p/android/issues/detail?id=17423 (unable to retain instance after configuration change)
        if (getDialog() != null && getRetainInstance())
            getDialog().setDismissMessage(null);
        super.onDestroyView();
//        hideSoftKeyboard(editVpa);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

    }

    @Override
    public void afterTextChanged(Editable editable) {
        tvVpaName.setVisibility(View.GONE);
        if(UPIUtil.validateVpa(editVpa.getText().toString(),vpaRegex.toString())){
            if(paymentResponse.getCombineVerifyAndPayButton()!=null && paymentResponse.getCombineVerifyAndPayButton().equalsIgnoreCase("0")){
                tvVerifyVpa.setVisibility(View.VISIBLE);
                tvMakePayment.setEnabled(false);
                tvMakePayment.setAlpha(0.35f);
                ivVpaSuccess.setVisibility(View.INVISIBLE);
            }else {
                tvMakePayment.setEnabled(true);
                tvMakePayment.setAlpha(1.0f);
            }
        }else {
            tvMakePayment.setEnabled(false);
            tvMakePayment.setAlpha(0.35f);
            if(paymentResponse.getCombineVerifyAndPayButton()!=null && paymentResponse.getCombineVerifyAndPayButton().equalsIgnoreCase("0")){
                tvVerifyVpa.setVisibility(View.GONE);
            }
        }

    }
    private void showProgressBar(){
        cbProgress.setVisibility(View.VISIBLE);
        cbProgress.setIndeterminate(true);
        cbProgress.setColor(getResources().getColor(R.color.cb_progress_bar_color));
        cbProgress.startAnimation();
    }

    /**
     * Function to disable Payment Button
     */
    private void disablePaymentButton(){
        tvMakePayment.setText(getResources().getString(R.string.cb_verify_and_proceed));
        tvMakePayment.setEnabled(false);
        tvMakePayment.setTextColor(getResources().getColor(android.R.color.white));
        tvMakePayment.setAlpha(0.35f);
        tvMakePayment.setOnClickListener(this);
    }

    /**
     * Function to enable Payment Button
     */
    private void enablePaymentButton(){
        tvMakePayment.setTextColor(getResources().getColor(android.R.color.white));
        tvMakePayment.setText(getResources().getText(R.string.proceed_to_pay));
        tvMakePayment.setEnabled(true);
        tvMakePayment.setAlpha(1.0f);
    }

    /**
     * Function to show invalid vpa error
     */
    private void showInvalidVPAError(){
        tvVpaName.setVisibility(View.VISIBLE);
        tvVpaName.setText(getResources().getString(R.string.cb_invalid_vpa));
        tvVpaName.setTextColor(Color.RED);
    }

    @Override
    public void onPause() {
        super.onPause();
        hideSoftKeyboard(editVpa);
    }

    /**
     * Hide Keyboard
     * @param input
     */
    protected void hideSoftKeyboard(EditText input) {
        InputMethodManager imm = (InputMethodManager) mActivity.getSystemService(Context.INPUT_METHOD_SERVICE);
        if(null!=imm)
            imm.hideSoftInputFromWindow(input.getWindowToken(), 0);
    }
    /**
     * Show Keyboard
     */
    protected void showSoftKeyboard() {
        InputMethodManager imm = (InputMethodManager) mActivity.getSystemService(Context.INPUT_METHOD_SERVICE);
        if(null!=imm)
            imm.toggleSoftInput(InputMethodManager.SHOW_FORCED, 0);
    }
}
