package com.payu.custombrowser.upiintent;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;

import com.payu.custombrowser.Bank;
import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.widgets.PayUProgressDialog;

import org.json.JSONObject;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.util.Timer;
import java.util.TimerTask;

import static com.payu.custombrowser.upiintent.UPIPaymentConstants.MERCHANT_NAME;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.MERCHANT_VPA;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.REFERENCE_ID;
import static com.payu.custombrowser.upiintent.UPIPaymentConstants.RETURN_URL;

/**
 * Created by himanshu.gupta on 17/01/18.
 */
class PaymentHandler {
    private WeakReference<Activity> mActivity;
    private String postData;
    private PayUCustomBrowserCallback payUCustomBrowserCallback;
    private PayUProgressDialog progressDialog;
    private String paymentUrl;
    private String verifyPaymentUrl;
    private String merchantVpa;
    private String merchantName;
    private String referenceId;
    private UPIUtil upiUtil;
    private Payment payment;
    private Timer transactionTimeout;
    private long TRANSACTION_TIMEOUT=20*60*1000;//20 Minutes
    PaymentHandler(Activity mActivity, String postData, PayUCustomBrowserCallback payUCustomBrowserCallback) {
        this.mActivity = new WeakReference<Activity>(mActivity);
        this.postData = postData;
        this.upiUtil = new UPIUtil();
        this.payUCustomBrowserCallback = payUCustomBrowserCallback;
        //TODO
        this.paymentUrl = Bank.DEBUG ? CBConstant.TEST_PAYMENT_URL : CBConstant.PAYMENT_URL;
    }

    void initiatePayment() {
        AsyncTask asyncTask = new AsyncTask<String, Void, Boolean>() {

            @Override
            protected void onPreExecute() {
                super.onPreExecute();
                if (mActivity.get() != null && !mActivity.get().isFinishing()) {
                    progressDialog = new PayUProgressDialog(mActivity.get());
                    progressDialog.show();
                }
            }

            @Override
            protected Boolean doInBackground(String... params) {
                try {
                    CBUtil cbUtil = new CBUtil();
                    postData = postData.concat("&" + UPIPaymentConstants.TXN_S2S_FLOW + "=2");
                    HttpURLConnection conn = cbUtil.getHttpsConn(paymentUrl, postData);
                    if (conn != null) {
                        int responseCode = conn.getResponseCode();
                        if (responseCode == HttpURLConnection.HTTP_OK) {
                            try {
                                InputStream responseInputStream = conn.getInputStream();
                                StringBuffer responseStringBuffer = cbUtil.getStringBufferFromInputStream(responseInputStream);
                                if (responseStringBuffer != null) {
                                    JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                                    merchantName = jsonObject.optString(MERCHANT_NAME);
                                    verifyPaymentUrl = jsonObject.optString(RETURN_URL);
                                    merchantVpa = jsonObject.optString(MERCHANT_VPA);
                                    referenceId = jsonObject.optString(REFERENCE_ID);
                                    if(TextUtils.isEmpty(merchantName)||TextUtils.isEmpty(verifyPaymentUrl)||TextUtils.isEmpty(merchantVpa)||TextUtils.isEmpty(referenceId))
                                        return false;
                                    return true;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }

            @Override
            protected void onPostExecute(Boolean result) {
                super.onPostExecute(result);
                if (null != progressDialog && progressDialog.isShowing() && !mActivity.get().isFinishing())
                    progressDialog.dismiss();
                if (result) {
                    makePayment();
                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(UPIPaymentConstants.MERCHANT_INFO_NOT_PRESENT_CODE, UPIPaymentConstants.MERCHANT_INFO_NOT_PRESENT);
                    mActivity.get().finish();
                }
            }
        };
        asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{""});
    }

    private void makePayment() {
        payment = upiUtil.getSupportedPayment(postData);
        Intent i = new Intent();
        i.setPackage(payment.getPackageName());
        i.setData(Uri.parse(upiUtil.getUPIIntent(merchantVpa, merchantName, upiUtil.getValuePostData(postData, UPIPaymentConstants.AMOUNT),
                upiUtil.getValuePostData(postData, UPIPaymentConstants.TRANSACTION_ID), referenceId)));
        mActivity.get().startActivityForResult(i, UPIPaymentConstants.PAYMENT_REQUEST_CODE);
        startTimer();
    }

    private void startTimer(){
        if(transactionTimeout!=null)
            new CBUtil().cancelTimer(transactionTimeout);
        transactionTimeout = new Timer();
        transactionTimeout.schedule(new TimerTask() {
            @Override
            public void run() {
                if(mActivity.get()!=null && !mActivity.get().isFinishing()){
                    mActivity.get().runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            verifyPayment(UPIPaymentConstants.FAILURE,"timeout");
                        }
                    });
                }
            }
        },TRANSACTION_TIMEOUT);
    }
    void verifyPayment(final String transactionStatus, final String errorReason) {
        AsyncTask asyncTask = new AsyncTask<String, Void, String>() {

            @Override
            protected void onPreExecute() {
                super.onPreExecute();
                if (mActivity.get() != null && !mActivity.get().isFinishing()) {
                    progressDialog = new PayUProgressDialog(mActivity.get());
                    progressDialog.show();
                }
            }

            @Override
            protected String doInBackground(String... params) {
                try {
                    CBUtil cbUtil = new CBUtil();
                    String postData = UPIPaymentConstants.TRANSACTION_STATUS + "=" + transactionStatus + "&" + UPIPaymentConstants.FAILURE_REASON + "=" + errorReason;
                    HttpURLConnection conn = cbUtil.getHttpsConn(verifyPaymentUrl, postData);
                    if (conn != null) {
                        int responseCode = conn.getResponseCode();
                        if (responseCode == HttpURLConnection.HTTP_OK) {
                            try {
                                InputStream responseInputStream = conn.getInputStream();
                                StringBuffer responseStringBuffer = cbUtil.getStringBufferFromInputStream(responseInputStream);
                                if (responseStringBuffer != null) {
                                    String response = cbUtil.getBase64DecodedString(responseStringBuffer.toString());
                                    return response;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();

                }
                return null;
            }

            @Override
            protected void onPostExecute(String result) {
                super.onPostExecute(result);
                if (null != progressDialog && progressDialog.isShowing() && !mActivity.get().isFinishing())
                    progressDialog.dismiss();
                if (!TextUtils.isEmpty(result)) {
                    if (transactionStatus.equalsIgnoreCase(UPIPaymentConstants.FAILURE) || transactionStatus.equalsIgnoreCase(UPIPaymentConstants.CANCEL)) {
                        payUCustomBrowserCallback.onPaymentFailure(result, null);
                    } else {
                        payUCustomBrowserCallback.onPaymentSuccess(result, null);
                    }
                } else {
                    payUCustomBrowserCallback.onPaymentFailure(null, null);
                }
                if(transactionTimeout!=null)
                    new CBUtil().cancelTimer(transactionTimeout);
                mActivity.get().finish();

            }
        };
        asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{""});
    }

}
