package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.util.Log;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.bean.CustomBrowserResultData;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.L;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/**
 * Created by minie.sahni on 2/19/18.
 */

public class SamsungPayWrapper {

    private PayUCustomBrowserCallback cbListener;
    private ClassLoader samsungWrapperClassLoader;
    private Constructor samsungWrapperConstructor;
    private Class samsungWrapperClass;
    private Object samsungWrapperObject;

    /**
     *  Function to make payment by Samsung Pay
     *
     * @param customBrowserConfig {@link com.payu.custombrowser.bean.CustomBrowserConfig}
     */
    void MakeSamsungPayPayment(Activity activity,CustomBrowserConfig customBrowserConfig) {
        try {
            if(CustomBrowserData.SINGLETON!=null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
                this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
            Method method = samsungWrapperObject.getClass().getMethod("makePayment", Activity.class,String.class);
            method.invoke(samsungWrapperObject, activity,customBrowserConfig.getPayuPostData());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     *  Function to check for SamsungPay availability
     *
     * @param context Context
     * @param paymentOptionHash Payment Related Details Hash
     * @param merchantKey Merchant Key
     * @param user_credentials User Credentials
     */
    void checkForSamsungPayAvailability(Context context,String paymentOptionHash,String merchantKey,String user_credentials) {
        if(CustomBrowserData.SINGLETON!=null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback()!=null)
        this.cbListener = CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback();
        try {
            samsungWrapperClassLoader = SamsungPayWrapper.class.getClassLoader();
            samsungWrapperClass = samsungWrapperClassLoader.loadClass("com.payu.samsungpay.SamsungWrapper");
            samsungWrapperConstructor = samsungWrapperClass.getDeclaredConstructor(java.lang.reflect.InvocationHandler.class);
            samsungWrapperConstructor.setAccessible(true);
            samsungWrapperObject = samsungWrapperConstructor.newInstance(cbCallback);

            Method method = samsungWrapperObject.getClass().getMethod("checkSamsungPayAvailability", String.class,String.class,String.class, Context.class);
            method.invoke(samsungWrapperObject, paymentOptionHash,merchantKey,user_credentials,context);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     *  Reflection Callback mapping with PayUCustomBrowserCallback and SamsungPay Callback
     */
    java.lang.reflect.InvocationHandler cbCallback = new java.lang.reflect.InvocationHandler() {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            L.d("testsamsung", "method.getName() " + method.getName());
            for (int i = 0; i < args.length; i++) {
                L.d("testsamsung", "args[0] " + args[i]);
            }
            if (method.getName().equalsIgnoreCase(CBConstant.SAMSUNGPAY_SUCCESS)) {
                cbListener.onPaymentSuccess(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.SAMSUNGPAY_FAILURE)) {
                cbListener.onPaymentFailure(args[0] + "", null);
            } else if (method.getName().equalsIgnoreCase(CBConstant.SAMSUNGPAY_INIT_SUCCESS)) {
                CustomBrowserResultData resultData = new CustomBrowserResultData();
                resultData.setSamsungPayVpa((String)args[0]);
                cbListener.isPaymentOptionAvailable(resultData);
            } else if (method.getName().equalsIgnoreCase(CBConstant.SAMSUNGPAY_INIT_FAILURE)) {
                cbListener.onCBErrorReceived(Integer.parseInt(args[0] + ""), args[1] + "");
            }
            return null;
        }
    };
}
