package com.payu.custombrowser.bean;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.IntDef;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.view.View;
import android.widget.ArrayAdapter;

import com.payu.custombrowser.Bank;
import com.payu.custombrowser.R;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;

public class CustomBrowserConfig implements Parcelable {


    public static final int STOREONECLICKHASH_MODE_NONE = 0;
    public static final int STOREONECLICKHASH_MODE_SERVER = 1;
    public static final int WARN_MODE = CBConstant.WARN_MODE;
    public static final int FAIL_MODE = CBConstant.FAIL_MODE;
    public static final int ENABLE = CBConstant.ENABLE;
    public static final int TRUE = CBConstant.ENABLE;
    public static final int DISABLE = CBConstant.DISABLE;
    public static final int FALSE = CBConstant.DISABLE;

    public String getPayUOptionPaymentHash() {
        return payUOptionPaymentHash;
    }

    public void setPayUOptionPaymentHash(String payUOptionPaymentHash) {
        this.payUOptionPaymentHash = payUOptionPaymentHash;
    }

    private String payUOptionPaymentHash;
    private int viewPortWideEnable;
    private int autoApprove;
    private int autoSelectOTP;
    private String transactionID;
    private String merchantKey;
    private String sdkVersionName;
    private int showCustombrowser;
    private int disableBackButtonDialog;
    private int storeOneClickHash;
    private int magicRetry = 1;
    private int merchantSMSPermission;
    private int enableSurePay; // 0 to disable snooze, +ive inter to configure number of times snooze window can appear for a transaction.
    private String merchantCheckoutActivityPath;
    private String postURL;
    private String payuPostData;
    private String htmlData;
    // Sure pay notification id.
    private int surePayNotificationIcon;
    // sPN sure pay notification
    // title, header, body of forward journey
    private String surePayNotificationGoodNetworkTitle;
    private String surePayNotificationGoodNetWorkHeader;
    private String surePayNotificationGoodNetWorkBody;
    // sPN sure pay notification
    // title, header, body of could not identify internet with int SNOOZE_TTL (30 min)
    private String surePayNotificationPoorNetWorkTitle;
    private String surePayNotificationPoorNetWorkHeader;
    private String surePayNotificationPoorNetWorkBody;
    // title, header, body of Transaction verified. - success response.
    private String surePayNotificationTransactionVerifiedTitle;
    private String surePayNotificationTransactionVerifiedHeader;

    private String surePayNotificationTransactionVerifiedBody;
    // title, header, body of Transaction verified. - success response.
    private String surePayNotificationTransactionNotVerifiedTitle;
    private String surePayNotificationTransactionNotVerifiedHeader;
    private String surePayNotificationTransactionNotVerifiedBody;
    private int surePayMode;
    // Living time of Snooze service.
    private int surePayBackgroundTTL;

    private int internetRestoredWindowTTL;

    public ArrayAdapter getCbMenuAdapter() {
        return cbMenuAdapter;
    }

    public void setCbMenuAdapter(ArrayAdapter cbMenuAdapter) {
        this.cbMenuAdapter = cbMenuAdapter;
    }

    private ArrayAdapter cbMenuAdapter;

    // Review order config
    private int enableReviewOrder; // Can have value ENABLE or DISABLE to enable or disable Review order resp.
    private String reviewOrderButtonText; // Custom text for review order button
    private int reviewOrderButtonTextColor; // Custom color for review order
    private transient  ReviewOrderBundle reviewOrderDefaultViewData; // Bundle data for review order screen. Can hace key value pairs
    private int reviewOrderCustomView; // Custom review order view set by merchant
    private static View toolBarView;
    private int cbDrawerCustomMenu;
    private int enableWebFlow;
    private int gmsProviderUpdatedStatus ;

    public int getCbDrawerCustomMenu() {
        return cbDrawerCustomMenu;
    }

    public void setCbDrawerCustomMenu(int cbDrawerCustomMenu) {
        this.cbDrawerCustomMenu = cbDrawerCustomMenu;
    }

    public View getToolBarView() {
        return toolBarView;
    }

    public void setToolBarView(View toolBarView) {
        this.toolBarView = toolBarView;
    }

    public static final Creator<CustomBrowserConfig> CREATOR = new Creator<CustomBrowserConfig>() {
        @Override
        public CustomBrowserConfig createFromParcel(Parcel in) {
            return new CustomBrowserConfig(in);
        }

        @Override
        public CustomBrowserConfig[] newArray(int size) {
            return new CustomBrowserConfig[size];
        }
    };

    private CustomBrowserConfig() {
    }

    protected CustomBrowserConfig(Parcel in) {
        viewPortWideEnable = in.readInt();
        autoApprove = in.readInt();
        autoSelectOTP = in.readInt();
        transactionID = in.readString();
        merchantKey = in.readString();
        sdkVersionName = in.readString();
        showCustombrowser = in.readInt();
        disableBackButtonDialog = in.readInt();
        storeOneClickHash = in.readInt();
        magicRetry = in.readInt();
        merchantSMSPermission = in.readInt();
        enableSurePay = in.readInt();
        merchantCheckoutActivityPath = in.readString();
        postURL = in.readString();
        payuPostData = in.readString();
        htmlData = in.readString();
        surePayNotificationIcon = in.readInt();
        surePayNotificationGoodNetworkTitle = in.readString();
        surePayNotificationGoodNetWorkHeader = in.readString();
        surePayNotificationGoodNetWorkBody = in.readString();
        surePayNotificationPoorNetWorkTitle = in.readString();
        surePayNotificationPoorNetWorkHeader = in.readString();
        surePayNotificationPoorNetWorkBody = in.readString();
        surePayNotificationTransactionVerifiedTitle = in.readString();
        surePayNotificationTransactionVerifiedHeader = in.readString();
        surePayNotificationTransactionVerifiedBody = in.readString();
        surePayNotificationTransactionNotVerifiedTitle = in.readString();
        surePayNotificationTransactionNotVerifiedHeader = in.readString();
        surePayNotificationTransactionNotVerifiedBody = in.readString();
        surePayMode = in.readInt();
        surePayBackgroundTTL = in.readInt();
        internetRestoredWindowTTL = in.readInt();
        reviewOrderCustomView = in.readInt();
        enableReviewOrder = in.readInt();
        reviewOrderButtonText = in.readString();
        reviewOrderButtonTextColor = in.readInt();
        cbDrawerCustomMenu = in.readInt();
        enableWebFlow = in.readInt();
        gmsProviderUpdatedStatus = in.readInt();
    }

    public CustomBrowserConfig(@NonNull @Size(min = 6, max = 6) String merchantKey, @NonNull String transactionID) {
        this.transactionID = transactionID;
        this.merchantKey = merchantKey;

        this.surePayNotificationIcon = R.drawable.surepay_logo;
        this.surePayNotificationGoodNetworkTitle = "Internet Restored";
        this.surePayNotificationGoodNetWorkHeader = "You can now resume the transaction";

        this.surePayNotificationPoorNetWorkTitle = "No Internet Found";
        this.surePayNotificationPoorNetWorkHeader = "We could not detect internet on your device";

        this.surePayNotificationTransactionVerifiedTitle = "Transaction Verified";
        this.surePayNotificationTransactionVerifiedHeader = "The bank has verified this transaction and we are good to go.";

        this.surePayNotificationTransactionNotVerifiedTitle = "Transaction Status Unknown";
        this.surePayNotificationTransactionNotVerifiedHeader = "The bank could not verify the transaction at this time.";


        // Default value of maximum snooze count is three.(disable snooze by setting value to 0)
        this.enableSurePay = 0;

        // Default snooze mode is snooze + mr (Warn mode)
        this.surePayMode = CBConstant.WARN_MODE;

        this.surePayBackgroundTTL = CBConstant.DEFAULT_SURE_PAY_TTL;

        this.internetRestoredWindowTTL = CBConstant.INTERNET_RESTORED_WINDOW_TTL;
        this.reviewOrderCustomView = -1;
        this.enableReviewOrder = CBConstant.DISABLE;
        this.reviewOrderButtonTextColor = -1;
        //Default value of webflow payment is true
        this.enableWebFlow = 1;
        //Default value of ProviderChangeHandled is false
        this.gmsProviderUpdatedStatus = FALSE;

    }


    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(viewPortWideEnable);
        dest.writeInt(autoApprove);
        dest.writeInt(autoSelectOTP);
        dest.writeString(transactionID);
        dest.writeString(merchantKey);
        dest.writeString(sdkVersionName);
        dest.writeInt(showCustombrowser);
        dest.writeInt(disableBackButtonDialog);
        dest.writeInt(storeOneClickHash);
        dest.writeInt(magicRetry);
        dest.writeInt(merchantSMSPermission);
        dest.writeInt(enableSurePay);
        dest.writeString(merchantCheckoutActivityPath);
        dest.writeString(postURL);
        dest.writeString(payuPostData);
        dest.writeString(htmlData);
        dest.writeInt(surePayNotificationIcon);
        dest.writeString(surePayNotificationGoodNetworkTitle);
        dest.writeString(surePayNotificationGoodNetWorkHeader);
        dest.writeString(surePayNotificationGoodNetWorkBody);
        dest.writeString(surePayNotificationPoorNetWorkTitle);
        dest.writeString(surePayNotificationPoorNetWorkHeader);
        dest.writeString(surePayNotificationPoorNetWorkBody);
        dest.writeString(surePayNotificationTransactionVerifiedTitle);
        dest.writeString(surePayNotificationTransactionVerifiedHeader);
        dest.writeString(surePayNotificationTransactionVerifiedBody);
        dest.writeString(surePayNotificationTransactionNotVerifiedTitle);
        dest.writeString(surePayNotificationTransactionNotVerifiedHeader);
        dest.writeString(surePayNotificationTransactionNotVerifiedBody);
        dest.writeInt(surePayMode);
        dest.writeInt(surePayBackgroundTTL);
        dest.writeInt(internetRestoredWindowTTL);
        dest.writeInt(reviewOrderCustomView);
        dest.writeInt(enableReviewOrder);
        dest.writeString(reviewOrderButtonText);
        dest.writeInt(reviewOrderButtonTextColor);
        dest.writeInt(cbDrawerCustomMenu);
        dest.writeInt(enableWebFlow);
        dest.writeInt(gmsProviderUpdatedStatus);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getPostURL() {
        return postURL;
    }

    public void setPostURL(String postURL) {
        this.postURL = postURL;
    }

    public String getPayuPostData() {
        return payuPostData;
    }

    public void setPayuPostData(String payuPostData) {
        this.payuPostData = payuPostData;

        // here we set the sure pay notification values also.
        HashMap<String, String> postParams = new CBUtil().getDataFromPostData(payuPostData);
        String defaultText = "Product info: " + postParams.get("productinfo") + "\nAmount: " + postParams.get("amount");
        if (null == this.surePayNotificationGoodNetWorkBody)
            this.setSurePayNotificationGoodNetWorkBody(defaultText);
        if (null == this.surePayNotificationPoorNetWorkBody) {
            this.setSurePayNotificationPoorNetWorkBody(defaultText);
        }
        if (null == this.surePayNotificationTransactionVerifiedBody) {
            this.setSurePayNotificationTransactionVerifiedBody(defaultText);
        }
        if (null == this.surePayNotificationTransactionNotVerifiedBody) {
            this.setSurePayNotificationTransactionNotVerifiedBody(defaultText);
        }

        // We set the merchant key once the user set post data in cb config.
        if (null != postParams.get(CBConstant.KEY)) {
            this.setMerchantKey(null == Bank.keyAnalytics ? postParams.get(CBConstant.KEY) : Bank.keyAnalytics);
        }

    }

    public int getEnableSurePay() {
        return enableSurePay;
    }

    public void setEnableSurePay(@IntRange(from=0, to=3) int enableSurePay) {
        this.enableSurePay = enableSurePay > 3 ? 3 : enableSurePay;
    }

    public int getMerchantSMSPermission() {
        return merchantSMSPermission;
    }

    public void setMerchantSMSPermission(boolean merchantSMSPermission) {
        this.merchantSMSPermission = merchantSMSPermission ? 1 : 0;
    }

    public int getEnableWebFlow() {
        return enableWebFlow;
    }

    public void setEnableWebFlow(Payment payment,boolean enableWebFlow) {
        payment.setWebFlowSupported(enableWebFlow);
    }

    public int getMagicretry() {
        return magicRetry;
    }

    public void setmagicRetry(boolean magicRetry) {
        this.magicRetry = magicRetry ? 1 : 0;
    }

    public int getStoreOneClickHash() {
        return storeOneClickHash;
    }

    public void setStoreOneClickHash(@StoreOneClickHashMode int storeOneClickHash) {
        this.storeOneClickHash = storeOneClickHash;
    }

    public String getMerchantCheckoutActivityPath() {
        return merchantCheckoutActivityPath;
    }
    //public static final int STOREONECLICKHASH_MODE_MOBILE = 2;

    public void setMerchantCheckoutActivityPath(String merchantCheckoutActivityPath) {
        this.merchantCheckoutActivityPath = merchantCheckoutActivityPath;
    }

    public int getDisableBackButtonDialog() {
        return disableBackButtonDialog;
    }

    public void setDisableBackButtonDialog(boolean disableBackButtonDialog) {
        this.disableBackButtonDialog = disableBackButtonDialog ? 1 : 0;
    }

    public int getViewPortWideEnable() {
        return viewPortWideEnable;
    }

    public void setViewPortWideEnable(boolean viewPortWideEnable) {
        this.viewPortWideEnable = viewPortWideEnable ? 1 : 0;
    }

    public int getAutoApprove() {
        return autoApprove;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove ? 1 : 0;
    }

    public String getTransactionID() {
        return transactionID;
    }


    public int getAutoSelectOTP() {
        return autoSelectOTP;
    }

    public void setAutoSelectOTP(boolean autoSelectOTP) {
        this.autoSelectOTP = autoSelectOTP ? 1 : 0;
    }

    public String getMerchantKey() {
        return merchantKey;
    }

    /**
     * Setter for merchant key.
     * it should take the values in the following order.
     * 1. {@link Bank#keyAnalytics}
     * 2. {@link CustomBrowserConfig#setPayuPostData(String)}
     * 3. {@link CustomBrowserConfig#setMerchantKey(String)}
     *
     * @param merchantKey
     */
    public void setMerchantKey(String merchantKey) {
        this.merchantKey = Bank.keyAnalytics;
        if (null == this.merchantKey || this.merchantKey.trim().length() < 1) {
            this.merchantKey = merchantKey;
            Bank.keyAnalytics = merchantKey;
        }
    }

    public String getSdkVersionName() {
        return sdkVersionName;
    }

    public void setSdkVersionName(String sdkVersionName) {
        this.sdkVersionName = sdkVersionName;
    }

    public int getShowCustombrowser() {
        return showCustombrowser;
    }

    public void setShowCustombrowser(boolean showCustombrowser) {
        this.showCustombrowser = showCustombrowser ? 1 : 0;
    }

    public String getSurePayNotificationGoodNetworkTitle() {
        return surePayNotificationGoodNetworkTitle;
    }

    public void setSurePayNotificationGoodNetworkTitle(String surePayNotificationGoodNetworkTitle) {
        this.surePayNotificationGoodNetworkTitle = surePayNotificationGoodNetworkTitle;
    }

    public String getSurePayNotificationGoodNetWorkHeader() {
        return surePayNotificationGoodNetWorkHeader;
    }

    public void setSurePayNotificationGoodNetWorkHeader(String surePayNotificationGoodNetWorkHeader) {
        this.surePayNotificationGoodNetWorkHeader = surePayNotificationGoodNetWorkHeader;
    }

    public String getSurePayNotificationGoodNetWorkBody() {
        return surePayNotificationGoodNetWorkBody;
    }

    public void setSurePayNotificationGoodNetWorkBody(String surePayNotificationGoodNetWorkBody) {
        this.surePayNotificationGoodNetWorkBody = surePayNotificationGoodNetWorkBody;
    }

    public String getSurePayNotificationPoorNetWorkTitle() {
        return surePayNotificationPoorNetWorkTitle;
    }

    public void setSurePayNotificationPoorNetWorkTitle(String surePayNotificationPoorNetWorkTitle) {
        this.surePayNotificationPoorNetWorkTitle = surePayNotificationPoorNetWorkTitle;
    }

    public String getSurePayNotificationPoorNetWorkHeader() {
        return surePayNotificationPoorNetWorkHeader;
    }

    public void setSurePayNotificationPoorNetWorkHeader(String surePayNotificationPoorNetWorkHeader) {
        this.surePayNotificationPoorNetWorkHeader = surePayNotificationPoorNetWorkHeader;
    }

    public String getSurePayNotificationPoorNetWorkBody() {
        return surePayNotificationPoorNetWorkBody;
    }

    public void setSurePayNotificationPoorNetWorkBody(String surePayNotificationPoorNetWorkBody) {
        this.surePayNotificationPoorNetWorkBody = surePayNotificationPoorNetWorkBody;
    }

    public String getSurePayNotificationTransactionVerifiedTitle() {
        return surePayNotificationTransactionVerifiedTitle;
    }

    public void setSurePayNotificationTransactionVerifiedTitle(String surePayNotificationTransactionVerifiedTitle) {
        this.surePayNotificationTransactionVerifiedTitle = surePayNotificationTransactionVerifiedTitle;
    }

    public String getSurePayNotificationTransactionVerifiedHeader() {
        return surePayNotificationTransactionVerifiedHeader;
    }

    public void setSurePayNotificationTransactionVerifiedHeader(String surePayNotificationTransactionVerifiedHeader) {
        this.surePayNotificationTransactionVerifiedHeader = surePayNotificationTransactionVerifiedHeader;
    }

    public String getSurePayNotificationTransactionVerifiedBody() {
        return surePayNotificationTransactionVerifiedBody;
    }

    public void setSurePayNotificationTransactionVerifiedBody(String surePayNotificationTransactionVerifiedBody) {
        this.surePayNotificationTransactionVerifiedBody = surePayNotificationTransactionVerifiedBody;
    }

    public String getSurePayNotificationTransactionNotVerifiedTitle() {
        return surePayNotificationTransactionNotVerifiedTitle;
    }

    public void setSurePayNotificationTransactionNotVerifiedTitle(String surePayNotificationTransactionNotVerifiedTitle) {
        this.surePayNotificationTransactionNotVerifiedTitle = surePayNotificationTransactionNotVerifiedTitle;
    }

    public String getSurePayNotificationTransactionNotVerifiedHeader() {
        return surePayNotificationTransactionNotVerifiedHeader;
    }

    public void setSurePayNotificationTransactionNotVerifiedHeader(String surePayNotificationTransactionNotVerifiedHeader) {
        this.surePayNotificationTransactionNotVerifiedHeader = surePayNotificationTransactionNotVerifiedHeader;
    }

    public String getSurePayNotificationTransactionNotVerifiedBody() {
        return surePayNotificationTransactionNotVerifiedBody;
    }

    public void setSurePayNotificationTransactionNotVerifiedBody(String surePayNotificationTransactionNotVerifiedBody) {
        this.surePayNotificationTransactionNotVerifiedBody = surePayNotificationTransactionNotVerifiedBody;
    }

    public int getSurePayNotificationIcon() {
        return surePayNotificationIcon;
    }

    public void setSurePayNotificationIcon(int surePayNotificationIcon) {
        this.surePayNotificationIcon = surePayNotificationIcon;
    }

    public int getSurePayMode() {
        return surePayMode;
    }

    public void setSurePayMode(@SnoozeMode int surePayMode) {
        this.surePayMode = surePayMode;
    }

    public int getInternetRestoredWindowTTL() {
        return internetRestoredWindowTTL;
    }

    public void setInternetRestoredWindowTTL(int internetRestoredWindowTTL) {
        this.internetRestoredWindowTTL = internetRestoredWindowTTL;
    }

    @IntDef({STOREONECLICKHASH_MODE_NONE, STOREONECLICKHASH_MODE_SERVER})
    @Retention(RetentionPolicy.SOURCE)
    public @interface StoreOneClickHashMode {
    }

    @IntDef({ENABLE, DISABLE})
    public @interface ReviewOrder{

    }

    @IntDef({WARN_MODE, FAIL_MODE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface SnoozeMode {
    }


    public String getReviewOrderButtonText() {
        return reviewOrderButtonText;
    }

    public void setReviewOrderButtonText(@NonNull @Size(max = 16)  String reviewOrderButtonText) {
        if(reviewOrderButtonText==null){
          throw new RuntimeException("ReviewOrderButtonText cannot be null");
        }else if(reviewOrderButtonText.length() >16){
           throw new RuntimeException("ReviewOrderButtonText size should be less than 16");
        }else {
            this.reviewOrderButtonText = reviewOrderButtonText;
        }
    }

    public int getReviewOrderButtonTextColor() {
        return reviewOrderButtonTextColor;
    }

    public void setReviewOrderButtonTextColor(@ColorRes  int reviewOrderButtonTextColor) {
        this.reviewOrderButtonTextColor = reviewOrderButtonTextColor;
    }

    public int getEnableReviewOrder() {
        return enableReviewOrder;
    }

    public void setEnableReviewOrder(@ReviewOrder  int enableReviewOrder) {
        this.enableReviewOrder = enableReviewOrder;
    }

    public int getSurePayBackgroundTTL() {
        return surePayBackgroundTTL;
    }

    public void setSurePayBackgroundTTL(int surePayBackgroundTTL) {
        this.surePayBackgroundTTL = surePayBackgroundTTL;
    }

    public int getReviewOrderCustomView() {
        return reviewOrderCustomView;
    }

    public void setReviewOrderCustomView(@LayoutRes int reviewOrderCustomView) {
        this.reviewOrderCustomView = reviewOrderCustomView;
    }

    public ReviewOrderBundle getReviewOrderDefaultViewData() {
        return reviewOrderDefaultViewData;
    }

    public void setReviewOrderDefaultViewData(ReviewOrderBundle reviewOrderDefaultViewData) {
        this.reviewOrderDefaultViewData = reviewOrderDefaultViewData;
    }

    public int getGmsProviderUpdatedStatus() {
        return gmsProviderUpdatedStatus;
    }

    public void setGmsProviderUpdatedStatus(int gmsProviderUpdatedStatus) {
        this.gmsProviderUpdatedStatus = gmsProviderUpdatedStatus;
    }

    public String getHtmlData() {
        return htmlData;
    }

    public void setHtmlData(String htmlData) {
        this.htmlData = htmlData;
    }
}
