/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.NotificationManager;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.R;
import com.payu.custombrowser.ReviewOrderFragment;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;
import java.util.ArrayList;
import org.json.JSONException;

public class CBActivity
extends AppCompatActivity
implements MagicRetryFragment.ActivityCallback,
ReviewOrderFragment.OnReviewOrderDetailCloseListener {
    protected static ArrayAdapter cbDrawerAdapter;
    public static int STATE;
    CustomBrowserConfig customBrowserConfig;
    private Bank payUCustomBrowser;
    private AlertDialog snoozeDialog;
    private android.app.AlertDialog backButtonAlertDialog;
    CBUtil cbUtil;
    protected static View cbConfigToolbarView;

    protected void onStart() {
        super.onStart();
    }

    protected void onResume() {
        super.onResume();
        STATE = 1;
    }

    protected void onPause() {
        super.onPause();
        STATE = 2;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(null);
        this.setContentView(R.layout.cb_payments);
        this.payUCustomBrowser = new Bank();
        this.cbUtil = new CBUtil();
        this.cbUtil.resetPayuID();
        Bundle bundle = new Bundle();
        this.customBrowserConfig = (CustomBrowserConfig)this.getIntent().getParcelableExtra("cb_config");
        ArrayList reviewOrderBundle = this.getIntent().getParcelableArrayListExtra("order_details");
        bundle.putParcelable("cb_config", (Parcelable)this.customBrowserConfig);
        if (reviewOrderBundle != null) {
            bundle.putParcelableArrayList("order_details", reviewOrderBundle);
        }
        this.payUCustomBrowser.setArguments(bundle);
        this.cbSetToolBar(cbConfigToolbarView);
        this.initDrawer();
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_frame, (Fragment)this.payUCustomBrowser).commit();
    }

    public void onBackPressed() {
        if (this.customBrowserConfig != null && this.customBrowserConfig.getDisableBackButtonDialog() != 1) {
            this.payUCustomBrowser.addEventAnalytics("user_input", "payu_back_button".toLowerCase());
            this.payUCustomBrowser.showBackButtonDialog();
        } else {
            this.payUCustomBrowser.addEventAnalytics("user_input", "m_back_button");
            if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(null);
            }
            this.finish();
        }
    }

    public void showMagicRetry() {
        this.payUCustomBrowser.showMagicRetry();
    }

    public void hideMagicRetry() {
        this.payUCustomBrowser.hideMagicRetry();
    }

    public void onDestroy() {
        if (this.backButtonAlertDialog != null && this.backButtonAlertDialog.isShowing()) {
            this.backButtonAlertDialog.dismiss();
            this.backButtonAlertDialog.cancel();
        }
        if (this.snoozeDialog != null && this.snoozeDialog.isShowing()) {
            this.snoozeDialog.dismiss();
            this.snoozeDialog.cancel();
        }
        STATE = 3;
        if (this.payUCustomBrowser != null && this.payUCustomBrowser.getSnoozeLoaderView() != null) {
            this.payUCustomBrowser.getSnoozeLoaderView().cancelAnimation();
            this.payUCustomBrowser.setSnoozeLoaderView(null);
        }
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();
            CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(null);
        }
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
        mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);
        mNotificationManager.cancel(63);
        super.onDestroy();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (null != intent && intent.getStringExtra("sender").contentEquals("snoozeService") && null != this.payUCustomBrowser) {
            this.payUCustomBrowser.killSnoozeService();
            this.payUCustomBrowser.dismissSnoozeWindow();
            this.payUCustomBrowser.snoozeNotificationIntent = null;
            this.payUCustomBrowser.isSnoozeNotificationLaunched = false;
            if (intent.getExtras().getBoolean("verificationMsgReceived")) {
                try {
                    String verifyApiStatus = this.cbUtil.getValueOfJSONKey(intent.getExtras().getString("payu_response"), this.getString(R.string.cb_snooze_verify_api_status));
                    if (verifyApiStatus.equalsIgnoreCase("1")) {
                        this.payUCustomBrowser.addEventAnalytics("transaction_verified_notification_click", "-1");
                    } else {
                        this.payUCustomBrowser.addEventAnalytics("transaction_not_verified_notification_click", "-1");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.payUCustomBrowser.showTransactionStatusDialog(intent.getExtras().getString("payu_response"), true);
            } else {
                this.payUCustomBrowser.addEventAnalytics("internet_restored_notification_click", "-1");
                this.payUCustomBrowser.resumeTransaction(intent);
            }
        }
    }

    @Override
    public void onFragmentInteraction() {
        this.payUCustomBrowser.addEventAnalytics("user_input", "review_order_close_click");
    }

    public void cbSetToolBar(View resView) {
        if (resView != null && null != this.getSupportActionBar()) {
            this.getSupportActionBar().setDisplayShowTitleEnabled(false);
            this.getSupportActionBar().setCustomView(resView, new ActionBar.LayoutParams(-1, -1));
            this.getSupportActionBar().setDisplayShowCustomEnabled(true);
            Toolbar toolbar = (Toolbar)resView.getParent();
            toolbar.setContentInsetsAbsolute(0, 0);
        } else if (null != this.getSupportActionBar()) {
            this.getSupportActionBar().hide();
        }
    }

    private void initDrawer() {
        if (cbDrawerAdapter != null && this.customBrowserConfig.getCbDrawerCustomMenu() != 0) {
            DrawerLayout mDrawerLayout = (DrawerLayout)this.findViewById(R.id.drawer_layout);
            ListView v = (ListView)this.getLayoutInflater().inflate(this.customBrowserConfig.getCbDrawerCustomMenu(), null);
            DrawerLayout.LayoutParams lp = new DrawerLayout.LayoutParams(-1, -1);
            lp.gravity = 0x800003;
            mDrawerLayout.addView((View)v);
            v.setLayoutParams((ViewGroup.LayoutParams)lp);
            v.setAdapter((ListAdapter)cbDrawerAdapter);
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getNavigationDrawerObject(mDrawerLayout);
        }
    }
}

