package com.payu.custombrowser.widgets;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.payu.custombrowser.R;
import com.payu.custombrowser.util.CBUtil;

import java.util.Timer;
import java.util.TimerTask;


/**
 * Created by himanshu.gupta on 28/12/17.
 */

public class PayUProgressDialog extends Dialog {

    private TextView tvMessage;
    private Activity mActivity;
    Timer timerProgress = null;
    CBUtil cbUtil;
    /**
     * Displaying Payuloader.
     *
     * @param context base activity context
     */
    public PayUProgressDialog(Context context) {
        super(context, R.style.cb_progress_dialog);
        this.mActivity = (Activity) context;
        LayoutInflater mInflater = LayoutInflater.from(context);
        cbUtil = new CBUtil();
        final Drawable[] drawables =

                {getCbDrawable(context.getApplicationContext(), R.drawable.l_icon1),
                        getCbDrawable(context.getApplicationContext(), R.drawable.l_icon2),
                        getCbDrawable(context.getApplicationContext(), R.drawable.l_icon3),
                        getCbDrawable(context.getApplicationContext(), R.drawable.l_icon4)
                };

        View layout = mInflater.inflate(R.layout.cb_prog_dialog, null);
        setContentView(layout);
        tvMessage = (TextView) layout.findViewById(R.id.dialog_desc);
        final ImageView imageView = (ImageView) layout.findViewById(R.id.imageView);

        setCancelable(true);
        setCanceledOnTouchOutside(false);
        cbUtil.cancelTimer(timerProgress);

        timerProgress = new Timer();
        timerProgress.scheduleAtFixedRate(new TimerTask() {
            int i = -1;

            @Override
            synchronized public void run() {
                if (mActivity != null) {
                    mActivity.runOnUiThread(new Runnable() {
                                                @Override
                                                public void run() {
                                                    if (mActivity != null) {
                                                        i++;
                                                        if (i >= drawables.length) {
                                                            i = 0;
                                                        }
                                                        imageView.setImageBitmap(null);
                                                        imageView.destroyDrawingCache();
                                                        imageView.refreshDrawableState();
                                                        imageView.setImageDrawable(drawables[i]);
                                                    }
                                                }
                                            }
                    );
                }

            }
        }, 0, 500);
        setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                cbUtil.cancelTimer(timerProgress);
            }
        });
    }

    /**
     * Returns drawable from resource id.
     *
     * @param context currentContext
     * @param resID   resourceId
     * @return drawable
     */
    private Drawable getCbDrawable(Context context, int resID) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(resID, context.getTheme());
        } else {
            return context.getResources().getDrawable(resID);
        }
    }

    public void setText(String text) {
        tvMessage.setText(text);
    }
}
