package com.payu.custombrowser;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.os.Build;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.upiintent.PaymentResponseActivity;
import com.payu.custombrowser.upiintent.UPIPaymentConstants;
import com.payu.custombrowser.upiintent.UPIUtil;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.PaymentOption;
import com.payu.custombrowser.util.PaymentOptionHandler;

import org.json.JSONException;



public class CustomBrowser {

    /**
     * Function to check if payment is supported
     *
     * @param activity Activity instance
     * @param paymentOption {@link com.payu.custombrowser.util.PaymentOption}Payment Type
     * @param payUCustomBrowserCallback {@link com.payu.custombrowser.PayUCustomBrowserCallback}PayUCustomBrowserCallback instance
     * @param paymentOptionHash Hash for Payment Related Details api
     * @param merchantKey Merchant Key
     * @param user_credentials User Credentials
     */

    public void checkForPaymentAvailability(Activity activity, @NonNull PaymentOption paymentOption, @NonNull PayUCustomBrowserCallback payUCustomBrowserCallback, String paymentOptionHash, String merchantKey, String user_credentials){
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(payUCustomBrowserCallback);
        switch (paymentOption){
            case SAMSUNGPAY:
                if(CBUtil.isSPModuleAvailable()) {
                    SamsungPayWrapper samsungPayWrapper = new SamsungPayWrapper();
                    samsungPayWrapper.checkForSamsungPayAvailability(activity.getApplicationContext(), paymentOptionHash, merchantKey, user_credentials);
                    CustomBrowserData.SINGLETON.setSamsungPayWrapper(samsungPayWrapper);
                } else {
                    payUCustomBrowserCallback.onCBErrorReceived(CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED,CBConstant.DEVICE_NOT_SUPPORTED_OR_MODULE_NOT_IMPORTED_MSG);
                }
            break;
            case CC:
            case NB:
            case DC:
                PaymentOptionHandler paymentOptionHandler = new PaymentOptionHandler(activity,payUCustomBrowserCallback,merchantKey,paymentOptionHash,user_credentials);
                break;
        }

    }

    /**
     * Call this method to add CustomBrowser to application
     *
     * @param activity                    base class activity
     * @param cbCustomBrowserConfig       contain the specification of CB
     * @param cbPayUCustomBrowserCallback provide callbacks
     */
    public void addCustomBrowser(Activity activity, @NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {

        if(Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT){
            cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.OS_NOT_SUPPORTED_CODE,CBConstant.OS_NOT_SUPPORTED);
            return;
        }
        String paymentOptionName=null;
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        // CustomBrowserData.SINGLETON.setPayuCustomBrowserConfig(cbCustomBrowserConfig);

        if(null != cbCustomBrowserConfig.getPayuPostData() && cbCustomBrowserConfig.getEnableSurePay() > 0 && (cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)
                || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.MOBILE_TEST_PAYMENT_URL_SEAMLESS) || cbCustomBrowserConfig.getPostURL().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS))){
            // Sometimes post data contains & at the end, just removing it from the postdata
            if(cbCustomBrowserConfig.getPayuPostData().trim().endsWith("&")){
                cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData().substring(0, cbCustomBrowserConfig.getPayuPostData().length() - 1 ));
            }
            // Adding snooze=<snooze_count> in the post data being sent to payu server (_payment)
            cbCustomBrowserConfig.setPayuPostData(cbCustomBrowserConfig.getPayuPostData() + "&snooze=" + cbCustomBrowserConfig.getEnableSurePay());
        }
        UPIUtil upiUtil = new UPIUtil();
        Payment payment = upiUtil.getSupportedPayment(cbCustomBrowserConfig.getPayuPostData());
        paymentOptionName=new CBUtil().getDataFromPostData(cbCustomBrowserConfig.getPayuPostData()).get(UPIPaymentConstants.BANK_CODE);

        if(null!=paymentOptionName && paymentOptionName.equalsIgnoreCase(PaymentOption.SAMSUNGPAY.getPaymentName())){
            if(null!=CustomBrowserData.SINGLETON.getSamsungPayWrapper()) {
                CustomBrowserData.SINGLETON.getSamsungPayWrapper().MakeSamsungPayPayment(activity,cbCustomBrowserConfig);
            }else {
                cbPayUCustomBrowserCallback.onCBErrorReceived(CBConstant.CHECK_PAYMENT_NOT_CALLED,CBConstant.CHECK_PAYMENT_NOT_CALLED_MSG);
            }
        } else if (null != payment && upiUtil.isPaymentMethodSupported(activity, payment)) {
            Intent intent = new Intent(activity, PaymentResponseActivity.class);
            intent.putExtra(CBConstant.POST_DATA, cbCustomBrowserConfig.getPayuPostData());
            activity.startActivity(intent);
        } else if (null != payment && !payment.isWebFlowSupported()) { //Payment is supported but on device its not possible
            cbPayUCustomBrowserCallback.onCBErrorReceived(UPIPaymentConstants.DEVICE_NOT_SUPPORTED_CODE, UPIPaymentConstants.DEVICE_NOT_SUPPORTED);
        } else  {
            CBActivity.cbDrawerAdapter = cbCustomBrowserConfig.getCbMenuAdapter();
            CBActivity.cbConfigToolbarView = cbCustomBrowserConfig.getToolBarView();
            Intent intent = new Intent(activity, CBActivity.class);
            intent.putExtra("cb_config", cbCustomBrowserConfig);
            if (cbCustomBrowserConfig.getReviewOrderDefaultViewData() != null && cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas() != null) {
                intent.putExtra(CBConstant.ORDER_DETAILS, cbCustomBrowserConfig.getReviewOrderDefaultViewData().getReviewOrderDatas());
            }
            activity.startActivity(intent);
        }
    }


}
