/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.util;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.support.v7.app.NotificationCompat;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import com.payu.custombrowser.R;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.SharedPreferenceUtil;
import com.payu.custombrowser.util.SnoozeConfigMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CBUtil {
    public static final String CB_PREFERENCE = "com.payu.custombrowser.payucustombrowser";
    private static SharedPreferences sharedPreferences;

    public static String getSystemCurrentTime() {
        try {
            Date currentDate = new Date(System.currentTimeMillis());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = df.format(currentDate);
            return date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getLogMessage(Context context, String key, String value, String bank, String sdkMerchantKey, String trnxID, String pageType) {
        try {
            JSONObject eventAnalytics = new JSONObject();
            eventAnalytics.put("payu_id", (Object)this.getCookie("PAYUID", context));
            eventAnalytics.put("txnid", (Object)trnxID);
            eventAnalytics.put("merchant_key", (Object)sdkMerchantKey);
            eventAnalytics.put("page_type", (Object)pageType);
            eventAnalytics.put("event_key", (Object)key);
            eventAnalytics.put("event_value", (Object)URLEncoder.encode(value, "UTF-8"));
            eventAnalytics.put("bank", (Object)(bank == null ? "" : bank));
            eventAnalytics.put("package_name", (Object)context.getPackageName());
            eventAnalytics.put("ts", (Object)CBUtil.getSystemCurrentTime());
            return eventAnalytics.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static String decodeContents(FileInputStream fileInputStream) {
        StringBuilder decoded = new StringBuilder();
        try {
            int c;
            int i = 0;
            while ((c = fileInputStream.read()) != -1) {
                if (i % 2 == 0) {
                    decoded.append((char)(c - (i % 5 + 1)));
                } else {
                    decoded.append((char)(c + (i % 5 + 1)));
                }
                ++i;
            }
            fileInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return decoded.toString();
    }

    public static void setAlpha(float alpha, View view) {
        if (Build.VERSION.SDK_INT < 11) {
            AlphaAnimation animation = new AlphaAnimation(alpha, alpha);
            animation.setDuration(10L);
            animation.setFillAfter(true);
            view.startAnimation((Animation)animation);
        } else {
            view.setAlpha(alpha);
        }
    }

    public static String updateLastUrl(String lastUrl) {
        try {
            if (!lastUrl.contains("||")) {
                if (lastUrl.length() > 128) {
                    return lastUrl.substring(0, 127);
                }
                return lastUrl;
            }
            StringTokenizer st = new StringTokenizer(lastUrl, "||");
            String firstURl = st.nextToken();
            String secondUrl = st.nextToken();
            if (firstURl.length() > 128) {
                firstURl = firstURl.substring(0, 125);
            }
            if (secondUrl.length() > 128) {
                secondUrl = secondUrl.substring(0, 125);
            }
            return firstURl + "||" + secondUrl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void setVariableReflection(String className, String value, String varName) {
        try {
            if (value != null && !value.trim().equals("")) {
                Class<?> aClass = Class.forName(className);
                Field field = aClass.getDeclaredField(varName);
                field.setAccessible(true);
                field.set(null, value);
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String filterSMS(JSONObject mBankJS, String msgBody, Context context) {
        String mPassword = null;
        try {
            Matcher match;
            if (msgBody != null && (match = Pattern.compile(mBankJS.getString(context.getString(R.string.cb_detect_otp)), 2).matcher(msgBody)).find()) {
                String[] regexValues;
                for (String regex : regexValues = mBankJS.getString(context.getString(R.string.cb_find_new_otp)).split("::")) {
                    if (!TextUtils.isEmpty((CharSequence)regex) && (match = Pattern.compile(regex, 2).matcher(msgBody)).find() && !TextUtils.isEmpty((CharSequence)(mPassword = match.group().trim().replaceAll("\\.", "")))) break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mPassword;
    }

    public HttpURLConnection getHttpsConn(String strURL, String postData) {
        try {
            return this.getHttpsConn(strURL, postData, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public HttpURLConnection getHttpsConn(String strURL, String postData, int timeout, String cookiesList) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            if (timeout != -1) {
                conn.setConnectTimeout(timeout);
            }
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (postData != null) {
                conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
            }
            if (cookiesList != null) {
                conn.setRequestProperty("Cookie", cookiesList);
            }
            conn.setDoOutput(true);
            if (postData != null) {
                byte[] postParamsByte = postData.getBytes();
                conn.getOutputStream().write(postParamsByte);
            }
            return conn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public HttpURLConnection getHttpsConn(String strURL, String postData, int timeout) {
        return this.getHttpsConn(strURL, postData, timeout, null);
    }

    public static HttpURLConnection getHttpsConn(String strURL) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            return conn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StringBuffer getStringBufferFromInputStream(InputStream responseInputStream) {
        try {
            int i;
            StringBuffer responseStringBuffer = new StringBuffer();
            byte[] byteContainer = new byte[1024];
            while ((i = responseInputStream.read(byteContainer)) != -1) {
                responseStringBuffer.append(new String(byteContainer, 0, i));
            }
            return responseStringBuffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
    }

    public static List<String> updateRetryData(String data, Context context) {
        CBUtil.setRetryData(data, context);
        return CBUtil.processAndAddWhiteListedUrls(data);
    }

    private static void setRetryData(String data, Context context) {
        if (data == null) {
            SharedPreferenceUtil.addStringToSharedPreference(context, "RETRY_SETTINGS", "RETRY_WHITELISTED_URLS", "");
        } else {
            SharedPreferenceUtil.addStringToSharedPreference(context, "RETRY_SETTINGS", "RETRY_WHITELISTED_URLS", data);
        }
        L.v("#### PAYU", "DATA UPDATED IN SHARED PREFERENCES");
    }

    public void clearCookie() {
        CookieManager cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeSessionCookies(null);
        } else {
            cookieManager.removeSessionCookie();
        }
    }

    public static List<String> processAndAddWhiteListedUrls(String data) {
        if (data != null && !data.equalsIgnoreCase("")) {
            String[] urls;
            for (String url : urls = data.split("\\|")) {
                L.v("#### PAYU", "Split Url: " + url);
            }
            if (urls != null && urls.length > 0) {
                List<String> whiteListedUrls = Arrays.asList(urls);
                return whiteListedUrls;
            }
            L.v("#### PAYU", "Whitelisted URLs from JS: " + data);
        }
        return new ArrayList<String>();
    }

    public boolean getBooleanSharedPreference(String key, Context context) {
        sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        return sharedPreferences.getBoolean(key, false);
    }

    public boolean getBooleanSharedPreferenceDefaultTrue(String key, Context context) {
        sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        return sharedPreferences.getBoolean(key, true);
    }

    public void setBooleanSharedPreference(String key, boolean value, Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences(CB_PREFERENCE, 0).edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public String getDeviceDensity(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi + "";
    }

    private void getDownloadSpeed() {
        String[] testing = new String[2];
        long BeforeTime = System.currentTimeMillis();
        long TotalTxBeforeTest = TrafficStats.getTotalTxBytes();
        long TotalRxBeforeTest = TrafficStats.getTotalRxBytes();
        long TotalTxAfterTest = TrafficStats.getTotalTxBytes();
        long TotalRxAfterTest = TrafficStats.getTotalRxBytes();
        long AfterTime = System.currentTimeMillis();
        double TimeDifference = AfterTime - BeforeTime;
        double rxDiff = TotalRxAfterTest - TotalRxBeforeTest;
        double txDiff = TotalTxAfterTest - TotalTxBeforeTest;
        if (rxDiff != 0.0 && txDiff != 0.0) {
            double rxBPS = rxDiff / (TimeDifference / 1000.0);
            double txBPS = txDiff / (TimeDifference / 1000.0);
            testing[0] = String.valueOf(rxBPS) + "bps. Total rx = " + rxDiff;
            testing[1] = String.valueOf(txBPS) + "bps. Total tx = " + txDiff;
        } else {
            testing[0] = "No uploaded or downloaded bytes.";
        }
    }

    public String getNetworkStatus(Context context) {
        try {
            if (null != context) {
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info == null || !info.isConnected()) {
                    return "Not connected";
                }
                if (info.getType() == 1) {
                    return "WIFI";
                }
                if (info.getType() == 0) {
                    int networkType = info.getSubtype();
                    switch (networkType) {
                        case 1: {
                            return "GPRS";
                        }
                        case 2: {
                            return "EDGE";
                        }
                        case 4: {
                            return "CDMA";
                        }
                        case 7: 
                        case 11: {
                            return "2G";
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: {
                            return "HSPA";
                        }
                        case 12: 
                        case 14: 
                        case 15: {
                            return "3G";
                        }
                        case 13: {
                            return "4G";
                        }
                    }
                    return "?";
                }
            }
        }
        catch (Exception e) {
            return "?";
        }
        return "?";
    }

    public NetworkInfo getNetWorkInfo(Context mContext) {
        NetworkInfo network;
        block3: {
            ConnectivityManager connectivityManager;
            block2: {
                Network[] networks;
                connectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
                network = null;
                if (Build.VERSION.SDK_INT < 21) break block2;
                for (Network mNetwork : networks = connectivityManager.getAllNetworks()) {
                    NetworkInfo networkInfo = connectivityManager.getNetworkInfo(mNetwork);
                    if (!networkInfo.getState().equals((Object)NetworkInfo.State.CONNECTED)) continue;
                    network = networkInfo;
                }
                break block3;
            }
            NetworkInfo[] info = connectivityManager.getAllNetworkInfo();
            if (info == null) break block3;
            for (NetworkInfo anInfo : info) {
                if (anInfo.getState() != NetworkInfo.State.CONNECTED) continue;
                network = anInfo;
            }
        }
        return network;
    }

    public int getNetworkStrength(Context mContext) {
        NetworkInfo network = this.getNetWorkInfo(mContext);
        if (network != null) {
            if (network.getTypeName().equalsIgnoreCase("MOBILE")) {
                return this.getMobileStrength(mContext, network);
            }
            if (network.getTypeName().equalsIgnoreCase("wifi") && this.hasPermission(mContext, "android.permission.ACCESS_WIFI_STATE")) {
                WifiManager wifiManager = (WifiManager)mContext.getSystemService("wifi");
                try {
                    WifiInfo connectionInfo = wifiManager.getConnectionInfo();
                    if (connectionInfo != null) {
                        return WifiManager.calculateSignalLevel((int)connectionInfo.getRssi(), (int)5);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
        return 0;
    }

    private boolean hasPermission(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    private int getMobileStrength(Context context, NetworkInfo networkInfo) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            int strength = 0;
            if (Build.VERSION.SDK_INT >= 18) {
                for (CellInfo info : telephonyManager.getAllCellInfo()) {
                    if (!info.isRegistered()) continue;
                    if (info instanceof CellInfoGsm) {
                        CellSignalStrengthGsm gsm = ((CellInfoGsm)info).getCellSignalStrength();
                        strength = gsm.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoCdma) {
                        CellSignalStrengthCdma cdma = ((CellInfoCdma)info).getCellSignalStrength();
                        strength = cdma.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoLte) {
                        CellSignalStrengthLte lte = ((CellInfoLte)info).getCellSignalStrength();
                        strength = lte.getDbm();
                        continue;
                    }
                    if (!(info instanceof CellInfoWcdma)) continue;
                    CellSignalStrengthWcdma wcdma = ((CellInfoWcdma)info).getCellSignalStrength();
                    strength = wcdma.getDbm();
                }
            }
            return strength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setStringSharedPreferenceLastURL(Context context, String key, String url) {
        String str = this.getStringSharedPreference(context, key);
        if (str.equalsIgnoreCase("")) {
            str = url;
        } else if (!str.contains("||")) {
            str = str + "||" + url;
        } else {
            StringTokenizer st = new StringTokenizer(str, "||");
            st.nextToken();
            str = st.nextToken() + "||" + url;
        }
        this.storeInSharedPreferences(context, key, str);
    }

    public String getStringSharedPreference(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        return sharedPreferences.getString(key, "");
    }

    public void setStringSharedPreference(Context context, String key, String value) {
        SharedPreferences.Editor sharedPreferencesEditor = context.getSharedPreferences(CB_PREFERENCE, 0).edit();
        sharedPreferencesEditor.putString(key, value);
        sharedPreferencesEditor.commit();
    }

    public void deleteSharedPrefKey(Context context, String key) {
        try {
            SharedPreferences.Editor sharedPreferencesEditor = context.getSharedPreferences(CB_PREFERENCE, 0).edit();
            sharedPreferencesEditor.remove(key);
            sharedPreferencesEditor.apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void storeInSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public void removeFromSharedPreferences(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(CB_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(key);
        editor.apply();
    }

    public Drawable getDrawableCB(Context context, int resID) {
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getDrawable(resID);
        }
        return context.getResources().getDrawable(resID, context.getTheme());
    }

    public void cancelTimer(Timer timer) {
        if (timer != null) {
            timer.cancel();
            timer.purge();
        }
    }

    public String readFileInputStream(Context mContext, String fileName, int contextMode) {
        String temp = "";
        try {
            int c;
            File file = new File(mContext.getFilesDir(), fileName);
            if (!file.exists()) {
                mContext.openFileOutput(fileName, contextMode);
            }
            FileInputStream fileInputStream = mContext.openFileInput(fileName);
            while ((c = fileInputStream.read()) != -1) {
                temp = temp + Character.toString((char)c);
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return temp;
    }

    public void writeFileOutputStream(InputStream inputStream, Context context, String fileName, int contextMode) {
        try {
            int len;
            GZIPInputStream responseInputStream = new GZIPInputStream(inputStream);
            byte[] buf = new byte[1024];
            FileOutputStream outputStream = context.openFileOutput(fileName, contextMode);
            while ((len = responseInputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            responseInputStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetPayuID() {
        this.clearCookie();
    }

    public String getCookieList(Context appContext, String domainName) {
        String cookieString = "";
        try {
            String cookies;
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)appContext);
                CookieSyncManager.getInstance().sync();
            }
            if ((cookies = cookieManager.getCookie(domainName)) != null) {
                String[] temp;
                for (String ar1 : temp = cookies.split(";")) {
                    String[] cookiesNameValue = ar1.split("=");
                    cookieString = cookieString + cookiesNameValue[0] + "=" + cookiesNameValue[1] + ";";
                }
            }
            if (cookieString.length() > 0) {
                cookieString = cookieString.substring(0, cookieString.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cookieString;
    }

    public String getCookie(String cookieName, Context context) {
        String cookieValue = "";
        try {
            String cookies;
            String siteName = "https://secure.payu.in";
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)context);
                CookieSyncManager.getInstance().sync();
            }
            if ((cookies = cookieManager.getCookie(siteName)) != null) {
                String[] temp;
                for (String ar1 : temp = cookies.split(";")) {
                    if (!ar1.contains(cookieName)) continue;
                    String[] temp1 = ar1.split("=");
                    cookieValue = temp1[1];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cookieValue;
    }

    @Deprecated
    public String getDataFromPostData(String postData, String key) {
        String[] list;
        for (String item : list = postData.split("&")) {
            String id2;
            String[] items = item.split("=");
            if (items.length < 2 || !(id2 = items[0]).equalsIgnoreCase(key)) continue;
            return items[1];
        }
        return "";
    }

    public HashMap<String, String> getDataFromPostData(String postData) {
        HashMap<String, String> postParamsMap = new HashMap<String, String>();
        if (null != postData) {
            StringTokenizer tokens = new StringTokenizer(postData, "&");
            while (tokens.hasMoreTokens()) {
                String[] keyValue = tokens.nextToken().split("=");
                if (null == keyValue || keyValue.length <= 0 || null == keyValue[0]) continue;
                postParamsMap.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
            }
        }
        return postParamsMap;
    }

    public void showNotification(Context context, Intent intent, String title, String txt, int smallIcon, boolean autoCancel, NotificationCompat.Style style2, int color, int ID) {
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context);
        mBuilder.setContentTitle((CharSequence)title).setContentText((CharSequence)txt).setSmallIcon(smallIcon).setPriority(1).setDefaults(2);
        if (autoCancel) {
            mBuilder.setAutoCancel(autoCancel);
        }
        if (style2 != null) {
            mBuilder.setStyle(style2);
        }
        if (color != -1) {
            mBuilder.setColor(color);
        }
        PendingIntent notifyPendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        mBuilder.setContentIntent(notifyPendingIntent);
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        mNotificationManager.notify(ID, mBuilder.build());
    }

    public SnoozeConfigMap storeSnoozeConfigInSharedPref(Context context, String snoozeConfig) {
        SnoozeConfigMap snoozeConfigMap = new SnoozeConfigMap();
        try {
            JSONObject snoozeConfigObject = new JSONObject(snoozeConfig);
            SharedPreferenceUtil.removeAllFromSharedPref(context, "com.payu.custombrowser.snoozepref");
            snoozeConfigMap = this.storeSnoozeConfigInSharedPref(context, snoozeConfigObject.getJSONArray("default"), snoozeConfigMap);
            snoozeConfigObject.remove("default");
            Iterator snoozeConfigIterator = snoozeConfigObject.keys();
            if (snoozeConfigIterator.hasNext()) {
                snoozeConfigMap = this.storeSnoozeConfigInSharedPref(context, snoozeConfigObject.getJSONArray((String)snoozeConfigIterator.next()), snoozeConfigMap);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return snoozeConfigMap;
    }

    private SnoozeConfigMap storeSnoozeConfigInSharedPref(Context context, JSONArray configArray, SnoozeConfigMap snoozeConfigMap) {
        String urlCollections = "";
        String progressPercent = "";
        String timeOut = "";
        String url = "";
        int surePayEnableMode = 0;
        try {
            int snoozeDefaultArrayLength = configArray.length();
            for (int i = 0; i < snoozeDefaultArrayLength; ++i) {
                JSONObject currentSnoozeConfigObject = configArray.getJSONObject(i);
                urlCollections = currentSnoozeConfigObject.get("url").toString();
                progressPercent = currentSnoozeConfigObject.get("progress_percent").toString();
                timeOut = currentSnoozeConfigObject.get("time_out").toString();
                if (currentSnoozeConfigObject.has("disable_sp_for")) {
                    JSONObject surePayEnableModeObject = currentSnoozeConfigObject.getJSONObject("disable_sp_for");
                    surePayEnableMode = this.getSurePayEnableMode(surePayEnableModeObject);
                }
                StringTokenizer snoozeTokenizer = new StringTokenizer(urlCollections, "||");
                while (snoozeTokenizer.hasMoreTokens()) {
                    url = snoozeTokenizer.nextToken();
                    SharedPreferenceUtil.addStringToSharedPreference(context, "com.payu.custombrowser.snoozepref", url.contentEquals("*") ? "*" : url.trim(), progressPercent.trim() + "||" + timeOut.trim() + "||" + surePayEnableMode);
                    snoozeConfigMap.put(url.contentEquals("*") ? "*" : url.trim(), progressPercent.trim() + "||" + timeOut.trim() + "||" + surePayEnableMode);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return snoozeConfigMap;
    }

    public SnoozeConfigMap convertToSnoozeConfigMap(Map<String, ?> snoozeMap) {
        SnoozeConfigMap snoozeConfigMap = new SnoozeConfigMap();
        for (Map.Entry<String, ?> entry : snoozeMap.entrySet()) {
            snoozeConfigMap.put(entry.getKey(), entry.getValue());
        }
        return snoozeConfigMap;
    }

    public Set<String> getSurePayErrorCodes() {
        HashSet<String> showSurePayErrorCodesSet = new HashSet<String>();
        showSurePayErrorCodesSet.add("-7");
        showSurePayErrorCodesSet.add("-8");
        showSurePayErrorCodesSet.add("-15");
        return showSurePayErrorCodesSet;
    }

    private int getSurePayEnableMode(JSONObject jsonObject) {
        try {
            if (jsonObject.has("warn") && jsonObject.getBoolean("warn") && jsonObject.has("fail") && jsonObject.getBoolean("fail")) {
                return 3;
            }
            if (jsonObject.has("fail") && jsonObject.getBoolean("fail")) {
                return 2;
            }
            if (jsonObject.has("warn") && jsonObject.getBoolean("warn")) {
                return 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return 0;
    }

    public int getSurePayDisableStatus(SnoozeConfigMap snoozeConfigMap, String webViewUrl) {
        if (null != snoozeConfigMap && webViewUrl != null) {
            for (Object key : snoozeConfigMap.keySet()) {
                if (!webViewUrl.startsWith(key.toString())) continue;
                int[] snoozeConfig = snoozeConfigMap.getPercentageAndTimeout(key.toString());
                return snoozeConfig[2];
            }
            int[] snoozeConfig = snoozeConfigMap.getPercentageAndTimeout("*");
            return snoozeConfig[2];
        }
        return 0;
    }

    public String getValueOfJSONKey(String data, String key) throws JSONException {
        JSONObject jsonObject = new JSONObject(data);
        if (jsonObject.has(key)) {
            return jsonObject.get(key).toString();
        }
        throw new JSONException("Key not found");
    }

    public static void launchPlayStore(Context context) {
        CBUtil.launchPlayStore(context, null, null);
    }

    public static void launchPlayStore(Context context, String url, String webViewVersion) {
        String packageName = CBUtil.getPackageNameFromPlayStoreLink(url);
        packageName = null == packageName ? "" : "details?id=" + packageName;
        CBUtil.setWebViewVersionInSP(context, webViewVersion);
        try {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://" + packageName))));
        }
        catch (ActivityNotFoundException e) {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/" + packageName))));
        }
    }

    public static boolean isPlayStoreUrl(String url) {
        return url.startsWith("https://play.google.com") || url.startsWith("market://");
    }

    public static String getPackageNameFromPlayStoreLink(String url) {
        Matcher m = Pattern.compile("((?<=[?&]id=)[^&]+)").matcher(url);
        return m.find() ? m.group(1) : null;
    }

    public static String getWebViewVersion(WebView view) {
        String userAgent = view.getSettings().getUserAgentString();
        Matcher m = Pattern.compile("(Chrome\\/(.*?)\\s)").matcher(userAgent);
        return m.find() ? m.group(2) : null;
    }

    public static void setWebViewVersionInSP(Context context, String webViewVersion) {
        if (null != webViewVersion) {
            SharedPreferenceUtil.addStringToSharedPreference(context, CB_PREFERENCE, "webview_version", webViewVersion);
        }
    }

    public static String getWebViewVersionFromSP(Context context) {
        return SharedPreferenceUtil.getStringFromSharedPreference(context, CB_PREFERENCE, "webview_version", "");
    }

    public static String getBase64DecodedString(String data) {
        return new String(Base64.decode((String)data, (int)0));
    }
}

