package com.payu.custombrowser;

import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;

import org.json.JSONObject;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;

public class CBActivity extends FragmentActivity implements MagicRetryFragment.ActivityCallback{

    public static int STATE;
    CustomBrowserConfig customBrowserConfig;
    private Bank payUCustomBrowser;
    private android.support.v7.app.AlertDialog snoozeDialog;
    private AlertDialog backButtonAlertDialog;
    CBUtil cbUtil;

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
        STATE = CBConstant.STATE_RESUMED;
    }

    @Override
    protected void onPause() {
        super.onPause();
        STATE = CBConstant.STATE_PAUSED;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // TODO: provide support for saveInstance as well
        // To avoid recreating activity using saveInstanceState
        super.onCreate(null);

        setContentView(com.payu.custombrowser.R.layout.cb_payments);
        payUCustomBrowser = new Bank();
        cbUtil=new CBUtil();

        // reset payuId when transaction is initiated to avoid old payuID
        cbUtil.resetPayuID();

        Bundle bundle = new Bundle();
        customBrowserConfig = getIntent().getParcelableExtra("cb_config");
        bundle.putParcelable("cb_config", customBrowserConfig);
        payUCustomBrowser.setArguments(bundle);
        getSupportFragmentManager().beginTransaction().add(com.payu.custombrowser.R.id.main_frame, payUCustomBrowser).commit();

    }

    public void showBackButtonDialog() {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this);
        alertDialog.setCancelable(false);
        alertDialog.setMessage("Do you really want to cancel the transaction ?");
        alertDialog.setPositiveButton("Ok", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
                }

                payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_OK_CLICK.toLowerCase());
                CBActivity.this.finish();
            }
        });
        alertDialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK.toLowerCase());
                // cbAnalytics.log(CBUtil.getLogMessage(getBaseContext().getApplicationContext(), CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK.toLowerCase(), payUCustomBrowser.getBankName(), Bank.keyAnalytics, Bank.transactionID, payUCustomBrowser.getPageType()));
                if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
                }
            }
        });
        payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase());

        // cbAnalytics.log(CBUtil.getLogMessage(getBaseContext().getApplicationContext(), CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK.toLowerCase(), payUCustomBrowser.getBankName(), Bank.keyAnalytics, Bank.transactionID, payUCustomBrowser.getPageType()));
        if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(alertDialog);
        }
        backButtonAlertDialog = alertDialog.create();
        alertDialog.show();
    }

    @Override
    public void onBackPressed() {

        if (customBrowserConfig != null && customBrowserConfig.getDisableBackButtonDialog() != 1) {
            showBackButtonDialog();
        } else {
            CBActivity.this.finish();
        }

    }

    /**
     * CallBack for magic retry
     */
    public void showMagicRetry() {
        payUCustomBrowser.showMagicRetry();
    }

    /**
     * CallBack for magic retry
     */
    public void hideMagicRetry() {
        payUCustomBrowser.hideMagicRetry();
    }


    @Override
    public void onDestroy() {
        if (backButtonAlertDialog != null && backButtonAlertDialog.isShowing()) {
            backButtonAlertDialog.dismiss();
            backButtonAlertDialog.cancel();
        }
        if (snoozeDialog != null && snoozeDialog.isShowing()) {
            snoozeDialog.dismiss();
            snoozeDialog.cancel();
        }
        STATE = CBConstant.STATE_DESTROYED;
        if (payUCustomBrowser != null && payUCustomBrowser.getSnoozeLoaderView() != null) {
            payUCustomBrowser.getSnoozeLoaderView().cancelAnimation();
        }

        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null)
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();

        // if any notification from snooze service lets clear it.
        NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);

        // Remove slow user warning notification
        mNotificationManager.cancel(63);
        
        super.onDestroy();
    }

    // Will be called from snoozeService.
    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        //(new CBUtil()).clearCookie();
        if (null != intent && intent.getStringExtra(CBConstant.SENDER).contentEquals(CBConstant.SNOOZE_SERVICE)) { // it is from snooze service
            payUCustomBrowser.killSnoozeService();
            if (intent.getExtras().getBoolean(CBConstant.VERIFICATION_MSG_RECEIVED)) {
                if (payUCustomBrowser != null) {
                    payUCustomBrowser.dismissSnoozeWindow();
                }
                showTransactionStatusDialog(intent.getExtras().getString(CBConstant.PAYU_RESPONSE), intent);
            } else {
                customBrowserConfig = intent.getExtras().getParcelable("cb_config");
                payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_NOTIFICATION_ACTION, CBAnalyticsConstant.SNOOZE_TRANSACTION_RESUMED);

                if (intent.getStringExtra(CBConstant.CURRENT_URL) != null) {
                    if (intent.getStringExtra(CBConstant.CURRENT_URL).equalsIgnoreCase(customBrowserConfig.getPostURL())) {
                        if (customBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || customBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)) {
                            // mark the previous txn as sure_pay canceled.
                            payUCustomBrowser.markPreviousTxnAsUserCanceled(cbUtil.getLogMessage(getApplicationContext(), CBAnalyticsConstant.SURE_PAY_CANCELLED, customBrowserConfig.getTransactionID(), "", Bank.keyAnalytics, customBrowserConfig.getTransactionID(), ""));
                        }
                        payUCustomBrowser.reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
                    } else {
                        if (Bank.isUrlWhiteListed(intent.getStringExtra(CBConstant.CURRENT_URL))) {
                            payUCustomBrowser.reloadWebView(intent.getStringExtra(CBConstant.CURRENT_URL));
                        } else {
                            if (customBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || customBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)) {
                                // mark the previous txn as sure_pay canceled.
                                payUCustomBrowser.markPreviousTxnAsUserCanceled(cbUtil.getLogMessage(getApplicationContext(), CBAnalyticsConstant.SURE_PAY_CANCELLED, customBrowserConfig.getTransactionID(), "", Bank.keyAnalytics, customBrowserConfig.getTransactionID(), ""));
                            }
                            payUCustomBrowser.reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
                        }
                    }
                } else {
                    payUCustomBrowser.reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
                }
            }
        }
    }


    /**
     * launch the dialog which shows transaction status
     *
     * @param payuResponse reponse from verify API
     * @param intent       intent from nitification click
     */
    private void showTransactionStatusDialog(final String payuResponse, Intent intent) {
        try {
            payUCustomBrowser.setTransactionStatusReceived(true);
            final JSONObject jsonObject = new JSONObject(payuResponse.toString());
            if (jsonObject.has("api_status")) {
                LayoutInflater layoutInflater = getLayoutInflater();
                View snoozeLayout = layoutInflater.inflate(R.layout.cb_layout_snooze, null);
                final android.support.v7.app.AlertDialog.Builder builder = new android.support.v7.app.AlertDialog.Builder(this);
                builder.setView(snoozeLayout);
                snoozeDialog = builder.create();
                int verifyApiStatus = 0;
                if (jsonObject.has(getString(R.string.cb_snooze_verify_api_status))) {
                    verifyApiStatus = Integer.parseInt(jsonObject.get(getString(R.string.cb_snooze_verify_api_status)).toString());
                }
                // success transaction api status 1 and failure api status 0
                if (verifyApiStatus == 1) {
                    // Logging notification action for bank confirmed screen.
                    payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_NOTIFICATION_ACTION, CBAnalyticsConstant.SUCCESS_SCREEN);
                    // reload data if url is whitelisted URL or kitkat. In case of kitkat we dont reload. rather we post the data to
                    if (payUCustomBrowser.isUrlWhiteListed(payUCustomBrowser.getCurrentURL()) && 19 != android.os.Build.VERSION.SDK_INT) { // Check for whitelisted URL
                        payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_TRANSACTION_STATUS_UPDATE, CBAnalyticsConstant.SNOOZE_RELOAD);
                        payUCustomBrowser.dismissSnoozeWindow();
                        payUCustomBrowser.progressBarVisibilityPayuChrome(View.GONE, "");
                        payUCustomBrowser.reloadWebView();
                    } else { // Make API call to post data if it is not whitelisted URL
                        payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_TRANSACTION_STATUS_UPDATE,CBAnalyticsConstant.SNOOZE_POST_SURL);
                        if (jsonObject.has(CBConstant.RESPONSE)) {
                            setCheckFURLSURL(jsonObject.getString(CBConstant.RESPONSE), new CBUtil().getDataFromPostData(customBrowserConfig.getPayuPostData(), "surl"));
                        }

                        snoozeLayout.findViewById(R.id.snooze_status_icon).setVisibility(View.VISIBLE);
                        // snoozeLayout.findViewById(R.id.snooze_status_icon).setVisibility(View.GONE);
                        ((TextView) snoozeLayout.findViewById(R.id.snooze_header_txt)).setText(R.string.cb_transaction_sucess);
                        snoozeLayout.findViewById(R.id.text_view_cancel_snooze_window).setVisibility(View.GONE);
                        ((TextView) snoozeLayout.findViewById(R.id.text_view_snooze_message)).setText(getString(R.string.cb_transaction_success_msg));
                        snoozeLayout.findViewById(R.id.snooze_loader_view).setVisibility(View.GONE);
                        snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(View.GONE);
                        snoozeLayout.findViewById(R.id.text_view_retry_message_detail).setVisibility(View.GONE);
                        snoozeLayout.findViewById(R.id.button_retry_transaction).setVisibility(View.GONE);
                        snoozeLayout.findViewById(R.id.button_cancel_transaction).setVisibility(View.GONE);
                        snoozeLayout.findViewById(R.id.t_confirm).setVisibility(View.GONE);
                        snoozeLayout.findViewById(R.id.t_nconfirm).setVisibility(View.GONE);

                        snoozeDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                            @Override
                            public void onDismiss(DialogInterface dialogInterface) {
                                try {
                                    if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                                        CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentSuccess(jsonObject.getString("response"), "");
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                snoozeDialog.dismiss();
                                snoozeDialog.cancel();
                                CBActivity.this.finish();

                            }
                        });
                        snoozeDialog.setCanceledOnTouchOutside(false);
                        snoozeDialog.show();


                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                if (snoozeDialog != null && snoozeDialog.isShowing()) {
                                    snoozeDialog.cancel();
                                    snoozeDialog.dismiss();
                                    CBActivity.this.finish();
                                }
                            }
                        }, 5000);
                    }
                } else {
                    // Loggging notification action for bank not confirmed screen
                    payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_NOTIFICATION_ACTION, CBAnalyticsConstant.TXN_NOT_CONFIRMED);

                    snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(View.VISIBLE);
                    snoozeLayout.findViewById(R.id.snooze_status_icon).setVisibility(View.VISIBLE);
                    snoozeLayout.findViewById(R.id.text_view_cancel_snooze_window).setVisibility(View.GONE);
                    snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(View.GONE);

                    ((TextView) snoozeLayout.findViewById(R.id.snooze_header_txt)).setText(R.string.cb_transaction_failed_title);
                    ((TextView) snoozeLayout.findViewById(R.id.text_view_snooze_message)).setText(R.string.cb_transaction_failed);
                    //  ((TextView) snoozeLayout.findViewById(R.id.text_view_transaction_snoozed_message1)).setText(R.string.cb_transaction_failed_retry);
                    // ((TextView) snoozeLayout.findViewById(R.id.text_view_retry_message_detail)).setText(R.string.cb_transaction_failed_debited);

                    // if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() == null) {
                    snoozeLayout.findViewById(R.id.button_retry_transaction).setVisibility(View.GONE);
                    snoozeLayout.findViewById(R.id.button_cancel_transaction).setVisibility(View.VISIBLE);
                    snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(View.GONE);
                    snoozeLayout.findViewById(R.id.text_view_retry_message_detail).setVisibility(View.GONE);
                    snoozeLayout.findViewById(R.id.text_view_transaction_snoozed_message1).setVisibility(View.GONE);
                    snoozeLayout.findViewById(R.id.text_view_ac_debited_twice).setVisibility(View.GONE);

                    //  }
                 /*   snoozeLayout.findViewById(R.id.button_retry_transaction).setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            snoozeDialog.dismiss();
                            snoozeDialog.cancel();
                            Long interationTime=(System.currentTimeMillis() - snoozeWindowAppearTime) / 1000;
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME,  interationTime+"");
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_RETRY_CLICK);
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_RETRY_NOW_URL, customBrowserConfig.getPostURL());

                            if (payUCustomBrowser == null) {
                                setContentView(com.payu.custombrowser.R.layout.cb_payments);
                                payUCustomBrowser = new Bank();
                                getSupportFragmentManager().beginTransaction().add(com.payu.custombrowser.R.id.main_frame, payUCustomBrowser).commit();
                            } else {
                                payUCustomBrowser.reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
                            }

                            // getSupportFragmentManager().beginTransaction().replace(com.payu.custombrowser.R.id.main_frame, payUCustomBrowser).commit();
                        }
                    });
*/
                    snoozeLayout.findViewById(R.id.button_cancel_transaction).setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, Bank.getSystemCurrentTime());

                            // finish Activity
                            payUCustomBrowser.addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CANCEL_TRANSACTION_CLICK);
                            //showBackButtonDialog();
                            snoozeDialog.dismiss();
                            snoozeDialog.cancel();
                            CBActivity.this.finish();
                        }
                    });
                    snoozeDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                        @Override
                        public void onDismiss(DialogInterface dialogInterface) {
                            snoozeDialog.dismiss();
                            snoozeDialog.cancel();

                        }
                    });

                    snoozeDialog.setCanceledOnTouchOutside(false);
                    snoozeDialog.show();
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (snoozeDialog != null && snoozeDialog.isShowing()) {
                                snoozeDialog.cancel();
                                snoozeDialog.dismiss();
                                CBActivity.this.finish();
                            }
                        }
                    }, 5000);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Post data to surl(success URL)
     *
     * @param postData data to be poted on success url
     * @param surl     success url
     */
    public void setCheckFURLSURL(final String postData, final String surl) {

        new Thread(new Runnable() {
            @Override
            public void run() {
                String responseStringBuffer = "";
                try {
                    URL url = new URL(URLDecoder.decode(surl, "UTF-8"));
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    String post = postData;
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Content-Length", String.valueOf(post.length()));
                    conn.setDoOutput(true);
                    byte[] postParamsByte = post.getBytes();
                    conn.getOutputStream().write(postParamsByte);
                    //   if (conn.getResponseCode() != 200) {
                    //    setCheckFURLSURL(postData, surl);
                    // }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }).start();

    }
}
