/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import com.payu.custombrowser.Bank;
import com.payu.magicretry.MagicRetryFragment;
import com.payu.magicretry.WebClient.MagicRetryWebViewClient;

public class PayUWebViewClient
extends MagicRetryWebViewClient {
    private boolean loadingFinished = true;
    private boolean redirect = false;
    private String mainUrl = "";
    private Bank bank;
    private boolean isMerchantUrlStarted;

    public PayUWebViewClient(Bank bank, @NonNull @Size(min=6L, max=6L) String merchantKey) {
        this.bank = bank;
        this.bank.setAnalyticsKey(merchantKey);
    }

    public PayUWebViewClient(Bank bank, MagicRetryFragment magicRetryFragment, @NonNull @Size(min=6L, max=6L) String merchantKey) {
        super(magicRetryFragment);
        this.bank = bank;
        this.bank.setAnalyticsKey(merchantKey);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.loadingFinished = false;
        if (this.bank != null) {
            this.bank.onPageStartedWebclient(url);
            if (this.bank.isPayuResponseReceived()) {
                this.isMerchantUrlStarted = true;
            }
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!this.redirect) {
            this.loadingFinished = true;
        }
        if (url.equals(this.mainUrl)) {
            this.loadingFinished = true;
            this.redirect = false;
        } else {
            this.redirect = false;
        }
        if (this.bank != null) {
            this.bank.onPageFinishWebclient(url);
            if (this.isMerchantUrlStarted) {
                this.bank.onMerchantUrlFinished();
            }
        }
    }

    public void onLoadResource(WebView view, String url) {
        if (this.bank != null) {
            this.bank.onLoadResourse(url);
        }
        super.onLoadResource(view, url);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (this.bank != null) {
            this.bank.onReceivedErrorWebClient();
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        if (this.bank != null) {
            this.bank.onReceivedErrorWebClient();
        }
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        if (Build.VERSION.SDK_INT <= 10) {
            handler.proceed();
        } else if (Build.VERSION.SDK_INT >= 14) {
            if (error.getUrl().contains("https://jsbeasynet.jsbnet.in")) {
                handler.proceed();
            } else if (this.bank != null) {
                this.bank.onReceivedErrorWebClient();
            }
        } else if (error.getCertificate().toString().contains("jsbeasynet.jsbnet.in")) {
            handler.proceed();
        } else if (this.bank != null) {
            this.bank.onReceivedErrorWebClient();
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        this.mainUrl = url;
        if (!this.loadingFinished) {
            this.redirect = true;
        }
        this.loadingFinished = false;
        if (this.bank != null) {
            this.bank.onOverrideURL(url);
        }
        return super.shouldOverrideUrlLoading(view, url);
    }
}

