// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.content.Context;
import android.view.View;


/**
 * Created by minie on 2/3/15.
 * A controller for {@link DotsProgressBar }
 */
public class CustomProgressBar {

    /**
     * Display progress dialog.
     * @param mContext base activity context
     * @param view instance of view
     */
    public static void showDialog(final Context mContext, final View view) {
        view.setVisibility(View.VISIBLE);
        showProgressDialogNew(mContext, view);
    }

    /**
     * Set dots count as 5
     * then start animation.
     * @param mContext base activity context
     * @param view progress dialog view
     */
    private static void showProgressDialogNew(Context mContext, View view) {
        DotsProgressBar progressBar = (DotsProgressBar) view.findViewById(R.id.dotsProgressBar);
        progressBar.setDotsCount(5);
        progressBar.start();
    }

    /**
     * Hide progress dialog.
     * @param view progress dialog view
     */

    public static void removeDialog(View view) {
        view.setVisibility(View.GONE);
    }
}


